<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cluster.php,v 1.1.2.3 2025/04/11 07:42:51 qvarin Exp $

use Pmb\AI\Library\Clusters\Clusters;

if (php_sapi_name() !== 'cli') {
    die('This script can only be run from the command line.');
}

$base_path = __DIR__ . '/../..';
$class_path = $base_path . '/classes';
$include_path = $base_path . '/includes';

$base_noheader = 1;
$base_nocheck = 1;
$base_nobody = 1;
$base_nosession = 1;

global $database;
$database = 'pmb';

ini_set('display_errors', 0);
error_reporting(0);

$_SERVER['REQUEST_URI'] = '';
$_SERVER['HTTP_USER_AGENT'] = '';

require_once($base_path."/includes/init.inc.php");

global $ai_active;
if (!$ai_active) {
	echo 'AI is not active' . PHP_EOL;
	exit;
}

set_time_limit(0);

global $ai_nb_clusters, $ai_nb_epoch;

$ai_nb_clusters = intval($ai_nb_clusters);
$ai_nb_epoch = intval($ai_nb_epoch);

echo '==== Script Start ====' . PHP_EOL;
echo 'Memory limit = ' . ini_get('memory_limit') . PHP_EOL;
echo 'Memory usage = ' . (memory_get_usage() / 1024 / 1024) . 'MB' . PHP_EOL;
echo 'Number of epochs = ' . $ai_nb_epoch . PHP_EOL;
echo 'Number of clusters = ' . $ai_nb_clusters . PHP_EOL;
echo '======================' . PHP_EOL . PHP_EOL;
$start = microtime(true);

$clusters = new Clusters();
$clusters->mode(Clusters::MODE_CLI);
$clusters->cleanClusters();
$clusters->createClusters($ai_nb_clusters, $ai_nb_epoch);

echo PHP_EOL . PHP_EOL;
echo '==== Script End =====' . PHP_EOL;
echo 'Memory usage = ' . (memory_get_usage() / 1024 / 1024) . 'MB' . PHP_EOL;
echo 'Time = ' . (microtime(true) - $start) . 's' . PHP_EOL;
echo '======================' . PHP_EOL . PHP_EOL;