<?php
// +-------------------------------------------------+
//  2002-2005 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: resa_planning.class.php,v 1.13.4.1.4.2 2025/07/01 15:38:47 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path;
require_once($class_path.'/resa.class.php');

class resa_planning{
	public $id_resa = 0;							//Identifiant de prvision
	public $resa_idempr = 0;						//Identifiant du lecteur ayant fait la prvision
	public $resa_idnotice = 0;						//Identifiant de la notice sur laquelle est pose la prvision
	public $resa_idbulletin	= 0	;					//Identifiant de bulletin si applicable
	public $resa_date = NULL;						//Date et heure de la demande
	public $aff_resa_date = '';
	public $resa_date_debut = '0000-00-00';			//Date de dbut de la prvision
	public $aff_resa_date_debut = '';
	public $resa_date_fin = '0000-00-00';			//Date de fin de la prvision
	public $aff_resa_date_fin = '';
	public $resa_validee = 0;						//Prvision valide si 1
	public $resa_confirmee = 0;						//Prvision confirme si 1
	public $resa_loc_retrait = 0;					//Lieu de retrait de la prvision
	public $resa_qty = 1;							//Quantit  rserver
	public $resa_remaining_qty = 1;					//Quantit restante

	public function __construct($id_resa= 0) {
		$this->id_resa = intval($id_resa);
		if ($this->id_resa) {
			$this->load();
		}
	}

	// charge une prvision  partir de la base.
	public function load(){
		global $msg;

		$q = "select resa_idempr, resa_idnotice, resa_idbulletin, resa_date, date_format(resa_date, '".$msg["format_date"]."') as aff_resa_date, resa_date_debut, date_format(resa_date_debut, '".$msg["format_date"]."') as aff_resa_date_debut, resa_date_fin, date_format(resa_date_fin, '".$msg["format_date"]."') as aff_resa_date_fin, resa_validee, resa_confirmee, resa_loc_retrait, resa_qty, resa_remaining_qty from resa_planning where id_resa = '".$this->id_resa."' ";
		$r = pmb_mysql_query($q) ;
		$obj = pmb_mysql_fetch_object($r);
		$this->resa_idempr = $obj->resa_idempr;
		$this->resa_idnotice = $obj->resa_idnotice;
		$this->resa_idbulletin = $obj->resa_idbulletin;
		$this->resa_date = $obj->resa_date;
		$this->aff_resa_date = $obj->aff_resa_date;
		$this->resa_date_debut = $obj->resa_date_debut;
		$this->aff_resa_date_debut = $obj->aff_resa_date_debut;
		$this->resa_date_fin = $obj->resa_date_fin;
		$this->aff_resa_date_fin = $obj->aff_resa_date_fin;
		$this->resa_validee = $obj->resa_validee;
		$this->resa_confirmee = $obj->resa_confirmee;
		$this->resa_loc_retrait = $obj->resa_loc_retrait;
		$this->resa_qty = $obj->resa_qty;
		$this->resa_remaining_qty  = $obj->resa_remaining_qty ;
	}

	// enregistre une prvision en base.
	public function save(){
		if ($this->id_resa) {
			if ($this->resa_date_debut && $this->resa_date_fin) {
				$this->resa_validee = ($this->resa_validee==1)?1:0;
				$this->resa_confirmee = ($this->resa_confirmee==1)?1:0;
				$q = "update resa_planning set resa_date_debut = '".$this->resa_date_debut."', resa_date_fin = '".$this->resa_date_fin."', ";
				$q.= "resa_validee = '".$this->resa_validee."', resa_confirmee = '".$this->resa_confirmee."', ";
				$q.= "resa_loc_retrait = ".$this->resa_loc_retrait.", resa_qty=".$this->resa_qty.", resa_remaining_qty=".$this->resa_remaining_qty;
				$q.= " where id_resa = '".$this->id_resa."' ";
				pmb_mysql_query($q);
			}
		} else {
			if ($this->resa_idempr && ((!$this->resa_idnotice && $this->resa_idbulletin) || ($this->resa_idnotice && !$this->resa_idbulletin)) && $this->resa_date_debut && $this->resa_date_fin) {
				$q = "insert into resa_planning set resa_idempr = '".$this->resa_idempr."', resa_idnotice = '".$this->resa_idnotice."', resa_idbulletin = '".$this->resa_idbulletin."', resa_date = SYSDATE(), ";
				$q.= "resa_date_debut = '".$this->resa_date_debut."', resa_date_fin = '".$this->resa_date_fin."', resa_validee = '0', resa_confirmee = '0', ";
				$q.= "resa_loc_retrait = ".$this->resa_loc_retrait.", resa_qty=".$this->resa_qty.", resa_remaining_qty=".$this->resa_remaining_qty;
				pmb_mysql_query($q);
				$this->id_resa = pmb_mysql_insert_id();
			}
		}
	}

	//vrifie l'existence d'une prvision en base  partir de son identifiant
	public static function exists($id_resa=0) {
	    $id_resa = intval($id_resa);
	    $q = "SELECT count(1) from resa_planning where id_resa = $id_resa ";
	    $r = pmb_mysql_query($q);
	    return pmb_mysql_result($r, 0, 0);
	}
	
	//supprime une prvision de la base
	public static function delete($id_resa=0) {
		$id_resa = intval($id_resa);
		if($id_resa) {
			$q = "delete from resa_planning where id_resa=$id_resa ";
			pmb_mysql_query($q);
		}
	}

	//Compte le nb de prvisions sur une notice
	public static function count_resa($id_notice=0,$id_bulletin=0) {
		$id_notice = intval($id_notice);
		$id_bulletin = intval($id_bulletin);
		if (!$id_notice && !$id_bulletin) {
			return 0;
		}
		$q = "SELECT count(1) FROM resa_planning WHERE resa_idnotice=$id_notice and resa_idbulletin=$id_bulletin ";
		$r = pmb_mysql_query($q);
		return pmb_mysql_result($r, 0, 0);
	}

	//optimisation de la table resa_planning
	public function optimize() {
		$opt = pmb_mysql_query('OPTIMIZE TABLE resa_planning');
		return $opt;
	}

	//retourne la liste des localisations de retrait possibles pour un emprunteur selon le paramtrage ainsi que la qt d'exemplaires disponibles
	public static function get_available_locations($id_empr=0,$id_notice=0,$id_bulletin=0) {
		global $pmb_location_reservation,$pmb_location_resa_planning;

		$id_empr = intval($id_empr);
		$id_notice = intval($id_notice);
		$id_bulletin = intval($id_bulletin);

		$loc = array();
		if($id_empr && ($id_notice || $id_bulletin)) {
			$q = "select expl_location, location_libelle, count(expl_id) as nb from exemplaires join docs_location on expl_location=idlocation join docs_statut on expl_statut=idstatut ";
			$q.= "where expl_notice=$id_notice and expl_bulletin=$id_bulletin ";
			$q.= "and statut_allow_resa=1";
			if($pmb_location_resa_planning) {
				if ($pmb_location_reservation) {
					$q.=" and expl_location in (select resa_loc from empr,resa_loc where id_empr=$id_empr and empr_location=resa_emprloc)";
				} else {
					$q.=" and expl_location = (select empr_location from empr where id_empr=$id_empr)";
				}
			}
			$q.= ' group by expl_location order by location_libelle';
			$r = pmb_mysql_query($q);
			if(pmb_mysql_num_rows($r)) {
				$i=0;
				while ($o=pmb_mysql_fetch_object($r)) {
					$loc[$i]['location_id']=$o->expl_location;
					$loc[$i]['location_libelle']=$o->location_libelle;
					$loc[$i]['location_nb']=$o->nb;
					$i++;
				}
			}
		}
		return $loc;
	}

	public static function get_formatted_data_from_resa($resa=array(), $id_empr_concerne=0) {
	    global $msg;
	    
	    $formatted_data = array();
	    $tmp_id_resa =implode(",",$resa);
	    $id_empr_concerne = intval($id_empr_concerne);
	    
	    $query = "select distinct ";
	    $query .= "trim(concat(ifnull(notices_m.tit1,''),ifnull(notices_s.tit1,''),' ',ifnull(bulletin_numero,''), if (mention_date, concat(' (',mention_date,')') ,''))) as tit, ";
	    $query .= "date_format(resa_date_fin, '".$msg["format_date"]."') as aff_resa_date_fin, ";
	    $query .= "date_format(resa_date_debut, '".$msg["format_date"]."') as aff_resa_date_debut, ";
	    $query .= "id_empr, empr_prenom, empr_nom, empr_cb, empr_mail, empr_tel1, empr_sms, id_resa, ";
	    $query .= "trim(concat(ifnull(notices_m.niveau_biblio,''), ifnull(notices_s.niveau_biblio,''))) as niveau_biblio, ";
	    $query .= "trim(concat(ifnull(notices_m.notice_id,''), ifnull(notices_s.notice_id,''))) as id_notice ";
	    $query .= "from (((resa_planning LEFT JOIN notices AS notices_m ON resa_idnotice = notices_m.notice_id ) LEFT JOIN bulletins ON resa_idbulletin = bulletins.bulletin_id) LEFT JOIN notices AS notices_s ON bulletin_notice = notices_s.notice_id), empr ";
	    $query .= "where id_resa in (".$tmp_id_resa.") and resa_validee=1 and resa_idempr=id_empr";
	    if ($id_empr_concerne) {
	        $query .= "and id_empr=$id_empr_concerne ";
	    }
	    $result = pmb_mysql_query($query);
	    if (pmb_mysql_num_rows($result)) {
	        while ($o=pmb_mysql_fetch_object($result)) {
	            $formatted_data[] = $o;
	        }
	    }
	    return $formatted_data;
	}
	
	public static function get_reader_to_alert($id_resa=0) {
	    global $pdflettreresa_priorite_email_manuel;
	    
	    $id_resa = intval($id_resa);
	    if(!$id_resa) {
	        return [];
	    }
	    if ($pdflettreresa_priorite_email_manuel==3) {
	        return [];
	    }
	    $formatted_data = static::get_formatted_data_from_resa([$id_resa]);
	    if (!empty($formatted_data[0])) {
	        if (($pdflettreresa_priorite_email_manuel==1 || $pdflettreresa_priorite_email_manuel==2) && $formatted_data[0]->empr_mail) {
	            return [
	                'type' => 'mail',
	                'data' => $formatted_data[0]
	            ];
	        } elseif ($pdflettreresa_priorite_email_manuel!=3) {
	            return [
	                'type' => 'pdf',
	                'data' => $formatted_data[0]
	            ];
	        } else {
	            return [
	                'type' => 'nothing',
	                'data' => $formatted_data[0]
	            ];
	        }
	    }
	}
	
	public static function get_readers_to_alert($resa=array(), $id_empr=0) {
	    global $pdflettreresa_priorite_email_manuel;
	    
	    if ($pdflettreresa_priorite_email_manuel==3) {
	        return [];
	    }
	    if(!is_countable($resa) || !count($resa)) {
	        return [];
	    }
	    $formatted_data = static::get_formatted_data_from_resa($resa, $id_empr);
	    $readers = [];
	    foreach ($formatted_data as $o) {
	        if (($pdflettreresa_priorite_email_manuel==1 || $pdflettreresa_priorite_email_manuel==2) && $o->empr_mail) {
	            $readers[] = [
	                'type' => 'mail',
	                'data' => $o
	            ];
	        } elseif ($pdflettreresa_priorite_email_manuel!=3) {
	            $readers[] = [
	                'type' => 'pdf',
	                'data' => $o
	            ];
	        } else {
	            $readers[] = [
	                'type' => 'nothing',
	                'data' => $o
	            ];
	        }
	    }
	    return $readers;
	}
	
	public static function send_mail($o, $action='conf') {
	    switch ($action) {
	        case 'suppr_val_resa':
	            $mail_reader_resa_planning = new mail_reader_resa_planning_deleted();
	            break;
	        case 'raz_conf_resa':
	            $mail_reader_resa_planning = new mail_reader_resa_planning_unconfirmed();
	            break;
	        case 'conf_resa':
	        default:
	            $mail_reader_resa_planning = new mail_reader_resa_planning();
	            break;
	    }
	    $mail_reader_resa_planning->set_mail_to_id($o->id_empr);
	    $mail_reader_resa_planning->set_empr($o);
	    return $mail_reader_resa_planning->send_mail();
	}
	
	public static function open_pdf($tmp_id_resa) {
	    print "<script type='text/javascript'>openPopUp('./pdf.php?pdfdoc=lettre_resa_planning&id_resa=$tmp_id_resa', 'lettre_confirm_resa".$tmp_id_resa."', 600, 500, -2, -2, 'toolbar=no, dependent=yes, resizable=yes, scrollbars=yes');</script>";
	}
	
	//Transformation prevision en reservation(s)
	public function to_resa() {
		//Il faut insrer la prvision avant les rsas dj cres
		$q = 'select date_sub(resa_date,INTERVAL 1 DAY) from resa where resa_idnotice='.$this->resa_idnotice.
				' and resa_idbulletin='.$this->resa_idbulletin.
				' and resa_cb="" order by resa_date limit 1';
		$r = pmb_mysql_query($q);

		if(pmb_mysql_num_rows($r)) {
			//Au moins une resa
			$d=pmb_mysql_result($r,0,0);
		} else {
			$d=date('Y-m-d H:i:s');
		}

		while($this->resa_remaining_qty) {
			$q = 'insert into resa (resa_idempr,resa_idnotice,resa_idbulletin,resa_date,resa_date_debut,resa_date_fin,resa_loc_retrait,resa_planning_id_resa) '.
					'values ('.$this->resa_idempr.','.$this->resa_idnotice.','.$this->resa_idbulletin.',"'.$d.'","'.$this->resa_date_debut.'","'.$this->resa_date_fin.'",'.$this->resa_loc_retrait.','.$this->id_resa.')';
			$r = pmb_mysql_query($q);
			$id_resa = pmb_mysql_insert_id();

			// Archivage de la rsa: info lecteur et notice et nombre d'exemplaire
			$q = "SELECT * FROM empr WHERE id_empr=".$this->resa_idempr;
			$r = pmb_mysql_query($q);
			$empr = pmb_mysql_fetch_object($r);

			$q = "SELECT count(*) FROM exemplaires where expl_notice=".$this->resa_idnotice." and expl_bulletin=".$this->resa_idbulletin;
			$r = pmb_mysql_query($q);
			$nb_expl = pmb_mysql_result($r,0,0);

			$q = "INSERT INTO resa_archive SET
					resarc_id_empr = ".$this->resa_idempr.",
					resarc_idnotice = ".$this->resa_idnotice.",
					resarc_idbulletin = ".$this->resa_idbulletin.",
					resarc_date = '".$d."',
					resarc_debut = '".$this->resa_date_debut."',
					resarc_fin = '".$this->resa_date_fin."',
					resarc_loc_retrait = ".$this->resa_loc_retrait.",
					resarc_from_opac= 0,
					resarc_empr_cp ='".addslashes($empr->empr_cp)."',
					resarc_empr_ville = '".addslashes($empr->empr_ville)."',
					resarc_empr_prof = '".addslashes($empr->empr_prof)."',
					resarc_empr_year = '".$empr->empr_year."',
					resarc_empr_categ = ".$empr->empr_categ.",
					resarc_empr_codestat = ".$empr->empr_codestat.",
					resarc_empr_sexe = '".$empr->empr_sexe."',
					resarc_empr_location = ".$empr->empr_location.",
					resarc_expl_nb = $nb_expl,
					resarc_resa_planning_id_resa = ".$this->id_resa;
			pmb_mysql_query($q);
			$id_resarc = pmb_mysql_insert_id();
			// Lier archive et rsa pour suivre l'volution de la rsa
			$query = "update resa SET resa_arc=$id_resarc where id_resa=".$id_resa;
			pmb_mysql_query($query);

			$this->resa_remaining_qty--;
		}
		$this->save();
	}

	public function get_id() {
	    return $this->id_resa;
	}
}