<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: interface_circ_mailing_form.class.php,v 1.1.2.2 2025/06/25 06:42:08 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path;
require_once($class_path.'/interface/circ/interface_circ_form.class.php');

class interface_circ_mailing_form extends interface_circ_form {
	
    protected $idemprcaddie = 0;
    
    protected $idempr = 0;
    
    protected $mailtpls;
	
	protected function get_submit_action() {
	    if (!empty($this->idemprcaddie)) {
	        return "./mailing.php";
	    }
	    return parent::get_submit_action();
	}
	
	protected function get_js_script() {
	    global $base_path;
	    
	    $js_script = parent::get_js_script();
	    if (!empty($this->mailtpls) && $this->mailtpls->get_count_tpl()) {
	        $js_script .= "
            <script type='text/javascript'>
        		function insert_template(theselector,objet_mail,dest){	
        			var id_mailtpl=0;
        			for (var i=0 ; i< theselector.options.length ; i++){
        				if (theselector.options[i].selected){
        					id_mailtpl=theselector.options[i].value ;
        					break;
        				}
        			}
        			if(!id_mailtpl) return ;
        			var url= '$base_path/ajax.php?module=ajax&categ=mailtpl&quoifaire=get_mailtpl&id_mailtpl='+id_mailtpl;	
        			var action = new http_request();
        			action.request(url,0,'',1,response_tpl,0,0);				
        		}
        		
        		function response_tpl(info){
        			try{ 
        				var info=eval('(' + info + ')');
        			} catch(e){
        				if(typeof console != 'undefined') {
        					console.log(e);
        				}
        			}
        			// objet du mail
        			document.getElementById('f_objet_mail').value=info.objet;			
        			// contenu
        			document.getElementById('f_message').value=info.tpl;	
        			if(typeof(tinyMCE)!= 'undefined')tinyMCE_updateContent('f_message',info.tpl);
        		}
        	</script>";
	    }
	    return $js_script;
	}
	
	protected function get_action_visualize_label() {
	    global $msg;
	    
	    return $msg['empr_mailing_bt_visualiser'];
	}
	
	protected function get_display_visualize_action() {
	    if (!empty($this->idempr)) {
	        $action = './circ/caddie/action/visu_message.php';
	    } else {
	        $action = 'visu_message.php';
	    }
	    $onclick = "document.getElementById('".$this->name."').action='".$action."'; document.getElementById('".$this->name."').target='visu_message'; document.getElementById('".$this->name."').submit();";
	    return $this->get_display_action('visualize_button', $this->get_action_visualize_label(), ['function' => $onclick]);
	}
	
	protected function get_action_send_label() {
	    global $msg;
	    
	    return $msg['empr_mailing_bt_envoyer'];
	}
	
	protected function get_display_send_action() {
	    if (!empty($this->idempr)) {
	        $action = $this->url_base."&action=send&id=".$this->idempr;
	    } else {
	        $action = 'mailing.php';
	    }
	    $onclick = "document.getElementById('".$this->name."').action='".$action."'; document.getElementById('".$this->name."').target='_self'; document.getElementById('".$this->name."').submit();";
	    return $this->get_display_action('send_action', $this->get_action_send_label(), ['function' => $onclick]);
	}
	
	protected function get_display_actions() {
	    global $pmb_javascript_office_editor;
	    
	    $display = "
		<div class='left'>
			".(!$pmb_javascript_office_editor ? $this->get_display_visualize_action() : '')."
		</div>
		<div class='right'>
			".$this->get_display_send_action()."
            <input type='hidden' name='sub' value='envoi' />
			<input type='hidden' name='idemprcaddie' value='".$this->idemprcaddie."' />
		</div>";
	    return $display;
	}
	
	public function set_idemprcaddie($idemprcaddie) {
	    $this->idemprcaddie = intval($idemprcaddie);
	    return $this;
	}
	
	public function set_idempr($idempr) {
	    $this->idempr = intval($idempr);
	    return $this;
	}
	
	public function set_mailtpls($mailtpls) {
	    $this->mailtpls = $mailtpls;
	    return $this;
	}
}