<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: dynamics_fields_list.class.php,v 1.1.2.2 2025/10/17 06:50:42 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class dynamics_fields_list extends dynamics_fields {
    
    protected static function has_chk_mandatory() {
        return true;
    }
    
    public static function val($field) {
        $name=$field['NAME'];
        global ${$name};
        
        $val=${$name};
        
        if (!empty($field['OPTIONS'][0]['MULTIPLE'][0]['value']) && $field['OPTIONS'][0]['MULTIPLE'][0]['value'] == "yes") {
            if (isset($field['OPTIONS'][0]['COLUMN_NAME'][0]['value']) && $field['OPTIONS'][0]['COLUMN_NAME'][0]['value']) {
                if (is_array($val)) {
                    $val_=implode(",",$val);
                } else {
                    $val_="";
                }
                return stripslashes($val_);
            }
            if (is_array($val)) {
                $val_=implode("','",$val);
            } else {
                $val_="";
            }
            if ($val_!="") $val_="'".$val_."'";
            $val_=stripslashes($val_);
            return $val_;
        } else {
            $val=stripslashes($val);
            if (isset($field['OPTIONS'][0]['COLUMN_NAME'][0]['value']) && $field['OPTIONS'][0]['COLUMN_NAME'][0]['value']) {
                return $val;
            }
            return "'".$val."'";
        }
    }
    
    public static function aff($field,&$check_scripts) {
        global $charset;
        
        //pr-remplissage
        $param = $field['NAME'];
        global ${$param};
        
        $sel_param = array();
        if (is_array(${$param})) {
            foreach (${$param} as $aparam) {
                $sel_param[$aparam] = $aparam;
            }
        } else {
            $sel_param[${$param}] = ${$param};
        }
        
        $options=$field['OPTIONS'][0];
        $ret="<select name=\"".$field['NAME'];
        if ($options['MULTIPLE'][0]['value']=="yes") $ret.="[]";
        $ret.="\" ";
        if ($options['MULTIPLE'][0]['value']=="yes") $ret.="multiple";
        $ret.=">\n";
        if (($options['UNSELECT_ITEM'][0]['VALUE']!="")||($options['UNSELECT_ITEM'][0]['value']!="")) {
            $ret.="<option value=\"".htmlentities($options['UNSELECT_ITEM'][0]['VALUE'],ENT_QUOTES,$charset)."\">".htmlentities($options['UNSELECT_ITEM'][0]['value'],ENT_QUOTES,$charset)."</option>\n";
        }
        if (!empty($options['ITEMS'][0]['ITEM']) && is_countable($options['ITEMS'][0]['ITEM'])) {
            for ($i=0; $i<count($options['ITEMS'][0]['ITEM']); $i++) {
                $ret.="<option value=\"".htmlentities($options['ITEMS'][0]['ITEM'][$i]['VALUE'],ENT_QUOTES,$charset)."\" ".(isset($sel_param[$options['ITEMS'][0]['ITEM'][$i]['VALUE']]) && $sel_param[$options['ITEMS'][0]['ITEM'][$i]['VALUE']] == $options['ITEMS'][0]['ITEM'][$i]['VALUE'] ? "selected" : "").">".htmlentities($options['ITEMS'][0]['ITEM'][$i]['value'],ENT_QUOTES,$charset)."</option>\n";
            }
        }
        $ret.= "</select>\n";
        return $ret;
    }
}