<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: custom_fields_date_box.class.php,v 1.2.8.1 2025/11/18 14:19:11 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class custom_fields_date_box extends custom_fields {
    
    protected static $type = 'date_box';
    
    public static function val($field, $value) {
        global $pmb_perso_sep;
        
        $return = "";
        $format_value = format_output($field,$value);
        if (!$value) {
            $value = array();
        }
        foreach ($value as $key => $val) {
            if ($val == "0000-00-00") {
                $val = "";
            }
            if ($val) {
                if ($return) $return .= $pmb_perso_sep;
                $return .= $format_value[$key];
            }
        }
        return $return;
    }
    
    protected static function get_js_function_add($field) {
        return "<script>
			function add_custom_date_box_(field_id, field_name, value, value_popup) {
				var count = document.getElementById('customfield_date_box_'+field_id).value;
            
				var node_dnd_id = get_custom_dnd_on_add('spaceformorecustomfielddatebox_'+field_id, 'customfield_date_box_'+field_name, count);
				var buttonAdd = document.getElementById('button_add_' + field_name + '_' + field_id);
            
                var val = get_input_date_js(field_name + '[]', field_name + '_val_' + count, value);
				document.getElementById(node_dnd_id).appendChild(val);
            
				var del = document.createElement('input');
				del.setAttribute('type', 'button');
		        del.setAttribute('class', 'bouton');
		        del.setAttribute('value', 'X');
                if (use_dojo_calendar == 1) {
    				del.setAttribute('onClick','empty_dojo_calendar_by_id(\"'+field_name + '_val_' + count+'\");');
    				del.addEventListener('click', function() {
    					empty_dojo_calendar_by_id(field_name + '_val_' + count);
    				}, false);
                } else {
    				del.setAttribute('onClick','document.getElementById(\"'+field_name + '_val_' + count+'\").value = \"\";');
                }
			    document.getElementById(node_dnd_id).appendChild(document.createTextNode (' '));
			    document.getElementById(node_dnd_id).appendChild(del);
				if (buttonAdd) document.getElementById(node_dnd_id).appendChild(buttonAdd);
				var br = document.createElement('br');
				document.getElementById(node_dnd_id).appendChild(br);
				document.getElementById('customfield_date_box_'+field_id).value = document.getElementById('customfield_date_box_'+field_id).value * 1 + 1;
            
				dojo.parser.parse(node_dnd_id);
			}
		</script>";
    }
    
    protected static function get_event_button_add($field) {
        $options=$field['OPTIONS'][0];
        if (!isset($options["DEFAULT_TODAY"][0]["value"]) || !$options["DEFAULT_TODAY"][0]["value"]) {
            $value = formatdate(date("Ymd",time()));
            $value_popup = date("Y-m-d",time());
        } else {
            $value = '';
            $value_popup = '';
        }
        return 'add_custom_date_box_(\''.$field['ID'].'\', \''.addslashes($field['NAME']).'\', \''.$value.'\', \''.$value_popup.'\')';
    }
    
    public static function get_formatted_value($field, $value) {
        $options=$field['OPTIONS'][0];
        $flag_id_origine = ($field['ID_ORIGINE'] ? $field['ID_ORIGINE'] : 0);
        
        $d=explode("-",$value);
        $val = "";
        
        $checked_date = false;
        if(!empty($d[0]) && !empty($d[1]) && !empty($d[2])) {
            $checked_date = @checkdate($d[1],$d[2],$d[0]);
        }
        if ((!$checked_date)&&(!isset($options["DEFAULT_TODAY"][0]["value"]) || !$options["DEFAULT_TODAY"][0]["value"])) {
            if(!$flag_id_origine) { //on est en cration
                $val = date("Y-m-d",time());
            }
        } elseif ((!$checked_date)&&(isset($options["DEFAULT_TODAY"][0]["value"]) && $options["DEFAULT_TODAY"][0]["value"])) {
            $val = "";
        } else {
            $val = $value;
        }
        return $val;
    }
    
    public static function get_display_value($field, $indice, $value) {
        return get_input_date($field['NAME']."[]", $field['NAME']."_val_".$indice, $value, $field['MANDATORY']);
    }
    
    public static function aff_search($field,&$check_scripts,$varname) {
        global $charset;
        global $msg;
        
        $values=$field['VALUES'];
        $ret="
		<div id='".$varname."_start_part[]' style='display: inline-block;'>";
        if(!isset($field['OP'])) $field['OP'] = '';
        switch ($field['OP']) {
            case 'LESS_THAN_DAYS':
            case 'MORE_THAN_DAYS':
                $ret.="<input type='text' style='width: 10em;' name='".$varname."[]' id='".$varname."[]' value='".$values[0]."' /> ".htmlentities($msg['days'], ENT_QUOTES, $charset);
                break;
            default:
                $val='';
                if (!empty($values[0])) {
                    $d=explode("-",$values[0]);
                    if(!empty($d[0]) && !empty($d[1]) && !empty($d[2])) {
                        if (@checkdate($d[1],$d[2],$d[0])) {
                            $val=$values[0];
                        }
                    }
                }
                $ret.="<input type='date' name='".$varname."[]' id='".$varname."[]' value='".$val."' />";
                break;
        }
        $ret.="
		</div>";
        
        $values=$field['VALUES1'];
        $val='';
        if (!empty($values[0])) {
            $d=explode("-",$values[0]);
            if(!empty($d[0]) && !empty($d[1]) && !empty($d[2])) {
                if (@checkdate($d[1],$d[2],$d[0])) {
                    $val=$values[0];
                }
            }
        }
        $ret.="
		<div id='".$varname."_end_part[]' style='display: inline-block;'>
			 - <input type='date' name='".$varname."_1[]' id='".$varname."_1[]' value='".$val."' />
		</div>";
        return $ret;
    }
    
    public static function get_formatted_label_aff_filter($label) {
        return formatdate($label);
    }
}