<?php
// +-------------------------------------------------+
// | 2002-2007 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: abts_calendar.class.php,v 1.1.2.2 2025/10/08 11:53:02 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class abts_calendar {
    
    public $id = 0;
    
    public $type = '';
    
    public $num_serial = 0;
    
    public $date_debut = '';
    
    public $date_fin = '';
    
    public function __construct($id, $type) {
        $this->id = intval($id);
        $this->type = $type;
    }
    
    protected function get_js_ad_date() {
        switch ($this->type) {
            case 'abonnement':
                return <<<ENDOFTEXT
				<script type="text/javascript">
				    function ad_date(obj,e) {
    					if(!e) e=window.event;
    					var tgt = e.target || e.srcElement; // IE doesn't use .target
    					var strid = tgt.id;
    					var type = tgt.tagName;
    					e.cancelBubble = true;
    					if (e.stopPropagation) e.stopPropagation();
    					// var pos=findPos(obj);
    					var url="./catalog/serials/abonnement/abonnement_parution_edition.php?abonnement_id=!!id!!&date_parution="+obj+"&type_serie=1&numero=";
    					var notice_view=document.createElement("iframe");
    					notice_view.setAttribute('id','frame_abts');
    					notice_view.setAttribute('name','periodique');
    					notice_view.src=url;
    					var att=document.getElementById("att");
    					notice_view.style.visibility="hidden";
    					notice_view.style.display="block";
    					notice_view=att.appendChild(notice_view);
    					w=notice_view.clientWidth;
    					h=notice_view.clientHeight;
    					notice_view.style.position="fixed";
    					notice_view.style.left="50%";
    					notice_view.style.top="50%";
                        notice_view.style.transform="translate(-50%, -50%)";
    					notice_view.style.visibility="visible";
    				}
    				</script>
ENDOFTEXT;
            case 'modele':
                return <<<ENDOFTEXT
			<script type="text/javascript">
			function ad_date(obj,e) {
				if(!e) e=window.event;
				var tgt = e.target || e.srcElement; // IE doesn't use .target
				var strid = tgt.id;
				var type = tgt.tagName;
				e.cancelBubble = true;
				if (e.stopPropagation) e.stopPropagation();
				var id_obj=document.getElementById(obj);
				var pos=findPos(id_obj);
				if(type!='A'){
					var url="./catalog/serials/modele/modele_parution_edition.php?act=change&serial_id=!!serial_id!!&modele_id=!!id!!&date_parution="+obj+"&type_serie=1&numero=";
				}
				else{
					var url="./catalog/serials/modele/modele_parution_edition.php?serial_id=!!serial_id!!&modele_id=!!id!!&date_parution="+obj+"&type_serie=1&numero=";
				}
				var notice_view=document.createElement("iframe");
				notice_view.setAttribute('id','frame_periodique');
				notice_view.setAttribute('name','periodique');
				notice_view.src=url;
				
				var att=document.getElementById("att");
				notice_view.style.visibility="hidden";
				notice_view.style.display="block";
				notice_view=att.appendChild(notice_view);
				if(type=='A'){
					w=notice_view.clientWidth;
					h=notice_view.clientHeight;
					notice_view.style.left=pos[0]+"px";
					notice_view.style.top=pos[1]+"px";
					notice_view.style.visibility="visible";
					}
			}
			function kill_frame_periodique() {
				var notice_view=document.getElementById("frame_periodique");
				notice_view.parentNode.removeChild(notice_view);
			}
			</script>
ENDOFTEXT;
                
        }
    }
    
    public function get_display() {
        global $msg, $charset;
        
        $calend = $this->get_js_ad_date(); 
        $calend=str_replace("!!serial_id!!",$this->num_serial,$calend);
        $calend=str_replace("!!id!!",$this->id,$calend);
        
        $calend.= "<div id='calendrier_tab' style='width:99%'>" ;
        $date = $this->date_debut;
        $calend.= "<A name='ancre_calendrier'></A>";
        
        $year=pmb_sql_value("SELECT YEAR('".$date."')");
        $cur_year=$year;
        //debut expand
        $calend.="
				<div class='row'>&nbsp;</div>
				<div id='abts_year_".$year."' class='notice-parent'>
					<img src='".get_url_icon('minus.gif')."' class='img_plus' name='imEx' id='abts_year_".$year."Img' title='".htmlentities($msg['plus_detail'], ENT_QUOTES, $charset)."' alt='".htmlentities($msg['plus_detail'], ENT_QUOTES, $charset)."' onClick=\"expandBase('abts_year_".$year."', true); return false;\" />
					<span class='notice-heada'>
						".$year."
		    		</span>
				</div>
				<div id='abts_year_$year"."Child' startOpen='Yes' class='notice-child' style='margin-bottom:6px;width:94%'>";
        
        $i=pmb_sql_value("SELECT MONTH('".$date."')");
        if($i==2 || $i==5 || $i==8 || $i==11) {
            $calend.= "<div class='row' style='padding-top: 5px'><div class='colonne3'>&nbsp;";
            $calend.= "</div>\n";
        }
        if($i==3 || $i==6 || $i==9 || $i==12) {
            $calend.= "<div class='row' style='padding-top: 5px'><div class='colonne3'>&nbsp;";
            $calend.= "</div>\n";
            $calend.= "<div class='colonne3' style='padding-left: 3px'>&nbsp;";
            $calend.= "</div>\n";
        }
        do{
            $year=pmb_sql_value("SELECT YEAR('".$date."')");
            if($year!=$cur_year){
                $calend.= "</div>";
                $calend.="
			<div class='row'></div>
			<div id='abts_year_$year' class='notice-parent'>
                ".get_expandBase_button('abts_year_'.$year)."
				<span class='notice-heada'>
					$year
	    		</span>
			</div>
			<div id='abts_year_$year"."Child' class='notice-child' style='margin-bottom:6px;display:none;width:94%'>
			";
                $cur_year=$year;
            }
            $i=pmb_sql_value("SELECT MONTH('".$date."')");
            
            if ($i==1 || $i==4 || $i==7 || $i==10 ) {
                $calend.= "<div class='row' style='padding-top: 5px'><div class='colonne3'>";
            } else {
                $calend.= "<div class='colonne3' style='padding-left: 3px'>";
            }
            $calend.= $this->get_display_month(str_replace("-","",$date));
            $calend.= "</div>\n";
            if ($i==3 || $i==6 || $i==9 || $i==12 ) {
                $calend.="</div>\n";
            }
            $date=pmb_sql_value("SELECT DATE_ADD('".$date."', INTERVAL 1 MONTH)");
            $diff=pmb_sql_value("SELECT DATEDIFF('".$this->date_fin."','".$date."')");
            
            switch ($this->type) {
                case 'abonnement':
                    $extracted_date = explode('-', $date);
                    $nb_days_in_month = date('t', mktime(0, 0, 0, $extracted_date[1], $extracted_date[2], $extracted_date[0]));
                    $loop_end = (-$nb_days_in_month);
                    break;
                case 'modele':
                    $loop_end = 0;
                    break;
            }
            
        } while($diff>=$loop_end);
        //fin expand
        $calend.= "	</div>";
        $calend.= "</div>\n";
        $calend.="<script type='text/javascript'>parent.location.href='#ancre_calendrier';</script>";
        return $calend;
    }
    
    protected function get_serie($obj) {
        $serie = 0;
        switch ($this->type) {
            case 'abonnement':
                $type_serie=$type_horsserie=0;
                $requete = "select type from abts_grille_abt where num_abt='".$this->id."' and date_parution ='$obj'";
                $resultat=pmb_mysql_query($requete);
                while($r=pmb_mysql_fetch_object($resultat)){
                    $type=$r->type;
                    if ($type==1)$type_serie=1;
                    if ($type==2)$type_horsserie=2;
                }
                $serie = $type_serie+$type_horsserie;
                break;
            case 'modele':
                $requete = "select type_serie from abts_grille_modele where num_modele='".$this->id."' and date_parution ='$obj'";
                $resultat=pmb_mysql_query($requete);
                while($r=pmb_mysql_fetch_object($resultat)){
                    $type_serie=$r->type_serie;
                    $serie+=$type_serie;
                }
                break;
        }
        return $serie;
    }
    
    public function get_display_month($date = '', $base_url_mois="", $form_input_par_jour=0) {
        global $link_on_day, $params, $caller, $msg, $date_caller;
        global $pmb_first_week_day_format ;
        global $style_calendrier ;
        global $admin_calendrier_form_mois_start, $admin_calendrier_form_mois_commentaire ;
        
        $param = array();
        
        $output = '';
        // Default Params
        $param_d=array();
        $param_d['calendar_id']		= 1; // Calendar ID
        $param_d['calendar_columns']= 5; // Nb of columns
        $param_d['show_day'] 		= 1; // Show the day bar
        $param_d['show_month']		= 1; // Show the month bar
        $param_d['nav_link']		= 1; // Add a nav bar below
        $param_d['link_after_date']	= 0; // Enable link on days after the current day
        $param_d['link_before_date']= 0; // Enable link on days before the current day
        //$param_d['link_on_day']		= $PHP_SELF.'?date='; // Link to put on each day
        $param_d['font_face']		= 'Verdana, Arial, Helvetica'; // Default font to use
        $param_d['font_size']		= 10; // Font size in px
        $param_d['bg_color']		= '#FFFFFF';
        $param_d['today_bg_color']	= '#A0C0C0';
        $param_d['font_today_color']= '#990000';
        $param_d['font_color']		= '#000000';
        $param_d['font_nav_bg_color']= '#A9B4B3';
        
        $param_d['font_nav_color']	= '#FFFFFF';
        $param_d['font_header_color']	= '#FFFFFF';
        $param_d['border_color']	= '#3f6551';
        $param_d['use_img']		= 1; // Use gif for nav bar on the bottom
        
        $monthes_name = array('',$msg[1006],$msg[1007],$msg[1008],$msg[1009],$msg[1010],$msg[1011],$msg[1012],$msg[1013],$msg[1014],$msg[1015],$msg[1016],$msg[1017]);
        $days_name = array('',$msg[1018],$msg[1019],$msg[1020],$msg[1021],$msg[1022],$msg[1023],$msg[1024]);
        
        foreach ($param_d as $key => $val) {
            if (isset($params[$key])) {
                $param[$key] = $params[$key];
            } else {
                $param[$key] = $param_d[$key];
            }
        }
        $param['calendar_columns'] = ($param['show_day']) ? 7 : $param['calendar_columns'];
        
        //priv_reg_glob_calendar('date');
        if ($date == '') {
            $date_MySQL = " CURDATE() ";
        } else {
            $month 		= substr($date, 4 ,2);
            $day 		= substr($date, 6, 2);
            $year		= substr($date, 0 ,4);
            $date_MySQL = "'$year-$month-$day'";
        }
        $rqt_date = "select date_format(".$date_MySQL.", '%d') as current_day, date_format(".$date_MySQL.", '%m') as current_month_2, date_format(".$date_MySQL.", '%c') as current_month, date_format(".$date_MySQL.", '%Y') as current_year " ;
        $resultatdate=pmb_mysql_query($rqt_date);
        $resdate=pmb_mysql_fetch_object($resultatdate);
        $current_day 		= $resdate->current_day;
        $current_month 		= $resdate->current_month;
        $current_month_2	= $resdate->current_month_2;
        $current_year 		= $resdate->current_year;
        $date_MySQL_firstday = "'$year-$current_month_2-01'";
        $rqt_date = "select date_format(".$date_MySQL_firstday.", '%w') as first_day_pos,
				date_format(DATE_SUB(DATE_ADD(".$date_MySQL_firstday.", INTERVAL 1 MONTH),INTERVAL 1 DAY), '%d') as nb_days_month " ;
        $resultatdate=pmb_mysql_query($rqt_date);
        $resdate=pmb_mysql_fetch_object($resultatdate);
        $first_day_pos 		= $resdate->first_day_pos;
        $first_day_pos 		= ($first_day_pos == 0) ? 7 : $first_day_pos;
        $nb_days_month 		= $resdate->nb_days_month ;
        $current_month_name = $monthes_name[$current_month];
        
        /* Ajout ER : dtection si date en cours du calendrier correspond ou pas  la date de l'appelant
         Sans ce test, le lien sur tous les jours identiques d'un autre mois n'taient pas affichs, exemple :
         appelant avec date au 04/10/2003 >> lien du 04/11/2003 absent */
        $date_caller = $date_caller ?? '';
        $date_MySQL_caller = "'".substr($date_caller, 0 ,4)."-".substr($date_caller, 4 ,2)."-".substr($date_caller, 6 ,2)."'";
        $rqt_date = "select date_format(".$date_MySQL_caller.", '%d') as current_day, date_format(".$date_MySQL_caller.", '%c') as current_month, date_format(".$date_MySQL_caller.", '%Y') as current_year ";
        $resultatdate=pmb_mysql_query($rqt_date);
        $resdate=pmb_mysql_fetch_object($resultatdate);
        $caller_day 		= $resdate->current_day;
        $caller_month 		= $resdate->current_month;
        $caller_year 		= $resdate->current_year;
        if (($caller_month==$current_month) && ($caller_year==$current_year) && ($caller_day==$current_day)) {
            $same_date=1;
        } else {
            $same_date=0;
        }
        if (!$style_calendrier) {
            $style_calendrier = '<style type="text/css">
				<!--
				.calendarNav'.$param['calendar_id'].' 	{  font-family: '.$param['font_face'].'; font-size: '.($param['font_size']-1).'px; font-style: normal; background-color: '.$param['border_color'].'}
				.calendarTop'.$param['calendar_id'].' 	{  font-family: '.$param['font_face'].'; font-size: '.($param['font_size']+1).'px; font-style: normal; color: '.$param['font_header_color'].'; font-weight: bold;  background-color: '.$param['border_color'].'}
				.calendarToday'.$param['calendar_id'].' {  font-family: '.$param['font_face'].'; font-size: '.$param['font_size'].'px; font-weight: bold; color: '.$param['font_today_color'].'; background-color: '.$param_d['today_bg_color'].';}
				.calendarDays'.$param['calendar_id'].' 	{  font-family: '.$param['font_face'].'; font-size: '.$param['font_size'].'px; font-style: normal; color: '.$param['font_color'].'; background-color: '.$param['bg_color'].'; text-align: center}
				.calendarHeader'.$param['calendar_id'].'{  font-family: '.$param['font_face'].'; font-size: '.($param['font_size']-1).'px; background-color: '.$param['font_nav_bg_color'].'; color: '.$param['font_nav_color'].';}
				.calendarTable'.$param['calendar_id'].' {  background-color: '.$param['border_color'].'; border: 1px '.$param['border_color'].' solid}
				-->
				</style>';
            $output = $style_calendrier ;
        }
        if ($form_input_par_jour) {
            $output .= $admin_calendrier_form_mois_start ;
        }
        $output .= '<table role="presentation" style="border:0px; padding: 1px; border-spacing: 0px" class="calendar-container">'."\n";
        // Displaying the current month/year
        if ($param['show_month'] == 1) {
            $output .= '<tr>'."\n";
            $output .= '	<td colspan="'.$param['calendar_columns'].'" class="align_right">'."\n";
            $output .= "<a name='".$current_year."-".$current_month_2."' ></a>";
            if ($base_url_mois) {
                $output .= "<a href='".$base_url_mois."&date=".$current_year.$current_month_2."01' alt='".$msg["calendrier_edition"]."' title='".$msg["calendrier_edition"]."'>";
            }
            if ($param['use_img'] ) {
                $output .= "<img src='".get_url_icon('mois.gif')."' alt=''>";
            }
            $output .= $current_month_name.' '.$current_year;
            if ($base_url_mois) {
                $output .= "</a>";
            }
            $output .= "</td>";
            $output .= "</tr>"."\n";
        }
        if($pmb_first_week_day_format){
            $first_day_pos++;
            if($first_day_pos==8) {
                $first_day_pos=1;
            }
        }
        // Building the table row with the days
        if ($param['show_day'] == 1) {
            $output .= '<tr class="center">'."\n";
            if($pmb_first_week_day_format) {
                $output .= '<TD class="calendarHeader'.$param['calendar_id'].'"><B>'.$msg[1024].'</B></TD>'."\n";
            }
            $output .= '<TD class="calendarHeader'.$param['calendar_id'].'"><B>'.$msg[1018].'</B></TD>'."\n";
            $output .= '<TD class="calendarHeader'.$param['calendar_id'].'"><B>'.$msg[1019].'</B></TD>'."\n";
            $output .= '<TD class="calendarHeader'.$param['calendar_id'].'"><B>'.$msg[1020].'</B></TD>'."\n";
            $output .= '<TD class="calendarHeader'.$param['calendar_id'].'"><B>'.$msg[1021].'</B></TD>'."\n";
            $output .= '<TD class="calendarHeader'.$param['calendar_id'].'"><B>'.$msg[1022].'</B></TD>'."\n";
            $output .= '<TD class="calendarHeader'.$param['calendar_id'].'"><B>'.$msg[1023].'</B></TD>'."\n";
            if(!$pmb_first_week_day_format) {
                $output .= '<TD class="calendarHeader'.$param['calendar_id'].'"><B>'.$msg[1024].'</B></TD>'."\n";
            }
            $output .= '</tr>'."\n";
        } else {
            $first_day_pos = 1;
        }
        
        $output .= '<tr class="center">';
        $int_counter = 0;
        for ($i = 1; $i < $first_day_pos; $i++) {
            $output .= '<TD>&nbsp;</TD>'."\n";
            $int_counter++;
        }
        // Building the table
        for ($i = 1; $i <= $nb_days_month; $i++) {
            $i_2 = ($i < 10) ? '0'.$i : $i;
            //$commentaire=htmlentities($reception[$current_year.'-'.$current_month_2.'-'.$i_2]['commentaire'],ENT_QUOTES, $charset) ;
            $obj="$current_year-$current_month_2-$i_2";
            
            ### Row start
            if ((($i + $first_day_pos-1) % $param['calendar_columns']) == 1 && $i != 1) {
                $output .= "<tr class='center'>";
                $int_counter = 0;
            }
            if ($form_input_par_jour) {
                $input_commentaire = "&nbsp;".str_replace("!!name!!", "comment_".$i_2, $admin_calendrier_form_mois_commentaire) ;
                $input_commentaire = "&nbsp;".str_replace("!!commentaire!!", '', $input_commentaire) ;
            } else {
                $input_commentaire = "" ;
            }
            $serie = $this->get_serie($obj);
            // c'est un priodique
            if ($serie==1) {
                $class = " class='lien_date' ";
            } elseif ($serie==2) { // c'est un hors-srie
                $class = " class='lien_date_hs'";
            } elseif ($serie==3) { // c'est un hors-srie et un priodique
                $class = " class='lien_date_hs_p'";
            } else { // rien n'est attendu ce jour l
                $class = " ";
            }
            $td_link="onClick='ad_date(\"$obj\",event);return false;'";
            $output .="<TD $class id='$obj' $td_link>" .
            "<a href='#'>$i</a></TD>\n";
            $int_counter++;
            // Row end
            if ( (($i+$first_day_pos-1) % $param['calendar_columns']) == 0 ) {
                $output .= '</TR>'."\n";
            }
        }
        $cell_missing = $param['calendar_columns'] - $int_counter;
        
        for ($i = 0; $i < $cell_missing; $i++) {
            $output .= '<td class="align_right">&nbsp;</td>'."\n";
        }
        if($cell_missing)$output .= '</tr>'."\n";
        $output .= '</table>'."\n";
        return $output;
    }
    
    public function set_num_serial($num_serial) {
        $this->num_serial = intval($num_serial);
        return $this;
    }
    
    public function set_date_debut($date_debut) {
        $this->date_debut = $date_debut;
        return $this;
    }
    
    public function set_date_fin($date_fin) {
        $this->date_fin = $date_fin;
        return $this;
    }
    
    public function get_url_base() {
        switch ($this->type) {
            case 'abonnement':
                return "./catalog.php?categ=serials&sub=abonnement&serial_id=".$this->num_serial."&abonnement_id=$this->id";
            case 'modele':
                return "./catalog.php?categ=serials&sub=modele&serial_id=".$this->num_serial."&modele_id=".$this->id;
        }
    }
}
