<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ai_indexation_explnum.inc.php,v 1.1.2.3 2025/04/03 09:01:51 qvarin Exp $

use Pmb\AI\Orm\AISettingsOrm;
use Pmb\AI\Library\Source\Semantic;

if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) {
    die("no access");
}

global $class_path, $msg, $charset;
global $start, $current_module, $v_state;

// initialisation de la borne de dpart
if (!isset($start)) {
    $start = 0;
}

$v_state = urldecode($v_state ?? '');

print netbase::get_display_progress_title($msg["nettoyage_operations_ia"]);
print netbase::get_display_progress_subtitle($msg["admin_netbase_ai_indexation_explnum"]);

if ($start) {
    showProgressAI();
} else {
    startIndexationAI();
}

function startIndexationAI()
{
    global $spec, $v_state;

    $index_quoi = [];

    // Recuperation de la configuration active
    $idSettings = AISettingsOrm::fetchActiveAiSettings();
    if (!empty($idSettings)) {
        $semantic = new Semantic($idSettings);
    } else {
        global $spec;
        $spec = $spec - AI_INDEXATION_EXPLNUM;
        print netbase::get_current_state_form($v_state, $spec);
        return false;
    }

    $index_quoi[] = $idSettings;
    $semantic->cleanIndexation(TYPE_EXPLNUM);

    print netbase::build_display_progress(0);
    print netbase::get_current_state_form($v_state, $spec, TYPE_EXPLNUM, 1);
}


function showProgressAI()
{
    global $charset, $v_state, $spec, $msg;


    $idSettings = AISettingsOrm::fetchActiveAiSettings();
    if (!empty($idSettings)) {
        $semantic = new Semantic($idSettings);
    } else {
        global $spec;
        $spec = $spec - AI_INDEXATION_EXPLNUM;
        print netbase::get_current_state_form($v_state, $spec);
        return false;
    }

    global $ai_index_nb_elements;
    $semantic->setIndexationType(TYPE_EXPLNUM);
    $result = $semantic->indexation($ai_index_nb_elements);

    $totalEntries = $result["count"];
    $totalEntriesUnFlag = $result["count"] - $result["countIndexed"];
    $finish = true;

    if (empty($totalEntries)) {
        // On a fini l'indexation
        $progress = 100;
    } else {
        // calcul de la progress
        $countIndexed = $totalEntries - $totalEntriesUnFlag;
        $progress = ($countIndexed * 100) / $totalEntries;
        $progress = round($progress, 2);

        if ($progress < 0) {
            $progress = 0;
        } elseif ($progress >= 100) {
            $progress = 100;
        }

        if ($progress < 100) {
            // On indique qu'on a pas fini une configuration
            $finish = false;
        }
    }

    print netbase::build_display_progress($progress);

    if ($finish) {
        $spec = $spec - AI_INDEXATION_EXPLNUM;
        $v_state .= netbase::get_display_progress_v_state(
            $msg["nettoyage_operations_ia"],
            sprintf($msg['netbase_ai_indexation_explnum'], $totalEntries)
        );

        print netbase::get_current_state_form($v_state, $spec);
    } else {
        print netbase::get_current_state_form($v_state, $spec, TYPE_EXPLNUM, 1);
    }
}
