<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: SEOController.php,v 1.4.2.2 2026/01/09 15:16:01 rtigero Exp $
namespace Pmb\SEO\Controller;

use Pmb\Common\Controller\Controller;

abstract class SEOController extends Controller
{
    protected $action = "";

    /**
     * Aiguillage
     * @param string $action
     * @param $data
     * @return void
     */
    public function proceed($action = '', $data = null)
    {
        $this->action = $action;
        switch ($action) {
            case 'edit':
            default:
                return $this->defaultAction();
        }
    }

    /**
     * Action par dfaut
     */
    protected function defaultAction() {}

    /**
     * Donnees de base necessaires aux vues
     * @return array
     */
    protected function getViewBaseData(): array
    {
        global $pmb_url_base;
        return [
            "url_webservice" => $pmb_url_base . "rest.php/seo/",
            "action" => $this->action,
            "controller" => $this->getControllerName()
        ];
    }

    protected function getControllerName()
    {
        $class = get_class($this);
        $part = explode('\\', $class);
        $class = end($part);
        return str_replace('Controller', '', $class);
    }
}
