<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: SeoRouterRest.php,v 1.4.2.2 2026/01/09 15:16:01 rtigero Exp $

namespace Pmb\REST;

use Pmb\Common\Helper\Helper;

class SeoRouterRest extends RouterRest
{

	/**
	 *
	 * @const string
	 */
	protected const CONTROLLER = "\\Pmb\\SEO\\Controller\\SEOController";

	/**
	 *
	 * {@inheritdoc}
	 * @see \Pmb\REST\RouterRest::generateRoutes()
	 */
	protected function generateRoutes()
	{
		//POST
		$this->post('{controller}/save', 'save');
		$this->post('{controller}/{type}/save', 'save');
		$this->post('{controller}/{type}/children/save', 'saveChildren');
		$this->post('{controller}/{type}/children/delete/{id}', 'deleteChildren');
		$this->post('{controller}/{type}/delete/{id}', 'delete');
		$this->post('{controller}/reset', 'reset');

		//GET
		$this->get('{controller}/{type}/getData', 'getData');
		$this->get('{controller}/{type}/children/{id}', 'getChildren');

	}

	/**
	 *
	 * @param RouteRest $route
	 * @return mixed
	 */
	protected function call(RouteRest $route)
	{
		global $data;

		$data = \encoding_normalize::json_decode(stripslashes($data ?? ''));
		if (empty($data) || !is_object($data)) {
			$data = new \stdClass();
		}

		$args = $route->getArguments();
		$className = $this->foundController($route);
		if (false === $className) {
			$className = static::CONTROLLER;
		} elseif (count($args) > 0) {
			array_splice($args, 0, 1);
		}

		$callback = [
			new $className($data),
			$route->getMethod(),
		];
		if (is_callable($callback)) {
			return call_user_func_array($callback, $args);
		}
	}

	private function foundController(RouteRest $route)
	{
		$args = $route->getArguments();
		$controller = $args[0] ?? "";

		$namespace = "Pmb\\SEO\\Controller\\" . Helper::pascalize("{$controller}_controller");
		if (class_exists($namespace)) {
			return $namespace;
		}
		return false;
	}
}
