<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: Profile.php,v 1.2.2.2 2025/06/27 14:20:53 rtigero Exp $

namespace Pmb\ImportExport\Models\Profiles;

use Pmb\Common\Models\Model;
use Pmb\ImportExport\Models\Ontology\Store;
use Pmb\ImportExport\Models\Profiles\ProfileEntity;
use Pmb\ImportExport\Orm\ProfileEntityOrm;

abstract class Profile extends Model
{
    /**
     * @const string Type de profil -> import ou export
     */
    protected const PROFILE_PURPOSE = "";

    public $id = 0;
    public $profileName = "";
    public $profileComment = "";
    public $profileType = "";
    public $profileSettings = null;
    public $entities = array();
    protected Store $store;

    protected $ormName = "Pmb\ImportExport\Orm\ProfileOrm";

    public function getList($fields = null, $toArray = false, $order = '')
    {
        return parent::getList(array("profile_purpose" => static::PROFILE_PURPOSE), $toArray, "profile_name");
    }

    protected function fetchData()
    {
        parent::fetchData();
        $this->fetchEntities();
    }

    protected function fetchEntities()
    {
        $entitiesOrm = ProfileEntityOrm::finds(["num_profile" => $this->id]);
        $this->entities = array();
        foreach ($entitiesOrm as $entityOrm) {
            $this->entities[] = new ProfileEntity($entityOrm->id_entity);
        }
    }

    public function setFromForm(object $data)
    {
        $this->profileName = $data->profileName;
        $this->profileComment = $data->profileComment;
        $this->profileType = $data->profileType;

        $this->entities = [];
        if (!empty($data->entities)) {
            foreach ($data->entities as $data_entity) {
                $ProfileEntity = new ProfileEntity($data_entity->id);
                $ProfileEntity->numProfile = $data_entity->numProfile;
                $ProfileEntity->setFromForm($data_entity);
                $this->entities[] = $ProfileEntity;
            }
        }
    }

    public function save()
    {
        $orm = new $this->ormName($this->id);

        $orm->profile_name = $this->profileName;
        $orm->profile_comment = $this->profileComment;
        $orm->profile_type = $this->profileType;
        $orm->profile_purpose = static::PROFILE_PURPOSE;

        $orm->save();
        if (!$this->id) {
            $this->id = $orm->id_profile;
        }
        if (!empty($this->entities)) {
            foreach ($this->entities as $ProfileEntity) {
                $ProfileEntity->save();
            }
        }
        return $orm;
    }

    public function remove()
    {
        $orm = new $this->ormName($this->id);
        $orm->delete();
        if (0 == $orm->id_profile) {
            foreach ($this->entities as $entity) {
                $entity->remove();
            }
        }
    }

    public function duplicate()
    {
        $newProfile = clone $this;

        $newProfile->id = 0;
        $newProfile->profileName .= " - copy";
        $entitiesBuffer = $newProfile->entities;
        $newProfile->entities = [];
        $newProfile->save();

        //On duplique les entites
        foreach ($entitiesBuffer as $entity) {
            $entity->id = 0;
            $entity->numProfile = $newProfile->id;
            $entity->save();
            $newProfile->entities[] = $entity;
        }
        return $newProfile;
    }

    /**
     * Rcupre une entit par son URI
     *
     * @param string $uri
     * @return ProfileEntity
     */
    public function getEntity($uri)
    {
        foreach ($this->entities as $entity) {
            if ($entity->entityType == $uri) {
                return $entity;
            }
        }
        return null;
    }

    public function setStore(Store $store)
    {
        $this->store = $store;
    }

    /**
     * Applique un profil
     * @return void
     */
    public function applyProfile()
    {
        //A driver
    }

    /**
     * Prpare le profil avant application
     */
    protected function setupProfile()
    {
        //A driver
    }
}
