<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ConverterSimple.php,v 1.2.2.2 2025/06/27 14:21:08 rtigero Exp $

namespace Pmb\ImportExport\Models\Converters\ConverterSimple;

use Pmb\ImportExport\Models\Converters\Converter;
use Pmb\ImportExport\Models\Ontology\Entity\Entity;

class ConverterSimple extends Converter
{
    protected string $outFormat = "pmbrdf";

    public function execute(): void
    {
        if (isset($this->settings->mappings)) {
            foreach ($this->settings->mappings as $namespace => $entitySettings) {

                $pmbEntity = $this->ontologyPMB->getEntityByURI($namespace);
                $mappings = $entitySettings->mappings;
                $this->mappings[$pmbEntity->name] = array();

                foreach ($mappings as $mapping) {
                    $pmbProperty = $this->ontologyPMB->getPropertyByURI($mapping->pmbProperty);
                    $this->mappings[$pmbEntity->name][$mapping->sourceProperty] = $pmbProperty->name;
                }
            }
            parent::execute();
        }
    }

    protected function checkSourceEntity(array $values): bool
    {
        if (!empty($values)) {
            return true;
        }

        return false;
    }

    protected function getPMBEntityType(Entity $entity): void
    {
        $this->pmbEntityType = "";

        foreach ($this->settings->mappings as $namespace => $entitySettings) {
            if ($entitySettings->sourceEntityName == $entity->name) {
                $pmbEntity = $this->ontologyPMB->getEntityByURI($namespace);
                $this->pmbEntityType = $pmbEntity->name;
                break;
            }
        }
    }
}
