<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ExplnumCollection.php,v 1.8.2.3 2025/10/21 08:22:46 qvarin Exp $

namespace Pmb\Docnums\Models;

use Pmb\Common\Models\Model;

class ExplnumCollection extends Model
{
    protected $ormName = "Pmb\Docnums\Orm\ExplnumCollectionsExplnumsOrm";

    public $id = 0;
    public $idExplnumCollectionsExplnums = 0;
    public $explnumCollectionsExplnumsNom = "";
    public $explnumCollectionsExplnumsMimetype = "";
    public $explnumCollectionsExplnumsUrl = "";
    public $explnumCollectionsExplnumsData = null;
    public $explnumCollectionsExplnumsVignette = null;
    public $explnumCollectionsExplnumsExtfichier = "";
    public $explnumCollectionsExplnumsNomfichier = "";
    public $explnumCollectionsExplnumsStatut = 0;
    public $explnumCollectionsExplnumsRepertoire = 0;
    public $explnumCollectionsExplnumsPath = "";
    public $explnumCollectionsExplnumsDocnumStatut = 0;
    public $explnumCollectionsExplnumsSignature = "";
    public $explnumCollectionsExplnumsCreateDate = "";
    public $explnumCollectionsExplnumsUpdateDate = "";
    public $explnumCollectionsExplnumsFileSize = 0;
    public $explnumCollectionsExplnumsNumCollection = 0;

    // Repertoire d'upload
    public $repositoryName = '';
    public $repositoryPath = '';
    public $repositoryId = 0;


    public function __construct($id = 0)
    {
        parent::__construct($id);
        $this->initUploadRepository();
    }

    protected function fetchData()
    {
        parent::fetchData();
        $this->explnumCollectionsExplnumsNom = stripslashes($this->explnumCollectionsExplnumsNom);
        $this->explnumCollectionsExplnumsUrl = stripslashes($this->explnumCollectionsExplnumsUrl);
        $this->explnumCollectionsExplnumsMimetype = stripslashes($this->explnumCollectionsExplnumsMimetype);
        $this->explnumCollectionsExplnumsData = stripslashes($this->explnumCollectionsExplnumsData ?? '');
        $this->explnumCollectionsExplnumsNomfichier = stripslashes($this->explnumCollectionsExplnumsNomfichier);
        $this->explnumCollectionsExplnumsExtfichier = stripslashes($this->explnumCollectionsExplnumsExtfichier);
        $this->explnumCollectionsExplnumsVignette = stripslashes($this->explnumCollectionsExplnumsVignette ?? '');
    }

    public function save()
    {
        $explnumCollectionsOrm = new $this->ormName();
        $explnumCollectionsOrm->id_explnum_collections_explnums = $this->idExplnumCollectionsExplnums;
        $explnumCollectionsOrm->explnum_collections_explnums_nom = addslashes($this->explnumCollectionsExplnumsNom);
        $explnumCollectionsOrm->explnum_collections_explnums_mimetype = addslashes($this->explnumCollectionsExplnumsMimetype);
        $explnumCollectionsOrm->explnum_collections_explnums_url = addslashes($this->explnumCollectionsExplnumsUrl);
        $explnumCollectionsOrm->explnum_collections_explnums_data = addslashes($this->explnumCollectionsExplnumsData);
        $explnumCollectionsOrm->explnum_collections_explnums_vignette = addslashes($this->explnumCollectionsExplnumsVignette);
        $explnumCollectionsOrm->explnum_collections_explnums_extfichier = addslashes($this->explnumCollectionsExplnumsExtfichier);
        $explnumCollectionsOrm->explnum_collections_explnums_nomfichier = addslashes($this->explnumCollectionsExplnumsNomfichier);
        $explnumCollectionsOrm->explnum_collections_explnums_repertoire = $this->explnumCollectionsExplnumsRepertoire;
        $explnumCollectionsOrm->explnum_collections_explnums_path = $this->explnumCollectionsExplnumsPath;
        $explnumCollectionsOrm->explnum_collections_explnums_statut = $this->explnumCollectionsExplnumsStatut;
        $explnumCollectionsOrm->explnum_collections_explnums_docnum_statut = $this->explnumCollectionsExplnumsDocnumStatut;
        $explnumCollectionsOrm->explnum_collections_explnums_signature = $this->explnumCollectionsExplnumsSignature;
        $explnumCollectionsOrm->explnum_collections_explnums_create_date = $this->explnumCollectionsExplnumsCreateDate;
        $explnumCollectionsOrm->explnum_collections_explnums_update_date = $this->explnumCollectionsExplnumsUpdateDate;
        $explnumCollectionsOrm->explnum_collections_explnums_file_size = $this->explnumCollectionsExplnumsFileSize;
        $explnumCollectionsOrm->explnum_collections_explnums_num_collection = $this->explnumCollectionsExplnumsNumCollection;
        $explnumCollectionsOrm->save();

        $this->idExplnumCollectionsExplnums = $explnumCollectionsOrm->id_explnum_collections_explnums;
    }

    public function delete()
    {
        $explnumCollectionsOrm = new $this->ormName();
        $explnumCollectionsOrm->id_explnum_collections_explnums = $this->idExplnumCollectionsExplnums;
        $explnumCollectionsOrm->delete();
    }

    protected function initUploadRepository()
    {
        if (!defined('SESSlogin')) {
            return;
        }

        $query = "SELECT repertoire_id, repertoire_nom, repertoire_path
                FROM upload_repertoire, users
                WHERE repertoire_id = deflt_upload_repertoire
                AND username = '" . addslashes(SESSlogin) . "'";

        $result = pmb_mysql_query($query);

        if (pmb_mysql_num_rows($result)) {
            $repository = pmb_mysql_fetch_object($result);

            $this->repositoryName = $repository->repertoire_nom;
            $this->repositoryPath = $repository->repertoire_path;
            $this->repositoryId = $repository->repertoire_id;
        }
    }
}
