<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: selector_display_record.class.php,v 1.1.4.3 2025/11/05 15:19:16 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

// dfinition de la classe d'affichage des monographies en liste pour selecteur
class selector_display_record extends selector_display {

	public $notice_id = 0;		//id notice
	public $notice;		//objet notice
	public $statut = '' ;		//statut notice
	public $tit_serie = '';	//titre serie
	public $tit1 = '';			//titre 1
	public $nb_expl = 0;		//nb exemplaires

	public $typ_lig = 1; //type de ligne
	public $titre = '';		//titre renvoye
	public $auteur1 = '';		//auteur1 renvoye
	public $editeur1 = '';		//editeur1 renvoye
	public $collection = '';	//collection renvoyee
	public $ed_date = '';		//date editeur

	// constructeur
	public function __construct($id, $base_url, $form_checker='') {
	    parent::__construct($id, $base_url, $form_checker);
	    $this->notice_id=intval($id);
	}

	// rcupration des valeurs en table
	public function getData() {
		$q = "SELECT * FROM notices WHERE notice_id=".$this->notice_id;
		$r = pmb_mysql_query($q);
		if (pmb_mysql_num_rows($r)) {
			$this->notice = pmb_mysql_fetch_object($r);
		}
		$q = "select count(*) from exemplaires where expl_notice='".$this->notice_id."' ";
		$r = pmb_mysql_query($q);
		$this->nb_expl = pmb_mysql_result($r,0,0);
	}

	// creation header
	public function doHeader() {
		global $charset;
		global $pmb_notice_reduit_format;

		if ($this->notice->statut) {
			$rqt_st = "SELECT class_html , gestion_libelle FROM notice_statut WHERE id_notice_statut='".$this->notice->statut."' ";
			$res_st = pmb_mysql_query($rqt_st);
			$class_html = " class='".pmb_mysql_result($res_st, 0, 0)."' ";
			$txt = pmb_mysql_result($res_st, 0, 1);
		} else {
			$class_html = " class='statutnot1' " ;
			$txt = '' ;
		}
		if ($this->notice->commentaire_gestion) {
		    if ($txt) {
		        $txt .= ":\r\n".$this->notice->commentaire_gestion;
		    } else {
		        $txt = $this->notice->commentaire_gestion;
		    }
		}
		if ($txt) {
			$statut = "<small><span $class_html style='margin-right: 3px;'><a href=# onmouseover=\"z=document.getElementById('zoom_statut".$this->notice_id."'); z.style.display=''; \" onmouseout=\"z=document.getElementById('zoom_statut".$this->notice_id."'); z.style.display='none'; \"><img src='".get_url_icon('spacer.gif')."' width='10' height='10' /></a></span></small>";
			$statut .= "<div id='zoom_statut".$this->notice_id."' style='border: solid 2px #555555; background-color: #FFFFFF; position: absolute; display:none; z-index: 2000;'><b>".nl2br(htmlentities($txt,ENT_QUOTES, $charset))."</b></div>" ;
		} else {
		    $statut = "<small><span $class_html style='margin-right: 3px;'><img src='".get_url_icon('spacer.gif')."' width='10' height='10' /></span></small>";
		}
		$this->statut = $statut;


		//aff. titre srie
		if($this->notice->tparent_id) {
			$parent = new serie($this->notice->tparent_id);
			$this->tit_serie = $parent->name;
			$this->header.= $this->tit_serie;
			if($this->notice->tnvol) {
				$this->header .= ',&nbsp;'.$this->notice->tnvol;
			}
		}

		//aff. titre1
		$this->tit1 = $this->notice->tit1;
		$this->tit_serie ? $this->header.= '.&nbsp;'.$this->tit1 : $this->header.= $this->tit1;

		//aff. auteur1
		$aut1_libelle = array() ;
		$lib_auteur='';
		$as = array_search ("0", $this->responsabilites["responsabilites"]);
		if ($as!== FALSE && $as!== NULL) {
			$auteur_0 = $this->responsabilites["auteurs"][$as] ;
			$auteur = new auteur($auteur_0["id"]);
			if ($auteur->get_isbd()) {
				$lib_auteur=$auteur->get_isbd();
			}
		} else {
			$as = array_keys ($this->responsabilites["responsabilites"], "1" );
			for ($i = 0 ; $i < count($as) ; $i++) {
				$indice = $as[$i] ;
				$auteur_1 = $this->responsabilites["auteurs"][$indice];
				$auteur = new auteur($auteur_1["id"]);
				$aut1_libelle[]= $auteur->get_isbd();
			}
			$auteurs_liste = implode ("; ",$aut1_libelle) ;
			if ($auteurs_liste) {
				$this->header .= ' / '. $auteurs_liste;
				$lib_auteur=$auteurs_liste;
			}
		}
		if ($lib_auteur!='') {
			$this->header .= ' / '. $lib_auteur;
		}

		//aff. annee
		switch ($pmb_notice_reduit_format) {
			case '1':
				if ($this->notice->year != '') $this->header.=' ('.htmlentities($this->notice->year, ENT_QUOTES, $charset).')';
				break;
			case "2":
				if ($this->notice->year != '') $this->header.=' ('.htmlentities($this->notice->year, ENT_QUOTES, $charset).')';
				if ($this->notice->code != '') $this->header.=' / '.htmlentities($this->notice->code, ENT_QUOTES, $charset);
				break;
			default :
				break;
		}

		//renv. code
		$this->code = $this->notice->code;

		//renvoi titre
		$this->titre = $this->tit_serie;
		if($this->notice->tnvol) {
			$this->titre.= ',&nbsp;'.$this->notice->tnvol;
		}
		$this->titre ? $this->titre .= '.&nbsp;'.$this->tit1 : $this->titre = $this->tit1;
		$this->titre = htmlentities($this->titre,ENT_NOQUOTES,$charset);

		//renv. auteur1
		$this->auteur1 = htmlentities($lib_auteur,ENT_NOQUOTES,$charset);

		//renv. editeur, collection
		if($this->notice->subcoll_id) {
			$collection = new subcollection($this->notice->subcoll_id);
			$ed_obj = new editeur($collection->editeur) ;
			$this->editeur1 = htmlentities($ed_obj->get_isbd(),ENT_NOQUOTES,$charset);
			$this->collection = htmlentities($collection->get_isbd(),ENT_NOQUOTES,$charset);
		} elseif ($this->notice->coll_id) {
			$collection = new collection($this->notice->coll_id);
			$ed_obj = new editeur($collection->parent) ;
			$this->editeur1 = htmlentities($ed_obj->get_isbd(),ENT_NOQUOTES,$charset);
			$this->collection = htmlentities($collection->get_isbd(),ENT_NOQUOTES,$charset);
		} elseif ($this->notice->ed1_id) {
			$editeur = new editeur($this->notice->ed1_id);
			$this->editeur1 = htmlentities($editeur->get_isbd(),ENT_NOQUOTES,$charset);
		}
		$this->ed_date = htmlentities($this->notice->year,ENT_NOQUOTES,$charset);
		//renv. prix
		$this->prix=htmlentities($this->notice->prix,ENT_NOQUOTES,$charset);
	}

	// creation contenu
	public function doContent() {
		global $tdoc;
		global $fonction_auteur;
		global $msg;

		//mention titre
		$this->isbd = $this->titre;
		$this->isbd .= ' ['.$tdoc->table[$this->notice->typdoc].']';
		if($this->notice->tit3) $this->isbd .= "&nbsp;= ".$this->notice->tit3;
		if($this->notice->tit4) $this->isbd .= "&nbsp;: ".$this->notice->tit4;
		if($this->notice->tit2) $this->isbd .= "&nbsp;; ".$this->notice->tit2;

		//mention responsabilit
		$mention_resp = array() ;
		$as = array_search ("0", $this->responsabilites["responsabilites"]);
		if ($as!== FALSE && $as!== NULL) {
			$auteur_0 = $this->responsabilites["auteurs"][$as] ;
			$auteur = new auteur($auteur_0["id"]);
			$mention_resp_lib = $auteur->get_isbd();
			if ($auteur_0["fonction"]) {
				$mention_resp_lib .= ", ".$fonction_auteur[$auteur_0["fonction"]];
			}
			$mention_resp[] = $mention_resp_lib ;
		}
		$as = array_keys ($this->responsabilites["responsabilites"], "1" );
		for ($i = 0 ; $i < count($as) ; $i++) {
			$indice = $as[$i] ;
			$auteur_1 = $this->responsabilites["auteurs"][$indice] ;
			$auteur = new auteur($auteur_1["id"]);
			$mention_resp_lib = $auteur->get_isbd();
			if ($auteur_1["fonction"]) {
				$mention_resp_lib .= ", ".$fonction_auteur[$auteur_1["fonction"]];
			}
			$mention_resp[] = $mention_resp_lib ;
		}
		$as = array_keys ($this->responsabilites["responsabilites"], "2" ) ;
		for ($i = 0 ; $i < count($as) ; $i++) {
			$indice = $as[$i] ;
			$auteur_2 = $this->responsabilites["auteurs"][$indice] ;
			$auteur = new auteur($auteur_2["id"]);
			$mention_resp_lib = $auteur->get_isbd();
			if ($auteur_2["fonction"]) {
				$mention_resp_lib .= ", ".$fonction_auteur[$auteur_2["fonction"]];
			}
			$mention_resp[] = $mention_resp_lib ;
		}
		$libelle_mention_resp = implode ("; ",$mention_resp) ;
		if($libelle_mention_resp) {
				$this->isbd .= "&nbsp;/ $libelle_mention_resp";
		}

		// mention edition
		if($this->notice->mention_edition) {
			$this->isbd .= ".&nbsp;-&nbsp;".$this->notice->mention_edition;
		}

		// zone de l'adresse
		// on rcupre la collection au passage, si besoin est
		$editeurs = '';
		$collections = '';
		if($this->notice->subcoll_id) {
			$collection = new subcollection($this->notice->subcoll_id);
			$ed_obj = new editeur($collection->editeur) ;
			$editeurs .= $ed_obj->get_isbd();
			$collections = $collection->get_isbd();
		} elseif ($this->notice->coll_id) {
			$collection = new collection($this->notice->coll_id);
			$ed_obj = new editeur($collection->parent) ;
				$editeurs .= $ed_obj->get_isbd();
				$collections = $collection->get_isbd();
		} elseif ($this->notice->ed1_id) {
			$editeur = new editeur($this->notice->ed1_id);
			$editeurs .= $editeur->get_isbd();
		}
		if($this->notice->ed2_id) {
			$editeur = new editeur($this->notice->ed2_id);
			$ed_isbd=$editeur->get_isbd();
			if (!empty($editeurs)) {
			    $editeurs .= '&nbsp;; '.$ed_isbd;
			} else {
			    $editeurs = $ed_isbd;
			}
		}
		if($this->notice->year) {
		    if (!empty($editeurs)) {
		        $editeurs .= ', '.$this->notice->year;
		    } else {
		        $editeurs = $this->notice->year;
		    }
		}
		if (!empty($editeurs)) {
			$this->isbd .= ".&nbsp;-&nbsp;$editeurs";
		}

		// zone de la collation
		$collation = '';
		if($this->notice->npages) {
			$collation .= $this->notice->npages;
		}
		if($this->notice->ill) {
			$collation .= '&nbsp;: '.$this->notice->ill;
		}
		if($this->notice->size) {
			$collation .= '&nbsp;; '.$this->notice->size;
		}
		if($this->notice->accomp) {
			$collation .= '&nbsp;+ '.$this->notice->accomp;
		}
		if($collation) {
			$this->isbd .= ".&nbsp;-&nbsp;$collation";
		}
		if($collections) {
			if($this->notice->nocoll) {
				$collections .= '; '.$this->notice->nocoll;
			}
			$this->isbd .= ".&nbsp;-&nbsp;($collections)".' ';
		}

		if(substr(trim($this->isbd), -1) != "."){
			$this->isbd .= '.';
		}
		$zoneNote = '';
		// ISBN ou NO. commercial
		if($this->notice->code) {
			if(isISBN($this->notice->code)) {
				$zoneNote = $msg['isbd_notice_isbn'].' ';
			}
			$zoneNote .= $this->notice->code;
		}

		//prix code
		if($this->notice->prix) {
			if($this->notice->code) {
				$zoneNote .= '&nbsp;: '.$this->notice->prix;
			} else {
				if ($zoneNote) {
					$zoneNote .= '&nbsp; '.$this->notice->prix;
				} else {
					$zoneNote = $this->notice->prix;
				}
			}
		}
		if($zoneNote) {
			$this->isbd .= "<br /><br />$zoneNote.";
		}

		//Indexation dcimale
		if($this->notice->indexint) {
			$indexint = new indexint($this->notice->indexint);
			$indexint_isbd=$indexint->display;
			$this->isbd .= "<br /><b>".$msg['indexint_catal_title']."</b>&nbsp;: ".$indexint_isbd;
		}
	}

	//gnration du template javascript
	public function finalize() {
		global $msg;

		$javascript_template ="
						<div id='el_!!id!!_Parent' class='notice-parent'><span class='acq_sel_display_middle'>";
		if(trim($this->form_checker)){
			$javascript_template .= $this->getCheckbox();
		}
		$javascript_template.="
							<img src='".get_url_icon('plus.gif')."' name='imEx' id='el_!!id!!_Img' title='".$msg['admin_param_detail']."' onClick=\"expandBase('el_!!id!!_', true); return false;\" />
							</span><span class='notice-heada'>!!header!!</span>
							<div id='el_!!id!!_Child' class='notice-child' style='width:inherit;display:none;' >
	   					 		!!isbd!!
							</div>
						</div>";

		if ($this->action) {
		    $this->finalizeHeaderFromAction();
			$this->header = $this->statut.$this->header;
		}

		$this->result = str_replace('!!id!!', $this->notice_id, $javascript_template);
		$this->result = str_replace('!!header!!', $this->header, $this->result);

		$this->result = str_replace('!!isbd!!', $this->isbd, $this->result);
	}
	
	public function getNomActe() {
	    $nom_acte = $this->titre;
	    if ($this->auteur1 != '') {
	        $nom_acte .= "<br />".$this->auteur1;
	    }
	    if ($this->editeur1 != '') {
	        $nom_acte .= "<br />".$this->editeur1;
	    }
	    if ($this->editeur1 != '' && $this->ed_date != '') {
	        $nom_acte .= ", ".$this->ed_date;
	    } elseif ($this->ed_date != '') {
	        $nom_acte .= "<br />".$this->ed_date;
	    }
	    if ($this->collection != '') {
	        $nom_acte .= "<br />".$this->collection;
	    }
	    return $nom_acte;
	}
}
