<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: searcher_sphinx_concepts.class.php,v 1.2.16.2 2025/09/03 13:17:15 rtigero Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

require_once($class_path . '/searcher/searcher_sphinx_authorities.class.php');

class searcher_sphinx_concepts extends searcher_sphinx_authorities
{
	protected $index_name = 'concepts';

	public function __construct($user_query)
	{
		global $include_path;
		parent::__construct($user_query);
		$this->index_name = 'concepts';
		$this->authority_type = AUT_TABLE_CONCEPT;
	}

	protected function get_filters()
	{
		$filters = parent::get_filters();
		global $concept_scheme;
		if (isset($concept_scheme) && ($concept_scheme != -1) && (!strpos($concept_scheme, ','))) {
			//on ne s'assure pas de savoir si c'est une chaine ou un tableau, c'est gr dans la classe racine  la vole!
			$filters[] = array(
				'name' => 'scheme',
				'values' => $concept_scheme
			);
		}
		return $filters;
	}

	public function get_sorted_result($tri = "default", $start = 0, $number = 20)
	{
		if (isset($this->result)) {
			return $this->result;
		}
		$result = parent::get_sorted_result($tri, $start, $number);
		$this->result = array();
		if (! is_array($result)) {
			return $this->result;
		}
		$results = implode(',', $result);
		//Ce micmac est necessaire car les tris / filtres se basent sur l'id d'autorit il faut donc rcuprer le num object apres
		//Le controller qui appelle cette methode attend des num_object
		$query = 'select num_object from authorities where id_authority in (' . $results . ')' . (($this->sphinx_query != '*') ? ' order by field (id_authority,' . $results . ')' : '');
		$result = pmb_mysql_query($query);
		if (pmb_mysql_num_rows($result)) {
			while ($row = pmb_mysql_fetch_object($result)) {
				$this->result[] = $row->num_object;
			}
		}
		return $this->result;
	}
}
