<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: custom_fields_html.class.php,v 1.2.4.2 2025/11/18 14:22:48 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class custom_fields_html extends custom_fields {
    
    protected static $type = 'html';
    
    public static function val($field, $value) {
        global $pmb_perso_sep;
        
        $value=format_output($field, $value);
        if (!$value) {
            $value=array();
        }
        return array("ishtml" => true, "value"=>implode($pmb_perso_sep,$value), "withoutHTML" =>implode($pmb_perso_sep,$value));
    }
    
    protected static function get_js_function_add($field) {
        global $pmb_editorial_dojo_editor;
        
        if ($pmb_editorial_dojo_editor) {
            return "<script>
    			function add_custom_html_(field_id, field_name, field_height, field_width,use_html_editor) {
    				document.getElementById('customfield_html_'+field_id).value = document.getElementById('customfield_html_'+field_id).value * 1 + 1;
    				var count = document.getElementById('customfield_html_'+field_id).value;
                
    				var node_dnd_id = get_custom_dnd_on_add('spaceformorecustomfieldhtml_'+field_id, 'customfield_html_'+field_name, (count-1));
                
    				var hid = document.createElement('input');
    				hid.setAttribute('type','hidden');
    				hid.setAttribute('name',field_name+'['+(count-1)+']');
    				hid.setAttribute('id',field_name+'_'+(count-1));
    				hid.setAttribute('value','');
                
    				var f_aut0 = document.createElement('div');
    				f_aut0.setAttribute('data-dojo-type','dijit/Editor');
    				f_aut0.setAttribute('class','saisie-80em');
    				f_aut0.setAttribute('wrap','wrap');
    				f_aut0.setAttribute('style','display:inline-block; width:'+field_width+'px');
                
    				var space=document.createElement('br');
                
    				document.getElementById(node_dnd_id).appendChild(hid);
    				document.getElementById(node_dnd_id).appendChild(f_aut0);
    				new dijit.Editor({id : field_name+'_'+(count-1), height : field_height+'px', extraPlugins:[
    						{name: 'pastefromword', width: '400px', height: '200px'},
    						{name: 'insertTable', command: 'insertTable'},
    					    {name: 'modifyTable', command: 'modifyTable'},
    					    {name: 'insertTableRowBefore', command: 'insertTableRowBefore'},
    					    {name: 'insertTableRowAfter', command: 'insertTableRowAfter'},
    					    {name: 'insertTableColumnBefore', command: 'insertTableColumnBefore'},
    					    {name: 'insertTableColumnAfter', command: 'insertTableColumnAfter'},
    					    {name: 'deleteTableRow', command: 'deleteTableRow'},
    					    {name: 'deleteTableColumn', command: 'deleteTableColumn'},
    					    {name: 'colorTableCell', command: 'colorTableCell'},
    					    {name: 'tableContextMenu', command: 'tableContextMenu'},
    					    {name: 'resizeTableColumn', command: 'resizeTableColumn'},
    						{name: 'fontName', plainText: true},
    						{name: 'fontSize', plainText: true},
    						{name: 'formatBlock', plainText: true},
    						'foreColor','hiliteColor',
    						'createLink','insertanchor', 'unlink', 'insertImage',
    						'fullscreen',
    						'viewsource'
                
    				]}, f_aut0).startup();
    				document.getElementById(node_dnd_id).appendChild(space);
    				document.getElementById(node_dnd_id).appendChild(space);
                    document.getElementById('customfield_html_'+field_id).value = count++;
    			}
    			</script>";
        } else {
            return "<script>
			function add_html_editor(field_name,ind) {
				if(typeof(tinyMCE)!= 'undefined') {
					tinyMCE_execCommand('mceAddControl', true, field_name+'_'+ind);
				}
			}
			function add_custom_html_(field_id, field_name, field_height, field_width, use_html_editor) {
				document.getElementById('customfield_html_'+field_id).value = document.getElementById('customfield_html_'+field_id).value * 1 + 1;
				var count = document.getElementById('customfield_html_'+field_id).value;
                
				var node_dnd_id = get_custom_dnd_on_add('spaceformorecustomfieldhtml_'+field_id, 'customfield_html_'+field_name, (count-1));
                var ind = field_name+'_'+(count-1)
                
				var f_aut0 = document.createElement('textarea');
				f_aut0.setAttribute('name',field_name+'[]');
				f_aut0.setAttribute('id', ind);
				f_aut0.setAttribute('wrap','wrap');
				f_aut0.setAttribute('width',field_width+'px');
				f_aut0.setAttribute('height',field_height+'px');
                
				var parentDiv = document.createElement('div');
				parentDiv.setAttribute('style','display: inline-block; width: 97%;');
				parentDiv.appendChild(f_aut0);
                
				// Evenement pour rafraichir le contenu de l'editeur et viter les bugs d'affichage lors du drag & drop
				document.body.addEventListener('dragged_customfield_html_' + ind, function() {
					tinyMCE_execCommand('mceRemoveControl', true, ind);
					tinyMCE_execCommand('mceAddControl', true, ind);
				});
                
				document.getElementById(node_dnd_id).appendChild(parentDiv);
				document.getElementById(node_dnd_id).appendChild(document.createElement('br'));
				document.getElementById(node_dnd_id).appendChild(document.createElement('br'));
				if (use_html_editor) {
					add_html_editor(field_name,(count-1));
				}
                document.getElementById('customfield_html_'+field_id).value = count++;
			}
			</script>";
        }
    }
    
    protected static function get_event_button_add($field) {
        global $pmb_javascript_office_editor;
        
        $options=$field['OPTIONS'][0];
        if($pmb_javascript_office_editor && $options['HTMLEDITOR'][0]['value'])	{
            $use_editor_html = "1";
        } else {
            $use_editor_html = "0";
        }
        return 'add_custom_html_(\''.$field["ID"].'\', \''.addslashes($field['NAME']).'\','.$options['HEIGHT'][0]['value'].','.$options['WIDTH'][0]['value'].','.$use_editor_html.')';
    }
    
    public static function get_display_value($field, $indice, $value) {
        global $cms_dojo_plugins_editor;
        return "
        <input type='hidden' name='".$field['NAME']."[]' value=''/>
        <div data-dojo-type='dijit/Editor' $cms_dojo_plugins_editor	id='".$field['NAME']."' class='saisie-80em' wrap='virtual'>".$value."</div>
        ";
    }
    
    public static function aff($field, &$check_scripts) {
        $ret = parent::aff($field, $check_scripts);
        return $ret;
    }
    
    public static function get_rgaa_label($field, $varname) {
        return $field['NAME'];
    }
}