<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: rfid_config.inc.php,v 1.10.16.1 2026/01/13 08:41:01 qvarin Exp $

if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) {
    die("no access");
}

function get_rfid_port()
{
    global $pmb_rfid_ip_port, $_SERVER;

    // Donne le port rfid associ  l'ip du client
    $rfid_port = '';
    if ($pmb_rfid_ip_port) {
        $rfid_port_list = [];
        $rfid_cmds = explode(";", $pmb_rfid_ip_port);
        foreach ($rfid_cmds as $rfid_cmd) {
            $rfid_cmd_1 = explode(",", $rfid_cmd);
            if ($rfid_cmd_1[0]) {
                $rfid_port_list[trim($rfid_cmd_1[0])] = trim($rfid_cmd_1[1] ?? '');
            }
        }

        if (!empty($rfid_port_list[$_SERVER['REMOTE_ADDR']])) {
            $rfid_port = $rfid_port_list[$_SERVER['REMOTE_ADDR']];
        }
    }
    return $rfid_port;
}

function get_rfid_js_header()
{
    global $pmb_rfid_driver,$pmb_rfid_serveur_url,$pmb_rfid_library_code,$pmb_rfid_afi_security_codes;
    global $rfid_js_header, $pmb_rfid_activate;
    global $base_path;

    if (!$pmb_rfid_activate) {
        $rfid_js_header = "";
        return;
    }

    $afi_active = '';
    $afi_off = '';
    if (!empty($pmb_rfid_afi_security_codes)) {
        $codes_afi = explode(",", $pmb_rfid_afi_security_codes, 2);
        if (count($codes_afi) == 2) {
            $afi_active = $codes_afi[0];
            $afi_off = $codes_afi[1];
        } else {
            trigger_error('RFID AFI security codes must be exactly 2 values separated by a comma', E_USER_NOTICE);
        }
    }

    $rfid_js_header = '
    <script>
        url_serveur_rfid="'. $pmb_rfid_serveur_url .'";
        SerialPort="'. get_rfid_port() .'";
        LibraryCode="'. $pmb_rfid_library_code .'";
        rfid_afi_security_active="'. $afi_active .'";
        rfid_afi_security_off="'. $afi_off .'";
    </script>
    <script src="'. $base_path .'/javascript/pmbtoolkit.js"></script>
    <script src="'. $base_path .'/javascript/soap.js"></script>
    <script src="'. $base_path .'/javascript/rfid/rfid_pret.js"></script>';

    $rifd_driver_directory = $base_path."/javascript/rfid/" . basename($pmb_rfid_driver);
    if (is_dir($rifd_driver_directory)) {
        $files = array_filter(glob("{$rifd_driver_directory}/*"), 'is_file');
        $files = array_filter($files, function ($file) {
            return pathinfo($file, PATHINFO_EXTENSION) === 'js';
        });

        sort($files);
        foreach ($files as $filename) {
            $rfid_js_header .= '<script src="'. $rifd_driver_directory .'/'. $filename .'"></script>';
        }
    }
}
