<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: OpacDiffusions.php,v 1.2.2.3 2026/01/15 08:56:00 rtigero Exp $
namespace Pmb\DSI\Opac\Models;

use encoding_normalize;
use Pmb\Common\Models\Model;
use Pmb\DSI\Models\Diffusion;
use Pmb\DSI\Models\DiffusionHistory;
use Pmb\DSI\Models\Product;
use Pmb\DSI\Models\SubscriberList\RootSubscriberList;
use Pmb\DSI\Models\SubscriberList\Subscribers\Subscriber;
use Pmb\DSI\Models\SubscriberList\Subscribers\SubscriberEmpr;
use Pmb\DSI\Orm\DiffusionOrm;
use Pmb\DSI\Orm\DiffusionProductOrm;
use Pmb\DSI\Orm\SubscribersDiffusionOrm;
use Pmb\DSI\Orm\SubscribersProductOrm;

class OpacDiffusions extends Model
{
	protected $idEmpr;
	protected $empr;

	public function __construct($idEmpr = 0)
	{
		$this->idEmpr = $idEmpr;
		$this->empr = new \emprunteur(intval($this->idEmpr));
	}

	public function getOpacDiffusions()
	{
		$result = array();
		$diffusions = DiffusionOrm::finds([
			"settings" => [
				"value" => "%\"opacVisibility\":true%",
				"operator" => "LIKE",
				"inter" => "AND"
			]
		]);
		foreach ($diffusions as $diffusion) {
			if (! $this->checkDiffusionOpacFilters($diffusion)) {
				continue;
			}

			$result[] = $this->formatDiffusion($diffusion->id_diffusion);
		}
		return $result;
	}

	public function getOpacDiffusionsPrivate($emprType = "pmb")
	{
		$result = array();
		switch ($emprType) {
			case "pmb":
				//Dans le cas d'un emprunteur on met l'idempr directement dans les settings
				//de la diffusion pour faciliter les choses
				$params = [
					"settings" => [
						"value" => "%\"idEmpr\":" . $this->idEmpr . "%",
						"operator" => "LIKE",
						"inter" => "AND"
					]
				];
				break;
			default:
				$params = array();
				break;
		}
		$diffusions = DiffusionOrm::finds($params);
		foreach ($diffusions as $diffusion) {
			$result[] = $this->formatDiffusion($diffusion->id_diffusion);
		}
		return $result;
	}

	private function formatDiffusion($idDiffusion)
	{
		$result = array();
		$diffusionModel = new Diffusion($idDiffusion);
		$result['settings'] = $diffusionModel->settings;
		$result['id'] = $diffusionModel->idDiffusion;
		$diffusionModel->fetchLastDiffusion();
		$diffusionModel->fetchDiffusionHistory();
		$diffusionModel->fetchChannel();
		$result['lastDiffusion'] = $diffusionModel->lastDiffusion;
		$result['diffusionHistory'] = $this->formatHistory($diffusionModel->diffusionHistory);
		$diffusionModel->fetchItem();
		$result['nbResults'] = $diffusionModel->item->getNbResults();
		$result['searchInput'] = $diffusionModel->item->getSearchInput();
		$result['isSubscribed'] = $diffusionModel->isSubscribed($this->idEmpr);
		$result['tags'] = $diffusionModel->tags;
		//Pas de subscriber pour certains canaux
		if (! isset($diffusionModel->channel::CHANNEL_REQUIREMENTS["subscribers"]) || empty($diffusionModel->channel::CHANNEL_REQUIREMENTS["subscribers"])) {
			$result["subscriber"] = null;
			return $result;
		}
		$result['subscriber'] = $this->getSubscriberFromEntity("diffusions", $diffusionModel->idDiffusion);
		if (! $result['subscriber']) {
			//Si on n'a rien en subscriber, on passe un subscriber par dfaut avec les infos de l'emprunteur
			$result['subscriber'] = Subscriber::getInstance("diffusions", 0);
			//TODO voir pour les autres canaux que mail
			$query = "SELECT empr_cb, empr_mail, empr_nom, empr_prenom, empr_tel1, empr_tel2 FROM empr WHERE id_empr = '" . $this->idEmpr . "'";
			$res = pmb_mysql_query($query);
			if (pmb_mysql_num_rows($res)) {
				$result['subscriber']->settings->idEmpr = intval($this->idEmpr);
				$result['subscriber']->settings->cb = pmb_mysql_result($res, 0, "empr_cb");
				$result['subscriber']->settings->email = pmb_mysql_result($res, 0, "empr_mail");
				$result['subscriber']->settings->phone = pmb_mysql_result($res, 0, "empr_tel1");
				$result['subscriber']->settings->phone2 = pmb_mysql_result($res, 0, "empr_tel2");
				$result['subscriber']->name = pmb_mysql_result($res, 0, "empr_prenom") . " " . pmb_mysql_result($res, 0, "empr_nom");
			}
		}

		return $result;
	}

	/**
	 * Vrifie si un emprunteur est est base pour une entite donne
	 *
	 * @param $entityType int
	 * @param $entityId int
	 * @return Subscriber | null
	 */
	public function getSubscriberFromEntity($entityType, $entityId)
	{
		$searchSubscriber = array();
		switch ($entityType) {
			case "diffusions":
				$searchSubscriber = SubscribersDiffusionOrm::finds([
					"num_diffusion" => $entityId,
					'settings' => [
						"value" => '%"idEmpr":' . $this->idEmpr . '%',
						"operator" => "LIKE",
						"inter" => "AND"
					]
				]);
				break;
			default:
				break;
		}
		if (count($searchSubscriber) == 1) {
			$idSubscriber = $searchSubscriber[0]->id_subscriber_diffusion;
			return Subscriber::getInstance($entityType, $idSubscriber);
		}
		return null;
	}

	private function formatHistory($diffusionHistory)
	{
		$result = array();
		foreach ($diffusionHistory as $history) {
			if ($history->state != DiffusionHistory::SENT) {
				continue;
			}
			$result[] = [
				"date" => $history->formatedDate,
				"id" => $history->idDiffusionHistory,
				"render" => $history->previewView()
			];
		}
		return $result;
	}

	private function checkDiffusionOpacFilters($diffusion)
	{
		$settings = $diffusion->settings;
		if (is_string($settings)) {
			$settings = encoding_normalize::json_decode($diffusion->settings);
		}

		//Filtrage des diffusions publiques
		if (! empty($settings->opacVisibilityCateg) && array_search($this->empr->categ, $settings->opacVisibilityCateg) === false) {
			return false;
		}
		if (! empty($settings->opacVisibilityGroups)) {
			if (! $this->checkOpacVisibilityGroups($settings->opacVisibilityGroups)) {
				return false;
			}
		}

		return true;
	}

	/**
	 * Vrifie la visibilit des groupes Opac.
	 *
	 * @param array $groups Les groupes  vrifier.
	 * @return bool Renvoie true si au moins un groupe est visible, false sinon.
	 */
	private function checkOpacVisibilityGroups($groups)
	{
		$groups = implode(",", $groups);
		$query = "SELECT * FROM empr_groupe WHERE empr_id = " . $this->idEmpr . " AND groupe_id IN (" . $groups . ")";
		$res = pmb_mysql_query($query);
		if (pmb_mysql_num_rows($res)) {
			return true;
		}
		return false;
	}

	public function subscribeFromOpac(string $entityType, int $entityId, $id = null, $subscriberData = null)
	{

		global $msg;

		//On vrifie si on n'est pas sur un rabonnement
		if ($entityType == "diffusions") {
			//Si on est sur une diffusion on vrifie les produits associs
			$diffusionProducts = DiffusionProductOrm::finds([
				"num_diffusion" => $entityId,
			]);
			foreach ($diffusionProducts as $diffusionProduct) {
				$this->subscribeFromOpac("products", $diffusionProduct->num_product, false);
			}
		}

		$idSubscriber = 0;
		switch ($entityType) {
			case "diffusions":
				$searchSubscriber = SubscribersDiffusionOrm::finds([
					"num_diffusion" => $entityId,
					'settings' => [
						"value" => '%"idEmpr":' . $id . '%',
						"operator" => "LIKE",
						"inter" => "AND"
					]
				]);
				if (count($searchSubscriber) == 1) {
					$idSubscriber = $searchSubscriber[0]->id_subscriber_diffusion;
				}
				break;
			case "products":
				$searchSubscriber = SubscribersProductOrm::finds([
					"num_product" => $entityId,
					'settings' => [
						"value" => '%"idEmpr":' . $id . '%',
						"operator" => "LIKE",
						"inter" => "AND"
					]
				]);
				if (count($searchSubscriber) == 1) {
					$idSubscriber = $searchSubscriber[0]->id_subscriber_product;
				}
				break;
		}
		//On verifie si l'abonn fait partie de la source
		if ($idSubscriber && $this->checkSubscriberSource($entityType, $entityId, $id)) {
			//Il est deja dans la source, on supprime juste l'entre en base dans ce cas
			$subscriber = Subscriber::getInstance($entityType, $idSubscriber);
			$subscriber->delete();
			return $subscriber;
		}

		$subscriber = Subscriber::getInstance($entityType, $idSubscriber);
		$subscriber->setFromForm($subscriberData);
		$subscriber->setEntity($entityId);
		if ($idSubscriber == 0) {
			if ($entityType == "diffusions") {
				//On vrifie si l'abonn respecte les prrequis du canal avant de l'inscrire
				//Sinon bah RIP
				if (! $subscriber->checkRequirements()) {
					$missingRequirements = $subscriber->getMissingRequirements();
					$missingInfos = "";
					foreach ($missingRequirements as $requirement) {
						$missingInfos .= $msg["subscriber_requirements_" . $requirement] . ", ";
					}
					$missingInfos = substr($missingInfos, 0, -2);
					return [
						"error" => true,
						"errorMessage" => sprintf($msg["subscriber_requirements_not_met"], $missingInfos)
					];
				}
			}
			//Nouvelle inscription ? Alors on met en manuel
			$subscriber->type = RootSubscriberList::SUBSCRIBER_TYPE_MANUAL;
			$subscriber->create();
		}

		return $subscriber->subscribe();
	}

	/**
	 * Dsinscription d'un abonn depuis l'OPAC
	 * @param string $entityType
	 * @param int $entityId
	 * @param bool $ajax
	 */
	public function unsubscribeFromOpac(string $entityType, int $entityId, $idEmpr = 0, $subscriberData = null)
	{
		if ($entityType == "diffusions") {
			//Si on est sur une diffusion on vrifie les produits associs
			$diffusionProducts = DiffusionProductOrm::finds([
				"num_diffusion" => $entityId,
			]);
			foreach ($diffusionProducts as $diffusionProduct) {
				$this->unsubscribeFromOpac("products", $diffusionProduct->num_product, $idEmpr, $subscriberData);
			}
		}

		$id = $subscriberData->id ?? 0;
		if ($entityType == "products") {
			//On envoie que l'id d'un subscriber diffusion depuis l'opac
			$id = 0;
		}

		switch ($entityType) {
			case "diffusions":
				$entity = new Diffusion($entityId);
				$entity->fetchSubscriberList();
				break;
			case "products":
				$entity = new Product($entityId);
				$entity->fetchSubscriberList();
				break;
		}

		//Cas d'une DSI prive, on supprime la diffusion  la dsinscription
		if ($entityType == "diffusions" && isset($entity->settings->idEmpr) && $entity->settings->idEmpr == $idEmpr) {
			$entity->delete();
			return true;
		}

		//On regarde en base
		foreach ($entity->subscriberList->lists->subscribers as $subscriber) {
			if ($subscriber->getIdEmpr() == $idEmpr) {
				//On a rcupr l'entre en base donc on change les proprits
				//Pour dsinscrire
				$subscriber->unsubscribeFromSubscriber();

				if (0 == $subscriber->id) {
					$subscriber->create();
				} else {
					$subscriber->update();
				}
				return $subscriber;
			}
		}

		//On regarde si l'abonn fait partie de la source
		foreach ($entity->subscriberList->source->subscribers as $subscriber) {
			if ($subscriber->getIdEmpr() == $idEmpr) {
				//Alors on le dsinscrit de la source
				$type = RootSubscriberList::SUBSCRIBER_TYPE_SOURCE;
				$subscriber = Subscriber::getInstance($entityType, $id);
				$subscriber->type = $type;
				$subscriber->setFromForm($subscriberData);
				$subscriber->setEntity($entityId);
				$subscriber->unsubscribeFromSubscriber();
				//On ajoute donc une entree en base pour desinscrire d'une source
				if (0 == $id) {
					$subscriber->create();
				} else {
					$subscriber->update();
				}

				return $subscriber;
			}
		}
	}

	protected function checkSubscriberSource(string $entityType, int $entityId, int $idEmpr)
	{
		if ($entityType == "diffusions") {
			$entity = new Diffusion($entityId);
			$entity->fetchSubscriberList();
		}

		if ($entityType == "products") {
			$entity = new Product($entityId);
			$entity->fetchSubscriberList();
		}

		//On prend directement les donnes du slecteur pour esquiver les filtres
		$source = $entity->subscriberList->source->getSelectorData();

		foreach ($source as $subscriber) {
			if ($subscriber->getIdEmpr() == $idEmpr) {
				return true;
			}
		}
		return false;
	}

	public function getSubscriberFromType($emprType, $id)
	{
		$subscriber = null;
		switch ($emprType) {
			case "pmb":
				//On rcupre les infos de l'emprunteur
				$subscriber = new SubscriberEmpr();
				$query = "SELECT empr_cb, empr_nom, empr_prenom, empr_mail, empr_tel1, empr_tel2, allow_dsi_priv FROM empr
					JOIN empr_statut ON empr_statut.idstatut = empr.empr_statut
					WHERE id_empr = '" . $id . "'";
				$result = pmb_mysql_query($query);
				if (pmb_mysql_num_rows($result) == 1) {
					$row = pmb_mysql_fetch_assoc($result);
					$subscriber->settings->idEmpr = intval($id);
					$subscriber->settings->cb = $row['empr_cb'];
					$subscriber->settings->email = $row['empr_mail'];
					$subscriber->settings->phone = $row['empr_tel1'];
					$subscriber->settings->phone2 = $row['empr_tel2'];
					$subscriber->settings->allowDsiPriv = intval($row['allow_dsi_priv']);
					$subscriber->name = $row['empr_prenom'] . ' ' . $row['empr_nom'];
					//En passant par ici on sera sur un emprunteur de la source
					$subscriber->type = RootSubscriberList::SUBSCRIBER_TYPE_SOURCE;
				}
				break;
			default:
				$subscriber = Subscriber::getInstance("diffusions", $id);
				break;
		}

		return $subscriber;
	}
}
