<?php

namespace Pmb\DSI\Controller;

use Pmb\DSI\Models\Diffusion;
use Pmb\DSI\Models\DiffusionProduct;
use Pmb\DSI\Models\Product;
use Pmb\DSI\Models\SubscriberList\RootSubscriberList;
use Pmb\DSI\Models\SubscriberList\Subscribers\Subscriber;
use Pmb\DSI\Opac\Models\OpacDiffusions;
use Pmb\DSI\Orm\DiffusionProductOrm;
use Pmb\DSI\Orm\SubscribersDiffusionOrm;
use Pmb\DSI\Orm\SubscribersProductOrm;

class SubscribersController extends CommonController
{

	public function delete($entityType = "")
	{
		$subscriber = Subscriber::getInstance($entityType, $this->data->id);
		$result = $subscriber->delete();

		if ($result['error']) {
			$this->ajaxError($result['errorMessage']);
			exit();
		}
		$this->ajaxJsonResponse([
			'success' => true
		]);
		exit();
	}

	public function getEntity($entityType = "", $idSubscriber = 0)
	{
		return $this->ajaxJsonResponse(Subscriber::getInstance($entityType, $idSubscriber));
	}

	public function save($entityType, $entityId)
	{
		$this->data->id = intval($this->data->id);
		$subscriber = Subscriber::getInstance($entityType, $this->data->id);
		$subscriber->setFromForm($this->data);
		$subscriber->setEntity($entityId);
		$result = $subscriber->check($this->data);
		if (isset($result['error'])) {
			$this->ajaxError($result['errorMessage']);
			exit();
		}


		if (0 == $this->data->id) {
			$subscriber->create();
		} else {
			$subscriber->update();
		}
		$this->ajaxJsonResponse($subscriber);
		exit();
	}

	/**
	 * Ajoute les subscribers a partir d'une liste contenant une source
	 *
	 * @param number $idSubscriberList
	 */
	public function importSubscribers(string $entityType, int $idEntity = 0)
	{
		$subscribers = array();
		$error = false;
		if (! empty($this->data->subscribers)) {
			foreach ($this->data->subscribers as $subscriber) {
				$subscriberModel = Subscriber::getInstance($entityType);
				$subscriberModel->setFromForm($subscriber);
				$subscriberModel->setEntity($idEntity);
				$result = $subscriberModel->check($subscriber);
				if (isset($result['error'])) {
					$error = $result;
					continue;
				}
				$subscriberModel->create();
				$subscribers[] = $subscriberModel;
			}
		}
		if ($error && count($subscribers) == 0) {
			$this->ajaxJsonResponse($error);
		}
		$this->ajaxJsonResponse($subscribers);
	}

	/**
	 * Desinscrit un abonne issu d'une source
	 * On peut galement passer un tableau de subscribers pour une dsinscription multiple
	 * @param string $entityType
	 * @param int $entityId
	 */
	public function unsubscribe(string $entityType, int $entityId)
	{
		//Cas ou on a un tableau
		if (isset($this->data->subscribers) && is_array($this->data->subscribers)) {
			foreach ($this->data->subscribers as $subscriber) {
				$newSubscriber = Subscriber::getInstance($entityType, $subscriber->id);
				$newSubscriber->setFromForm($subscriber);
				$newSubscriber->setEntity($entityId);
				$newSubscriber->unsubscribe();

				if (0 == $subscriber->id) {
					$newSubscriber->create();
				} else {
					$newSubscriber->update();
				}
			}
			$this->ajaxJsonResponse($this->data->subscribers);
			exit();
		}

		//Cas d'un subscriber unique
		$subscriber = Subscriber::getInstance($entityType, $this->data->id);
		$subscriber->setFromForm($this->data);
		$subscriber->setEntity($entityId);
		$subscriber->unsubscribe();

		if (0 == $this->data->id) {
			$subscriber->create();
		} else {
			$subscriber->update();
		}
		$this->ajaxJsonResponse($subscriber);
		exit();
	}

	/**
	 * Reinscrit un abonne desinscrit
	 * @param string $entityType
	 * @param int $entityId
	 */
	public function subscribe(string $entityType, int $entityId)
	{
		$subscriber = Subscriber::getInstance($entityType, $this->data->id);
		$result = $subscriber->subscribe();

		$this->ajaxJsonResponse($result);
		exit();
	}

	/**
	 * Inscription d'un abonn depuis l'OPAC
	 * @param string $entityType
	 * @param int $entityId
	 * @param bool $ajax
	 */
	public function subscribeFromOpac(string $entityType, int $entityId, bool $ajax = true)
	{

		$opacDiffusionsModel = new OpacDiffusions($this->data->settings->idEmpr);
		$result = $opacDiffusionsModel->subscribeFromOpac($entityType, $entityId, $this->data->settings->idEmpr, $this->data);
		if ($ajax) {
			if (is_array($result) && isset($result['error']) && $result['error']) {
				$this->ajaxError($result['errorMessage']);
				exit();
			}
			$this->ajaxJsonResponse($result);
			exit();
		}
		return $result;
	}

	/**
	 * Dsinscription d'un abonn depuis l'OPAC
	 * @param string $entityType
	 * @param int $entityId
	 * @param bool $ajax
	 */
	public function unsubscribeFromOpac(string $entityType, int $entityId, bool $ajax = true)
	{
		$opacDiffusionsModel = new OpacDiffusions($this->data->settings->idEmpr);
		$result = $opacDiffusionsModel->unsubscribeFromOpac($entityType, $entityId, $this->data->settings->idEmpr, $this->data);
		if ($ajax) {
			$this->ajaxJsonResponse($result);
			exit();
		}
		return $result;
	}

	/**
	 * Supprime tous les subscribers d'une entite en base
	 */
	public function empty()
	{
		$subscriber = Subscriber::getInstance($this->data->entityType);
		$subscriber->setEntity($this->data->entityId);
		$empty = $subscriber->emptySubscribers();
		return $this->ajaxJsonResponse($empty);
	}

	/**
	 * Vrifie si un abonn fait partie de la source
	 *
	 * @param string $entityType
	 * @param int $entityId
	 * @param int $idEmpr
	 * @return bool
	 */
	protected function checkSubscriberSource(string $entityType, int $entityId, int $idEmpr)
	{
		if ($entityType == "diffusions") {
			$entity = new Diffusion($entityId);
			$entity->fetchSubscriberList();
		}

		if ($entityType == "products") {
			$entity = new Product($entityId);
			$entity->fetchSubscriberList();
		}

		//On prend directement les donnes du slecteur pour esquiver les filtres
		$source = $entity->subscriberList->source->getSelectorData();

		foreach ($source as $subscriber) {
			if ($subscriber->getIdEmpr() == $idEmpr) {
				return true;
			}
		}
		return false;
	}
}
