// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: warningMessage.js,v 1.8 2024/04/03 07:24:10 qvarin Exp $

define([
    "dojo/_base/declare",
    "dojo/topic",
    "dojo/_base/lang",
    "dijit/Dialog",
    "dojo/dom",
    "dijit/form/Button"
], function(declare, topic, lang, Dialog, dom, Button) {
    return declare(null, {
        errorDialog : null,
        buttonClose : null,
        title : "",
        mode : "", // nom event à renvoyer pour reprendre la lecture dans le bon mode
        constructor : function(mode, warningMessage, title) {
            this.title = title;

            if (dom.byId('dialogContent')) {
                return;
            }

            this.mode = mode;
            this.warningMessage = warningMessage;

            let closeWarningClosure = lang.hitch(this, this.closeFromHide);
            this.errorDialog = new Dialog({
                title : this.title,
				className: 'warning_dialog',
                style : "width: 300px",
                content : "<div id='dialogContent' class='returnMessage'></div><div class='buttonClose' id='buttonClose'></div>",
                onHide : closeWarningClosure,
            });
            this.errorDialog.startup();

            this.buttonClose = new Button({
                label : "Fermer",
				className: 'warning_button_close',
                onClick : lang.hitch(this, this.closeWarningMessages),
            }, 'buttonClose');
            this.buttonClose.startup();

            this.errorDialog.show();
            this.fillDialog();

            play_single_sound("audioNOk");
        },

        /**
         * Permet quel que soit le mode de fermeture du
         * popup, de le supprimer
         * (touche échap; appui sur le bouton fermer; appui sur fermer)
         */
        closeWarningMessages : function() {
            this.errorDialog.hide();
        },

        closeFromHide : function() {
            this.buttonClose.destroy();
            this.errorDialog.destroy();
            this.errorDialog = null;
            this.buttonClose = null;

            topic.publish('warningMessage', this.mode);
        },

        /**
         * Crée une liste de message
         */
        fillDialog : function() {
            let content = "<ul class='warningMessageList'>";
            if ( typeof this.warningMessage == "string") {
                content += "<li class='warningMessage'>" + this.warningMessage + "</li>";
            } else {
                for (let i = 0; i < this.warningMessage.length; i++) {
                    content += "<li class='warningMessage'>" + this.warningMessage[i] + "</li>";
                }
            }
            content += "</ul>";
            dom.byId('dialogContent').innerHTML = content;
        },
    });
});
