// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: resaContainer.js,v 1.9 2019/06/27 13:46:26 ngantier Exp $

define(["dojo/_base/declare", "dojox/grid/DataGrid", "dojo/topic", "dojo/_base/lang", "dojo/dom-construct", "dijit/registry", "dojo/store/Memory", "dojo/data/ObjectStore", "dojo/dom"], function(declare, DataGrid, topic, lang, domConstruct, registry, Memory, ObjectStore, dom) {
    return declare(null, {
        dataGrid : null,
        resaStore : null,
        datasResa : null,
        readingEnabled : true,
        constructor : function() {
            /**
             * Création du store de prêt
             * Instanciation du datagrid
             *
             */
            this.datasResa = new Array();
            var nb_resa_confimee = 0;            
            for (var i = 0; i < dojoConfig.bibloto.readerDatas.emprInfos.reservations.length; i++) {
            	if(dojoConfig.bibloto.readerDatas.emprInfos.reservations[i].confirmee == 1) {
            		nb_resa_confimee++;
            	}
                this.datasResa.push({
                	"title" : dojoConfig.bibloto.readerDatas.emprInfos.reservations[i].icondoc + dojoConfig.bibloto.readerDatas.emprInfos.reservations[i].title,
                    "icondoc" : dojoConfig.bibloto.readerDatas.emprInfos.reservations[i].icondoc,
                    "resa_date" : dojoConfig.bibloto.readerDatas.emprInfos.reservations[i].date,
                    'resa_confirmed' : (dojoConfig.bibloto.readerDatas.emprInfos.reservations[i].confirmee == 1) ? 'Oui' : 'Non'
                });
            }

            //this.datasLoan = {'items': {'items':this.datasLoan}};

            this.resaStore = new ObjectStore({
                objectStore : new Memory({
                    data : this.datasResa
                })
            });
            
            nb_resa_display = '';
            nb_resa_confirmee_display = '';
            if (dojoConfig.bibloto.readerDatas.emprInfos.reservations.length) {
            	nb_resa_display = ' (' + dojoConfig.bibloto.readerDatas.emprInfos.reservations.length + ')';
            	if (nb_resa_confimee > 0) {
            		nb_resa_confirmee_display = ' (' + nb_resa_confimee + ')'
            	}
            }
            this.dataGrid = new DataGrid({
                autoHeight : true,
                store : this.resaStore,
                escapeHTMLInData: false,
                query : {
                    id : "*"
                },
                structure : [{
                    name : dojoConfig.bibloto.appParams.msg_resa_title + nb_resa_display,
                    field : "title",
                    editable : false,
                    width : "45%"
                }, {
                    name : dojoConfig.bibloto.appParams.msg_resa_date_title,
                    field : "resa_date",
                    editable : false,
                    width : "25%"
                }, {
                    name : dojoConfig.bibloto.appParams.msg_resa_confirme_title + nb_resa_confirmee_display,
                    field : "resa_confirmed",
                    editable : false,
                    width : "30%"
                }]
            }, domConstruct.create('div', {
                id : 'resaDatas',
                style : {
                    height : '300px',
                    width : 'auto',
                }
            }, registry.byId('contentZone').domNode));

            this.dataGrid.startup();
            // topic.subscribe('actionZone', lang.hitch(this, this.handleEvents));
        },
    });
});
