// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: readerDatas.js,v 1.48 2025/05/15 15:10:07 tsamson Exp $

define(["dojo/_base/declare", "dojo/topic", "dojo/_base/lang", 'app/warningMessage', 'dojo/on', "dojo/dom-construct", "dojo/request/xhr", "dijit/form/Button", "dijit/registry", "dojo/dom"], function(declare, topic, lang, warningMessage, on, domConstruct, xhr, Button, registry, dom) {
    return declare(null, {
        emprCb : null,
        emprInfos : null,
        mode : 0, //0 - attente d'une carte lecteur ; 1 - Mode prêt ; 2 - Mode retour ; 3 - Mode attente (pas de lecture effective)
        timer : null,
        currentTempLoan : null,
		extAuth : false,
        constructor : function() {
            /** Abonnement aux évenements provenant des classes "buffer" et "actionZone" **/
            topic.subscribe('buffer', lang.hitch(this, this.handleEvents));
            topic.subscribe('actionZone', lang.hitch(this, this.handleEvents));
            topic.subscribe('warningMessage', lang.hitch(this, this.handleEvents));
            topic.subscribe('reader_rfid', lang.hitch(this, this.handleEvents));
            topic.subscribe('keyboard', lang.hitch(this, this.handleEvents));
            topic.subscribe('workZone', lang.hitch(this, this.handleEvents));
            topic.subscribe('loanContainer', lang.hitch(this, this.handleEvents));
        },
        handleEvents : function(evtType, evtArgs) {
        	//console.debug('evt received in READER DATAS', evtType, evtArgs);
            switch (evtType) {
            /** erase: Évenement envoyé par la classe actionZone lors d'un appui sur le bouton retourner à la page d'accueil **/
            case 'erase' :
                this.mode = 0;
                this.eraseTimer();
	            if (this.extAuth) {
					this.logoutExtAuth();
                    this.extAuth = false;
				}
                break;
            /** eltAdded: Évenement envoyé par la classe buffer lorsqu'un éléments est lu **/
            case 'eltAdded' :
                switch (this.mode) {
	                case 0 :
	                    this.fetchEmpr(evtArgs.elt);
	                    break;
	                case 1 :
	                    this.callLoanTemp(evtArgs.elt);
	                    break;
	                case 2 :
	                    this.callExplInfos(evtArgs.elt);
	                    break;
                }
                break;

            /** évenements diffusés par la classe actionZone **/
            case 'enableFetchEmpr':
                this.mode = 0;
                break;
            case 'enableLoan' :
                dojoConfig.bibloto.appParams.rfid_lastVal = "";
                this.mode = 1;
                break;
            case 'enableBack' :
                dojoConfig.bibloto.appParams.rfid_lastVal = "";
                this.mode = 2;
                break;
            case 'stopListen':
                this.mode = 3;
                break;
            /** évenements diffusés par la classe reader **/
            case 'rfid_expl':
                //console.debug("readerDatas, reader_rfid, rfid_expl:", evtArgs);
                if (evtArgs.cb[0]) {
                    switch (this.mode) {
                    case 1 :
                        //console.debug("readerDatas, rfid_expl, callLoanTemp:", evtArgs);
                        this.callLoanTemp(evtArgs.cb[0]);
                        break;
                    case 2 :
                        //this.callRetour(evtArgs.cb[0]);
                        this.callExplInfos(evtArgs.cb[0]);
                        break;
                    }
                }
                break;
            case 'rfid_noexpl':
                //console.debug("readerDatas, reader_rfid, rfid_noexpl");
                switch (this.mode) {
                case 1 :
                    //console.debug("readerDatas, rfid_noexpl, callLoanTempDel:", evtArgs);
                    this.callLoanTempDel(evtArgs.cb[0]);
                    break;
                case 2 :
                    topic.publish('readerDatas', 'noExplBack');
                    break;
                }
                break;
            case 'rfid_toomanyExpl':
                switch (this.mode) {
                //Trop d'exemplaire en prêt
                case 1 :
                    topic.publish('readerDatas', 'tooManyExplLoan');
                    break;
                case 2 :
                    topic.publish('readerDatas', 'tooManyExplLoan');
                    break;
                }
                // topic.publish('readerDatas', 'tooManyExpl');
                break;
            case 'rfid_empr':
                //console.debug("readerDatas, reader_rfid, rfid_empr");
                switch (this.mode) {
                case 0 :
                    //console.debug("readerDatas, reader_rfid, rfid_empr");
                    this.mode = 3;
                    this.fetchEmpr(evtArgs.cb[0]);
                    break;
                }
                break;
            /** évenement diffusé lors de la validation d'un prêt ou d'un retour par la classe workZone **/
            case 'validateAction':
                //console.debug('MODE READER DATAS', this.mode);
                switch(this.mode) {
                case 1:
                    //Appel du pret definitif
                    this.callLoan(dojoConfig.bibloto.appParams.rfid_lastVal);
                    break;
                case 2:
                    //appêl du retour
                    this.callBack(dojoConfig.bibloto.appParams.rfid_lastVal);
                    break;
                }
                break;
            case 'sendMailPret' :
                this.sendMailPret();
                break;
            case 'prolonge' :
                this.prolonge(evtArgs);
                break;
            case 'extAuth' :
                this.testExtAuth(evtArgs);
                break;
            }
        },
        /** requete json rpc pour effectuer le prêt temporaire**/
        callLoanTemp : function(expl) {
            this.reInitTimer();
            this.mode = 3;
            var emprPretPromise = dojoConfig.bibloto.jsonRpcServer.pmbesSelfServices_self_checkout_bibloto(expl, this.emprCb, 0);
            emprPretPromise.addCallback(lang.hitch(this, function(response) {
                this.currentTempLoan = expl;
                this.mode = 1;
                topic.publish('readerDatas', 'loanTempResponse', {
                    response : response
                });
            }));

        },
        /** requete json rpc pour effacer le prêt temporaire**/
        callLoanTempDel : function(expl) {
            this.reInitTimer();
            this.mode = 3;
            var emprPretPromise = dojoConfig.bibloto.jsonRpcServer.pmbesSelfServices_self_del_temp_pret(expl);
            emprPretPromise.addCallback(lang.hitch(this, function(response) {
                topic.publish('readerDatas', 'loanTempDelResponse', {
                    response : response
                });
                this.mode = 1;
            }));

        },
        /** requete json rpc pour confirmer le prêt**/
        callLoan : function(expl) {
            this.reInitTimer();
            this.mode = 3;
            var emprPretPromise = dojoConfig.bibloto.jsonRpcServer.pmbesSelfServices_self_checkout_bibloto(expl, this.emprCb, 1);
            emprPretPromise.addCallback(lang.hitch(this, function(response) {
                topic.publish('readerDatas', 'loanResponse', {
                    response : response
                });

                this.mode = 1;
            }));

        },

        /** requete json rpc pour effectuer le retour **/
        callBack : function(expl) {
            this.reInitTimer();
            this.mode = 3;
            var emprBackPromise = dojoConfig.bibloto.jsonRpcServer.pmbesSelfServices_self_checkin(expl, null, 'bibloto');
            emprBackPromise.addCallback(lang.hitch(this, function(response) {
                topic.publish('readerDatas', 'backResponse', {
                    response : response
                });
                this.mode = 2;
            }));
        },
        /** requête jsonRpc pour récupérer les infos emprunteur **/
        fetchEmpr : function(cb) {
            /**
             * fetch data et callback
             */
        	if(dojoConfig.bibloto.mapping){
        		if(dojoConfig.bibloto.mapping[cb]) {
        			this.emprCb = dojoConfig.bibloto.mapping[cb];
        		} else {
        			this.emprCb='';
        			this.mode = 3;
        			new warningMessage('enableFetchEmpr', 'Lecteur inconnu', 'Erreur');
        		}
        	} else {
        		this.emprCb = cb;
        	}
        	if (this.emprCb) {
                if(dojoConfig.bibloto.appParams.trombinoscope_enabled && dojoConfig.bibloto.appParams.trombinoscope_auth == 1) {
                    this.createLoginPopup();
                    return;
                }
        		var infosEmprPromise = dojoConfig.bibloto.jsonRpcServer.pmbesEmpr_fetch_empr(this.emprCb, null, null);
        		infosEmprPromise.addCallback(lang.hitch(this, this.setEmprInfos));
        	}
        },
        testExtAuth : function() {
            if (dojoConfig.bibloto.appParams.force_ext_auth == 1) {
				var extAuth = dojoConfig.bibloto.jsonRpcServer.pmbesOPACEmpr_checkExternalAuthentication();
				extAuth.addCallback(lang.hitch(this, this.checkExtAuth));
            } else {
                this.createLoginPopup();
            }
        },
        checkExtAuth : function(response) {
			if (response.ext_auth) {
				this.extAuth = true;
				this.loginExtAuth();
			}
		},
		loginExtAuth : function() {
			let src = dojoConfig.bibloto.appParams.opac_url + 'auth.php?action=check_auth&new_tab=1';
    		window.open(src, "_blank");
		},
		logoutExtAuth : function() {
			let src = dojoConfig.bibloto.appParams.opac_url + 'index.php?logout=1';
    		var logoutWindow = window.open(src, "_blank");
    		var duration = 3000;
    		if (parseInt(dojoConfig.bibloto.appParams.logout_tab_ttl)) {
				duration = parseInt(dojoConfig.bibloto.appParams.logout_tab_ttl) * 1000;
			}
    		setTimeout(()=>{
  				logoutWindow.close();
  				document.location.reload();
			}, duration);
		},
        createLoginPopup : function() {  		
            let iframeContainer = domConstruct.create("div", {
                id: 'auth_popup',
                class: 'iframe-login'
            });
            domConstruct.place(iframeContainer, 'mainContainer');

            let iframe = domConstruct.create("iframe", {
                src: dojoConfig.bibloto.appParams.opac_url + 'auth.php?action=get_form',
                id: 'auth_popup_iframe',
            });
            domConstruct.place(iframe, 'auth_popup');

            let buttonDiv = domConstruct.create('div', {
                id: 'close_button'
            });
            domConstruct.place(buttonDiv, 'auth_popup');

            new Button({
                label: "x",
                onClick: lang.hitch(this, this.closeIframe),
                class : "iframe-login-close",
            }, buttonDiv).startup();

        },
        closeIframe : function(e) {
            registry.byId("close_button").destroy();
            var frame = dom.byId('auth_popup');
            if(frame !== null) {
                frame.parentNode.removeChild(frame);
            }
        },
        checkIframeAuth : function(idEmprSession) {
            var infosEmprPromise = dojoConfig.bibloto.jsonRpcServer.pmbesEmpr_fetch_empr(null, idEmprSession, null);
            infosEmprPromise.addCallback(lang.hitch(this, this.setEmprInfosFromId));
        },
        /** si l'emprunteur existe, affectation des données reçues + publication d'un evenement data userLoaded **/
        setEmprInfos : function(response) {
            if (response.status == true) {
                this.emprInfos = response.data;
                topic.publish('readerDatas', 'datasUserLoaded');
                this.initTimer();
            } else {
                this.mode = 3;
                new warningMessage('enableFetchEmpr', response.status_msg, 'Erreur');
                //alert(response.status_msg);
            }
        },
        setEmprInfosFromId : function(response) {
            if (response.status == true) {
                if(response.data && response.data.empr_cb && (response.data.empr_cb == this.emprCb || this.extAuth))  {
                    this.emprInfos = response.data;
                    if (this.extAuth && (response.data.empr_cb != this.emprCb)) {
						this.emprCb = response.data.empr_cb;
					}
                    topic.publish('readerDatas', 'datasUserLoaded');
                    this.initTimer();
                } else {
                    xhr(dojoConfig.bibloto.appParams.opac_url + "auth.php?action=logout");
                    this.closeIframe(null);
                    new warningMessage('enableFetchEmpr', dojoConfig.bibloto.appParams.msg_trombinoscope_auth_error, 'Erreur');
                }
            } else {
                this.mode = 3;
                new warningMessage('enableFetchEmpr', response.status_msg, 'Erreur');
                //alert(response.status_msg);
            }
        },

        /**
         * Appel de la méthode du webservice retournant les infos de l'exemplaire
         * @param {Object} expl
         */
        callExplInfos : function(expl) {
            this.reInitTimer();
            this.mode = 3;
            var emprExplInfos = dojoConfig.bibloto.jsonRpcServer.pmbesItems_fetch_item_info(expl, null, null);
            emprExplInfos.addCallback(lang.hitch(this, function(response) {
                //console.debug('response infos expl', response);
                this.mode = 2;
                topic.publish('readerDatas', 'gotExplInfos', {
                    response : response
                });

            }));
        },

        /**
         * Initialisation du timer
         */
        initTimer : function() {
            this.reInitTimer();
            this.mousemoveEvent = on(document.body, 'mousemove', lang.hitch(this, function() {
                this.reInitTimer();
            }));
            this.keypressEvent = on(document.body, 'keypress', lang.hitch(this, function() {
                this.reInitTimer();
            }));
        },
        /**
         * Réinitialisation du timer
         */
        reInitTimer : function() {
            if (this.timer) {
                clearTimeout(this.timer);
            }
            this.timer = setTimeout(lang.hitch(this, function() {
                //console.log('erase published');
                topic.publish('actionZone', 'erase');
            }), (parseInt(dojoConfig.bibloto.appParams.timeout_disconnect) * 1000));
        },

        /**
         * Suppression du timer (au retour à l'écran de login')
         */
        eraseTimer : function() {
            this.mousemoveEvent.remove();
            this.keypressEvent.remove();
            clearTimeout(this.timer);
            this.timer = null;
        },

        /** requete json rpc pour envoyer le mail des prêts**/
        sendMailPret : function() {
            var emprMailPromise = dojoConfig.bibloto.jsonRpcServer.pmbesEmpr_send_mail_pret_info_to_empr(this.emprCb);
            emprMailPromise.addCallback(lang.hitch(this, function(response) {
            	new warningMessage('sendMailPret_ok', response.status_msg, 'Information');
            }));

        },

        /** requete json rpc pour prolonger un prêt**/
        prolonge : function(expl) {
            var emprPromise = dojoConfig.bibloto.jsonRpcServer.pmbesSelfServices_self_renew(expl, null, 1);
            emprPromise.addCallback(lang.hitch(this, function(response) {
            	document.getElementById('loan_back_date' + response.cb).parentNode.parentNode.style.display = "none";

                var textnode = document.createTextNode(response.due_date);
            	document.getElementById('loan_back_date' + response.cb).parentNode.parentNode.parentNode.appendChild(textnode);
            	new warningMessage('prolongePret_ok', response.message, 'Information');
            }));
        },

    });
});
