// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: reader.js,v 1.28 2016/11/24 14:57:47 mbertin Exp $

define(["dojo/_base/declare", "dojo/topic", "dojo/_base/lang", "app/warningMessage"], function(declare, topic, lang, warningMessage) {
    return declare(null, {
        func : null,
        lastVal : '',
        rfid_proxy_loaded : 0,
        rfid_driver_loaded : 0,
        rfid_read_started : 0,
        constructor : function() {
            init_rfid_antivol_all_flag = 0;
            init_rfid_antivol_all_cpt = 0;
            topic.subscribe('init', lang.hitch(this, this.handleEvents));
            topic.subscribe('warningMessage', lang.hitch(this, this.handleEvents));
        },
        handleEvents : function(evtType, evtArgs) {

            //console.log('evt received in reader', evtType, evtArgs);
            switch (evtType) {
            case 'rfid_proxy_loaded' :
                this.rfid_proxy_loaded = 1;
                break;
            case 'rfid_driver_loaded' :
                this.rfid_driver_loaded = 1;
                break;
            case 'warningMessage_rfid_antivol_error' :
                init_rfid_antivol_all_cpt++;
                init_rfid_antivol_all_flag = 1;
                break;
            }
            if (this.rfid_read_started == 0 && dojoConfig.bibloto.appParams.rfid_activate == 1 && this.rfid_proxy_loaded == 1 && this.rfid_driver_loaded == 1) {
                this.func = setTimeout(init_rfid_read_cb(lang.hitch(this, this.funcEmpr), lang.hitch(this, this.funcExpl)), 0);
                this.rfid_read_started = 1;
            }
            /**
             * A voir plus tard ?
             */
            //setTimeout("f_disconnect();",10000);
        },
        /**
         * Fonction appelée à la détection d'un exemplaire
         * @param {Object} cb Code barre
         * @param {Object} index
         * @param {Object} indexcount nb index
         * @param {Object} antivol etat de l'antivol
         */
        funcExpl : function(cb, index, indexcount, antivol) {
            if (init_rfid_antivol_all_cpt > 0 && cb.length == 0) {
                init_rfid_antivol_all_flag = 0;
                init_rfid_antivol_all_cpt = 0;
            }
            if (init_rfid_antivol_all_flag == 1) {
                setTimeout(init_rfid_antivol_all(init_rfid_antivol_all_level, this.funcAntivolAck), 0);
                return;
            }
            
            if (dojoConfig.bibloto.appParams.rfid_activate_expl != 1)
                return;
            if (cb.length > 1) {
				var test_cb;
				test_cb=cb[0];
				for (var i=0; i<cb.length; i++) {
					if(test_cb != cb[i]){
						dojoConfig.bibloto.appParams.rfid_lastVal = "";
						topic.publish('reader_rfid', 'rfid_toomanyExpl', {
						    cb : ''
						});
						return;
					  
					}
				}
            }
            if (dojoConfig.bibloto.appParams.rfid_lastVal == keyboard_cb_enter && keyboard_cb_enter) {
                return;
            }

            if (cb.length) {
                if (dojoConfig.bibloto.appParams.rfid_lastVal == cb[0]) {
                    return;
                }
            } else {
                if (dojoConfig.bibloto.appParams.rfid_lastVal == "") {
                    return;
                }
            }
            if (!cb.length && dojoConfig.bibloto.appParams.rfid_lastVal) {
                if (dojoConfig.bibloto.appParams.rfid_lastVal == keyboard_cb_enter) {
                    dojoConfig.bibloto.appParams.rfid_lastVal = "";
                    return;
                }
                topic.publish('reader_rfid', 'rfid_noexpl', {
                    cb : dojoConfig.bibloto.appParams.rfid_lastVal
                });
                dojoConfig.bibloto.appParams.rfid_lastVal = "";
                return;
            }
            topic.publish('reader_rfid', 'rfid_expl', {
                cb : cb,
                index : index,
                indexcount : indexcount,
                antivol : antivol
            });
            if (cb.length)
                dojoConfig.bibloto.appParams.rfid_lastVal = cb[0];
            else
                dojoConfig.bibloto.appParams.rfid_lastVal = "";
            keyboard_cb_enter = "";
        },
        /**
         * Fonction appelée à la détection d'un code barre carte utilisateur
         * @param {Object} cb Code barre
         */
        funcEmpr : function(cb) {
            if (dojoConfig.bibloto.appParams.rfid_activate_empr != 1)
                return;
            if (cb == '')
                return;

            if (cb.length > 1) {
                topic.publish('reader_rfid', 'rfid_toomanyExpl', {
                    cb : ''
                });
                return;
            }
            //console.log("read empr: "+cb);
            topic.publish('reader_rfid', 'rfid_empr', {
                cb : cb
            });
        },

        funcAntivolAck : function(datas) {
            init_rfid_antivol_all_flag = 0;
            topic.publish('reader_rfid', 'rfid_remove_standby');
            if (datas == 1) {
        		
                init_rfid_antivol_all_cpt = 0;
                // ok
            } else {
                if (init_rfid_antivol_all_cpt == 0) {
                    new warningMessage('warningMessage_rfid_antivol_error', dojoConfig.bibloto.appParams.msg_dialog_antivol_error, 'Erreur');
                }
            }
        },
    });
});
