// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: loanActionContainer.js,v 1.7 2019/06/27 13:46:26 ngantier Exp $

define(["dojo/_base/declare", "dojox/grid/DataGrid", "dojo/topic", "dojo/_base/lang", "dojo/dom-construct", "dijit/registry", "dojo/store/Memory", "dojo/data/ObjectStore", "dijit/registry"], function(declare, DataGrid, topic, lang, domConstruct, registry, Memory, ObjectStore, registry) {
    return declare(null, {
        dataGrid : null,
        loanStore : null,
        datasLoan : null,
        //readingEnabled : true,
        constructor : function() {
            /**
             * Création du store de l'action prêt
             * Instanciation du datagrid
             *
             */
            this.datasLoan = new Array();
            this.loanStore = new ObjectStore({
                objectStore : new Memory({
                    data : this.datasLoan
                })
            });
            this.dataGrid = new DataGrid({
                store : this.loanStore,
                autoHeight : true,
                escapeHTMLInData: false,
                query : {
                    id : "*"
                },
                structure : [{
                    name : dojoConfig.bibloto.appParams.msg_expl_title,
                    field : "title",
                    editable : false,
                    width : "50%"
                }, {
                    name : dojoConfig.bibloto.appParams.msg_expl_date_checkout,
                    field : "loan_date",
                    editable : false,
                    width : "15%"
                }, {
                    name : dojoConfig.bibloto.appParams.msg_expl_date_checkin,
                    field : "loan_back_date",
                    editable : false,
                    width : "15%"
                }, {
                    name : dojoConfig.bibloto.appParams.msg_expl_statut,
                    field : "loan_statut",
                    editable : false,
                    width : "15%",
                    formatter : this.formatStatusTick
                }]
            }, domConstruct.create('div', {
                id : 'loanActionDatas',
                style : {
                    height : '300px',
                    width : 'auto'
                }
            }, registry.byId('contentZone').domNode));

            this.dataGrid.startup();
            this.dataGrid.resetDatas = function() {
                this.store.objectStore.data = [];
            };
            topic.subscribe('actionZone', lang.hitch(this, this.handleEvents));
        },
        handleEvents : function(evtType, evtArgs) {             
            switch(evtType) {
            /**
             * pret evt recu
             */
            case 'explLent':
                this.addToStore(evtArgs.response);
                break;
            }
        },

        /**
         * Ajout des données de prêt courant au store
         * @param {Object} datas
         */
        addToStore : function(datas) {
            var newItm = {};
            if (datas.status) {
                newItm.title = datas.icondoc + datas.title;
                newItm.icondoc = datas.icondoc + datas.icondoc,
                newItm.loan_date = this.getCurrDate();
                newItm.loan_back_date = datas.due_date;
                newItm.loan_statut = 1;
            } else {
                newItm.title = datas.title;
                newItm.loan_date = "";
                newItm.icondoc = "",
                newItm.loan_back_date = "";
                newItm.loan_statut = 0;
            }

            this.loanStore.newItem(newItm);
            this.loanStore.save();

        },

        /**
         * Récuperation de la date courante en JS
         */
        getCurrDate : function() {
            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth() + 1;

            var yyyy = today.getFullYear();
            if (dd < 10) {
                dd = '0' + dd;
            }
            if (mm < 10) {
                mm = '0' + mm;
            }
            return dd + '/' + mm + '/' + yyyy;
        },
        formatStatusTick : function(value) {
            if (parseInt(value) == 0) {
                return "<i class='fa fa-ban'></i>";
            } else {
                return "<i class='fa fa-check'></i>";
            }

        },
    });
});
