// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: init.js,v 1.22 2019/06/10 12:36:05 ngantier Exp $

define(['dojo/_base/declare', 'dojo/_base/lang','dojo/parser', 'dojo/topic', 'app/reader', 'dojo/request/xhr', 'app/buffer', 'app/readerDatas', 'app/keyboard', "dojo/request/iframe", "dojo/request", "app/connector"], function(declare,lang,parser,topic, reader, xhr, buffer, readerDatas, keyboard, iframe, request, connector) {
    /**
     * Différents modes de l'application
     *
     * 0 - En attente d'une carte utilisateur
     * 1 - Mode prêt (en attente de la lecture d'un exemplaire)
     * 2 - Mode retour (en attente de la lecture d'un exemplaire')
     * 3 - Utilisateur identifié (les valeurs scannées / entrées ne sont pas traitées)
     *
     */
    return declare(null, {
        deferred : null,

        constructor : function() {
            var test = new connector();
            topic.subscribe('connector', lang.hitch(this, this.handleEvents));
        },

        handleEvents : function(evtType, evtArgs) {
            switch(evtType) {
            case 'gotUrl':
                this.launch();
                break;
            }
        },

        launch : function() {
            parser.parse().then(function() {
                url_serveur_rfid = dojoConfig.bibloto.appParams.rfid_serveur_url;
                SerialPort = "";
                LibraryCode = dojoConfig.bibloto.appParams.rfid_library_code;
                rfid_afi_security_active = dojoConfig.bibloto.appParams.rfid_afi_security_code_on;
                rfid_afi_security_off = dojoConfig.bibloto.appParams.rfid_afi_security_code_off;

                dojoConfig.bibloto.buffer = new buffer();
                dojoConfig.bibloto.readerDatas = new readerDatas();

                var element = document.createElement('link');
                element.href = dojoConfig.bibloto.appParams.style_url;
                element.rel = 'stylesheet';
                element.type = 'text/css';
                document.body.appendChild(element);

                if (dojoConfig.bibloto.appParams.css) {
	                var sheet = document.createElement('style');
	                sheet.innerHTML = dojoConfig.bibloto.appParams.css;
	                document.body.appendChild(sheet);
                }
                                
                var element = document.createElement('script');
                element.type = 'text/javascript';
                element.onload = function() {
                    topic.publish('init', 'rfid_proxy_loaded');
                };
                element.src = './rfid/' + dojoConfig.bibloto.appParams.rfid_driver + '/proxy.js';
                document.body.appendChild(element);

                var element = document.createElement('script');
                element.type = 'text/javascript';
                element.onload = function() {
                    topic.publish('init', 'rfid_driver_loaded');
                };
                element.src = './rfid/' + dojoConfig.bibloto.appParams.rfid_driver + '/driver.js';
                document.body.appendChild(element);
                dojoConfig.bibloto.appParams.rfid_lastVal = "";
                keyboard_cb_enter = '';
                new reader();                
            });
        },
    });
});
