// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: infoReader.js,v 1.15 2024/04/03 07:24:10 qvarin Exp $

define([
    'dojo/_base/declare',
    'dijit/_Widget',
    'dojo/topic',
    'dojo/_base/lang',
    "dojo/dom-construct",
    'app/warningMessage'
],
function(declare, widget, topic, lang, domConstruct, warningMessage) {
    return declare(widget, {
        contentNode : null,
        paramsReader : null,
        userCb : null,
        buildRendering : function() {
            this.inherited(arguments);
        },

        /**
         * Fonction appelée après l'instanciation du widget
         */
        postCreate : function() {
            this.domNode.style.height = "auto";
            this.own(topic.subscribe("readerDatas", lang.hitch(this, this.handleEvents)));
            this.contentNode = domConstruct.create('div', {
                id : 'readerInfosContent',
                class : 'readerInfosContent',
                style : {
                    height : '200px'
                },
            }, this.domNode);
        },

        /**
         * On capte ici l'évenement "datasUserLoaded" provenant de la classe readerData
         */
        handleEvents : function(evtType, evtArgs) {
            switch (evtType) {
                case 'datasUserLoaded' :
                    this.constructReaderInfos();
                    break;
            }
        },


        /**
         * Création du contenu de la div présentant les infos lecteurs, et del a div elle même
         */
        constructReaderInfos : function() {

            domConstruct.empty(this.contentNode);

            let tpl = dojoConfig.bibloto.appParams.empr_tpl;
            tpl = tpl.replace("${nom}", dojoConfig.bibloto.readerDatas.emprInfos.nom);
            tpl = tpl.replace("${prenom}", dojoConfig.bibloto.readerDatas.emprInfos.prenom);
            tpl = tpl.replace("${empr_cb}", dojoConfig.bibloto.readerDatas.emprInfos.empr_cb);
            tpl = tpl.replace("${birth}", dojoConfig.bibloto.readerDatas.emprInfos.birth);
            tpl = tpl.replace("${adr1}", dojoConfig.bibloto.readerDatas.emprInfos.adr1);
            tpl = tpl.replace("${adr2}", dojoConfig.bibloto.readerDatas.emprInfos.adr2);
            tpl = tpl.replace("${cp}", dojoConfig.bibloto.readerDatas.emprInfos.cp);
            tpl = tpl.replace("${ville}", dojoConfig.bibloto.readerDatas.emprInfos.ville);
            tpl = tpl.replace("${mail}", dojoConfig.bibloto.readerDatas.emprInfos.mail);
            tpl = tpl.replace("${tel1}", dojoConfig.bibloto.readerDatas.emprInfos.tel1);
            tpl = tpl.replace("${tel2}", dojoConfig.bibloto.readerDatas.emprInfos.tel2);
            tpl = tpl.replace("${prof}", dojoConfig.bibloto.readerDatas.emprInfos.prof);
            tpl = tpl.replace("${cat_l}", dojoConfig.bibloto.readerDatas.emprInfos.cat_l);
            tpl = tpl.replace("${date_adhesion}", dojoConfig.bibloto.readerDatas.emprInfos.date_adhesion);
            tpl = tpl.replace("${date_expiration}", dojoConfig.bibloto.readerDatas.emprInfos.date_expiration);
            tpl = tpl.replace("${location_l}", dojoConfig.bibloto.readerDatas.emprInfos.location_l);
            tpl = tpl.replace("${statut_libelle}", dojoConfig.bibloto.readerDatas.emprInfos.statut_libelle);
            tpl = tpl.replace("${msg}", dojoConfig.bibloto.readerDatas.emprInfos.msg);

            if (dojoConfig.bibloto.readerDatas.emprInfos.adhesion_depassee == 1) {
                this.throwWarning('warnMembershipDateExpired', dojoConfig.bibloto.readerDatas.emprInfos.adhesion_msg, 'Erreur');
            }
            if (dojoConfig.bibloto.readerDatas.emprInfos.adhesion_renouv_proche == 1) {
                this.throwWarning('warnMembershipExpiresSoon.', dojoConfig.bibloto.readerDatas.emprInfos.adhesion_msg, 'Erreur');
            }

            domConstruct.create('div', {
                id : 'firstname',
                innerHTML : tpl
            }, this.contentNode);

            topic.publish('infoReader', 'infosLoaded');
        },

        throwWarning : function(code, msg, title) {
            try {
                new warningMessage(code, msg, title);
            } catch (err) {
                console.error(err);
            }
        }
    });
});
