// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: contentZone.js,v 1.18 2025/05/22 12:26:22 tsamson Exp $

define(["dojo/_base/declare", "dojo/topic", "dojo/_base/lang", "app/loanContainer", "dijit/layout/ContentPane", "app/resaContainer", "dijit/registry", "dojo/dom", 'app/backContainer', 'app/loanActionContainer'], function(declare, topic, lang, loanContainer, widget, resaContainer, registry, dom, backContainer, loanActionContainer) {
    return declare(widget, {
        emprCb : null,
        emprInfos : null,
        loanContainer : null,
        resaContainer : null,
        constructor : function() {
            /** Abonnement aux évenements provenants des classes "readerDatas" et "actionZone" **/
            this.own(topic.subscribe("readerDatas", lang.hitch(this, this.handleEvents)), topic.subscribe("actionZone", lang.hitch(this, this.handleEvents)));
        },
        handleEvents : function(evtType, evtArgs) {
            //console.debug('evt received in contentZone', evtType, evtArgs);
            switch(evtType) {
            /** datasUserLoaded: evenement envoyé par la classe renderDatas lorsque les données d'un utilisateur son récupérées **/
            case 'datasUserLoaded':
                //this.eraseContent(); // parade pour le probleme de reinit du store de prêt loanStore. on recharge la page entre 2 emprunteur
                this.instanciateContent();
                break;
            /** erase: evenement envoyé par la classe actionZone lorsqu'un appui sur le bouton retour à la page d'acceuil est effectué **/
            case 'actionZoneErased' :
                this.eraseContent();
                break;
            }
        },
        /**
         * Instanciation du "loanContainer" et du "resaContainer" en fonction du paramétrage
         */
        instanciateContent : function() {
            
            if (parseInt(dojoConfig.bibloto.appParams.checkin_activate)) {
                this.backContainer = new backContainer();
                dom.byId('backDatas').style.display = 'none';
            }
            if (parseInt(dojoConfig.bibloto.appParams.resa_activate)) {
                this.resaContainer = new resaContainer();
                dom.byId('resaDatas').style.display = 'none';
            }

           if (parseInt(dojoConfig.bibloto.appParams.checkout_activate) || parseInt(dojoConfig.bibloto.appParams.checkin_activate)) {
                this.loanContainer = new loanContainer();
                this.loanActionContainer = new loanActionContainer();
                dom.byId('loanActionDatas').style.display = 'none';
           }

			var elem = document.getElementById('visible_input');
			if(elem) {
				elem.setAttribute('id', 'visible_input_off');
			}

            topic.publish('contentZone', 'contentReady');
        },
        /** Suppression des instances, en fonction du paramétrage également **/
        eraseContent : function() {
			// le reload se fera plus tard en cas de connexion externe
			if ("undefined" == typeof dojoConfig.bibloto.appParams.force_ext_auth || dojoConfig.bibloto.appParams.force_ext_auth == 0) {
				document.location.reload();// parade pour le probleme de reinit du store de prêt loanStore
			}
			return;
            if (parseInt(dojoConfig.bibloto.appParams.checkin_activate)) {
                registry.byId('backDatas').destroy();
                this.backContainer = null;
            }
            if (parseInt(dojoConfig.bibloto.appParams.resa_activate)) {
                registry.byId('resaDatas').destroy();
                this.resaContainer = null;
            }
            if (parseInt(dojoConfig.bibloto.appParams.checkout_activate)) {
                registry.byId('loanDatas').destroy();
                this.loanContainer = null;
                registry.byId('loanActionDatas').destroy();
                this.loanActionDatas = null;
            }
        }
    });
});
