// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: buffer.js,v 1.8 2015/06/12 15:02:09 vtouchard Exp $

define(["dojo/_base/declare", "dojo/topic", "dojo/_base/lang"], function(declare, topic, lang) {
    return declare(null, {
        elts : null,
        readingEnabled : true,
        constructor : function() {
            this.elts = new Array();
            topic.subscribe('readerDatas', lang.hitch(this, this.handleEvents));
        },
        handleEvents : function(evtType, evtArgs) {
          // console.log('evt received in buffer', evtType, evtArgs);
            switch(evtType) {
            /**
             * Suppression du contenu du buffer
             */
            case 'resetBuffer':
                /** FIFO **/
                this.elts = new Array();
                break;
            /**
             * Activation de la lecture
             */
            case 'enableReading':
                this.enable();
                break;
            }
        },
        addElt : function(elt) {
            if (this.readingEnabled) {
                this.elts.push(elt[0]);
                topic.publish('buffer', 'eltAdded', {
                    elt : elt[0]
                });
                
            }
        },
        enable : function() {
            this.readingEnabled = true;
        },
        disable : function() {
            this.readingEnabled = false;
        }
    });
});
