// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: backContainer.js,v 1.10 2019/06/27 13:46:26 ngantier Exp $

define(["dojo/_base/declare", "dojox/grid/DataGrid", "dojo/topic", "dojo/_base/lang", "dojo/dom-construct", "dijit/registry", "dojo/store/Memory", "dojo/data/ObjectStore", "dijit/registry"], function(declare, DataGrid, topic, lang, domConstruct, registry, Memory, ObjectStore, registry) {
    return declare(null, {
        backGrid : null,
        backStore : null,
        constructor : function() {
            /**
             * Création du store de retour
             * Instanciation du datagrid
             *
             */
            this.backStore = new ObjectStore({
                objectStore : new Memory({
                    data : this.datasBack
                })
            });
            this.backGrid = new DataGrid({
                store : this.backStore,
                autoHeight : true,
                escapeHTMLInData: false,
                query : {
                    id : "*"
                },
                structure : [{
                    name : dojoConfig.bibloto.appParams.msg_expl_title,
                    field : "title",
                    editable : false,
                    width : "40%"
                }, {
                    name : dojoConfig.bibloto.appParams.msg_expl_date_checkin,
                    field : "loan_back_date",
                    editable : false,
                    width : "25%"
                }, {
                    name : dojoConfig.bibloto.appParams.msg_expl_rendu,
                    field : "loan_back_ok",
                    editable : false,
                    width : "30%",
                    formatter : this.formatStatusTick
                }]
            }, domConstruct.create('div', {
                id : 'backDatas',
                style : {
                    height : '300px',
                    width : 'auto'
                }
            }, registry.byId('contentZone').domNode));

            this.backGrid.startup();
            this.backGrid.resetDatas = function() {
                this.store.objectStore.data = [];
            };

            /** Abonnement aux évenements de la classe ActionZone **/
            topic.subscribe('actionZone', lang.hitch(this, this.handleEvents));
        },

        /**
         * Permet dans la case statut du datagrid, d'afficher soit une croix rouge, soit une tick verte
         */
        formatStatusTick : function(value) {
            if (parseInt(value) == 0) {
                return "<i class='fa fa-ban'></i>";
            } else {
                return "<i class='fa fa-check'></i>";
            }

        },

        /**
         * Lorsqu'un livre est rendu "explBack" est capté, on ajoute le livre au container
         */
        handleEvents : function(evtType, evtArgs) {
            switch(evtType) {
            case 'explBack':
                this.addToStore(evtArgs.response);
                break;
            }
        },
        /** Ajout de l'exemplaire retourné dans le datagrid **/
        addToStore : function(datas) {
            status = 0;
            if (datas.status) {
                status = 1;
            }
            var newItm = {
                title : datas.icondoc + datas.title,
                icondoc : datas.icondoc,
                loan_back_date : this.getCurrDate(),
                loan_back_ok : status
            };
            this.backStore.newItem(newItm);
            this.backStore.save();
        },

        /** Récuperation de la date courante **/
        getCurrDate : function() {
            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth() + 1;

            var yyyy = today.getFullYear();
            if (dd < 10) {
                dd = '0' + dd;
            }
            if (mm < 10) {
                mm = '0' + mm;
            }
            return dd + '/' + mm + '/' + yyyy;
        },
    });
});
