// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: alertZone.js,v 1.1 2022/05/02 09:25:20 rtigero Exp $

define([
	'dojo/_base/declare',
	'dijit/_Widget',
	'dojo/_base/lang',
	'dijit/form/Button',
	"dojo/dom-construct",
	"dojo/topic"
], function(declare, widget, lang, Button, domConstruct, topic) {
	return declare(widget, {

    	callback_success: null,
    	callback_failed: null,
		display: false,
		containerDiv: null,
		labelContainerDiv: null,
		buttonDiv: null,
		yesBTN: null,
		noBTN: null,

		postCreate: function() {
			
			if (this.display) {
				this.show();
			} else {
				this.hidden();				
			}
			
			this.own(topic.subscribe("alertZone", lang.hitch(this, this.handleEvents)));
			
			this.containerDiv = domConstruct.create('div', {
				id: 'alertZoneContainer',
				class: 'alertZoneContainer',
			}, this.domNode);
			this.labelContainerDiv = domConstruct.create('div', {
				id: 'labelContainerDiv',
				class: 'labelContainerDiv',
			}, this.containerDiv);
			this.label = domConstruct.create('p', {
				class: 'label itemContent',
				innerHTML: dojoConfig.bibloto.appParams.msg_printer_button,
			}, this.labelContainerDiv);
			this.buttonDiv = domConstruct.create('div', {
				id: 'contentButtonAlert',
				class: 'contentButtonAlert',
			}, this.containerDiv);
			this.initButtons();
		},
		
		
        handleEvents : function(evtType, callback_success, callback_failed) {
            switch (evtType) {
	            case 'showPopup':
	            	this.callback_success = callback_success;
	            	this.callback_failed = callback_failed;
	            	this.show();
	                break;
	                
	            case 'hiddenPopup':
	            	this.callback_success = null;
	            	this.callback_failed = null;
	            	this.hidden();
	                break;
            }
        },

		initLabel: function() {
			domConstruct.create('p', { innerHTML: "test" }, this.labelDiv);
		},
		
		show: function() {
			this.display = true;
			this.srcNodeRef.style = ""; 
		},

		hidden: function() {
			this.display = false;
			this.srcNodeRef.style = "display:none;";			
		},
		
		success: function() {
			if (this.callback_success) {				
				this.callback_success();
			}
        	this.hidden();
		},

		failed: function() {
			if (this.callback_failed) {
				this.callback_failed();	
			}
        	this.hidden();
		},

		initButtons: function() {
			this.yesBTN = new Button({
				label: dojoConfig.bibloto.appParams.msg_bibloto_yes,
				onClick: lang.hitch(this, this.success),
			}, domConstruct.create('div', {}, this.buttonDiv)).startup();

			this.noBTN = new Button({
				label: dojoConfig.bibloto.appParams.msg_bibloto_no,
				onClick: lang.hitch(this, this.failed),
			}, domConstruct.create('div', {}, this.buttonDiv)).startup();
		},
	});
});
