// +-------------------------------------------------+
// � 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: HomePageGallery.js,v 1.1 2018/10/19 13:49:59 vtouchard Exp $

define([
	'dojo/_base/declare', 
	'dijit/_Widget', 
	'dojo/topic', 
	'dojo/_base/lang', 
	'dijit/registry',
	'dojo/dom-construct',
	'dojo/dom-attr',
	'dojo/dom-style',
	'app/HomePageGalleryKeyboard',
	'app/HomePageGalleryView',], function(declare, widget, topic, lang, registry, domConstruct, domAttr, domStyle, HomePageGalleryKeyboard, HomePageGalleryView) {
    return declare([widget], {
        homepageTitle : "",
        homepageLogo : "",
        homepageContent : "",
        keyboard: null,       
        buildRendering : function() {
            /**
             * Les attributs homepageTitle et homepageContent sont utilisés pour alimenter le template ./templates/helloWidget.html
             */
            this.inherited(arguments);
//            console.log('HomePageGallery:', this);
        },
        postCreate : function() {
            /** Abonnement aux évenements provenants des classes "infosReader", et "actionZone" **/
//            this.own(topic.subscribe("infoReader", lang.hitch(this, this.handleEvents)), topic.subscribe("actionZone", lang.hitch(this, this.handleEvents)));
        
        	/**
        	 * TODO: 
        	 * -Créer un champ de recherche
        	 * -Créer le clavier 
        	 * -Créer une classe affichant les images des lecteurs
        	 * -Gérer la recherche
        	 */
        	domStyle.set(this.domNode, 'height', '100%');
        	domStyle.set(this.domNode, 'width', '100%');
        	
        	this.galleryContainer = domConstruct.create('div', {
        		id:'gallery-container', 
        		'class':'gallery-container',
        	}, this.domNode);

        	this.gallery = new HomePageGalleryView({id: 'gallery-container', domNode: this.galleryContainer});
        	
        	this.keyboardContainer = domConstruct.create('div', {
        		id:'keyboard-container', 
        		'class':'keyboard-container',
        		innerHTML: ''
        	}, this.domNode);
        
        	this.keyboard = new HomePageGalleryKeyboard({id:'keyboard-container', domNode: this.keyboardContainer});
        	this.own(topic.subscribe("infoReader", lang.hitch(this, this.handleEvents)), topic.subscribe("actionZone", lang.hitch(this, this.handleEvents)));
        },
        
        /**
         * Fonction handleEvents:
         * Prend en paramètres deux arguments
         * evtType -> Nom de l'event
         * evtArgs -> contenu de l'event
         */
        handleEvents : function(evtType, evtArgs) {
//             console.log('evt received in HomePageGallery', evtType, evtArgs);
            switch (evtType) {
            /** infosLoaded: Évenement envoyé par la classe infoReader lorsqu'elle a construit le template associé **/
            case 'infosLoaded':
//                this.hide();
                this.cleanChildrens();
                topic.publish('HomePageGallery', 'homepageHidden');
                break;
            /** erase: Évenement envoyé par la classe actionZone lors d'un appui sur le bouton retourner à la page d'accueil **/
            case 'erase':
//                this.show();
                topic.publish('HomePageGallery', 'homepageDisplayed');
                this.gallery.show();
                this.keyboard.show();
                break;
            }
        },
        cleanChildrens: function(){
        	this.keyboard.clear();
        	this.gallery.clear();
        },
        show: function(){
        	
        }
    });
});
