// +-------------------------------------------------+
// � 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: HomePageCode.js,v 1.1 2018/10/19 13:49:59 vtouchard Exp $

define([
	'dojo/_base/declare', 
	'dijit/_Widget', 
	'dijit/_TemplatedMixin', 
	'dojo/text!./templates/homePageCode.html', 
	'dojo/topic', 
	'dojo/_base/lang', 
	'dijit/registry',
	'dojo/dom-style'], function(declare, widget, _TemplatedMixin, template, topic, lang, registry, domStyle) {
    return declare([widget, _TemplatedMixin], {
        templateString : template,
        homepageTitle : "",
        homepageLogo : "",
        homepageContent : "",
        buildRendering : function() {
            /**
             * Les attributs homepageTitle et homepageContent sont utilisés pour alimenter le template ./templates/helloWidget.html
             */
            if (dojoConfig.bibloto.appParams.home_tpl){
            	this.templateString = dojoConfig.bibloto.appParams.home_tpl;
            }
            this.inherited(arguments);
        },
        postCreate : function() {
            /** Abonnement aux évenements provenants des classes "infosReader", et "actionZone" **/
            this.own(topic.subscribe("infoReader", lang.hitch(this, this.handleEvents)), topic.subscribe("actionZone", lang.hitch(this, this.handleEvents)));
        },

        /**
         * Fonction handleEvents:
         * Prend en paramètres deux arguments
         * evtType -> Nom de l'event
         * evtArgs -> contenu de l'event
         */
        handleEvents : function(evtType, evtArgs) {
//             console.log('evt received in hellowidget', evtType, evtArgs);
            switch (evtType) {
            /** infosLoaded: Évenement envoyé par la classe infoReader lorsqu'elle a construit le template associé **/
            case 'infosLoaded':
                this.hide();
                topic.publish('HomePageCode', 'homepageHidden');
                break;
            /** erase: Évenement envoyé par la classe actionZone lors d'un appui sur le bouton retourner à la page d'accueil **/
            case 'erase':
                this.show();
                topic.publish('HomePageCode', 'homepageDisplayed');
                break;
            }
        },
        /** Affichage de la page d'accueil **/
        show : function() {
            dojoConfig.bibloto.appParams.rfid_lastVal = "";
            if (this.domNode.parentNode.style.display == "none") {
            	this.domNode.parentNode.style.display = "block";
            	this.domNode.parentNode.style.height = "100%";
                registry.byId('mainContainer').resize();
            }
        },
        /** Masquage de la page d'accueil **/
        hide : function() {
            dojoConfig.bibloto.appParams.rfid_lastVal = "";
            if (this.domNode.parentNode.style.display != "none") {
            	this.domNode.parentNode.style.display = "none";
            	this.domNode.parentNode.style.height = "0px";
                registry.byId('mainContainer').resize();
                
            }
        }
    });
});
