<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: selector_searcher_record.class.php,v 1.1.2.6 2025/11/28 15:59:14 dbellamy Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

//Classe de recherche pour selecteurs
global $class_path;
require_once("$class_path/sel_searcher.class.php");

class selector_searcher_record extends sel_searcher {

    public $cur_typ_query='notice';
    public $has_filters = true;

    public $filter_caddies_format = 'authority';

    protected function _get_niveau_biblio() {
        return 'm';
    }

    protected function _get_filters_query() {
        global $notice_statut_query, $doctype_query, $caddies_query;

        $restrict = "niveau_biblio='".$this->_get_niveau_biblio()."' ";
        if ($notice_statut_query !='-1') {
            $restrict.= "and statut='".addslashes($notice_statut_query)."' ";
        }

        if ($doctype_query !='-1') {
            $restrict.= "and typdoc='".addslashes($doctype_query)."' ";
        }
        if (!empty($caddies_query) && is_array($caddies_query)) {
            $ids = [];
            foreach ($caddies_query as $caddie_query) {
                if ($this->filter_caddies_format == 'authority') {
                    $caddie_id = intval($caddie_query['id']);
                } else {
                    $caddie_id = intval($caddie_query);
                }
                if ($caddie_id) {
                    $ids[] = $caddie_id;
                }
            }
            if (!empty($ids)) {
                $restrict .= "and notice_id IN(SELECT object_id FROM caddie_content WHERE caddie_id IN (".implode(',', $ids)."))";
            }
        }
        return $restrict;
    }

    public function make_first_search() {
        global $msg;
        global $elt_query;
        global $results_show_all;

        $restrict = $this->_get_filters_query();
        $suite_rqt="or code='".$elt_query."' ";
        $isbn_verif=traite_code_isbn(stripslashes($elt_query));
        if (isISBN($isbn_verif)) {
            $suite_rqt.="or code='".formatISBN($isbn_verif,13)."' ";
            $suite_rqt.="or code='".formatISBN($isbn_verif,10)."' ";

            $q_count = "select count(*) from notices where ".$restrict." and (0 ".$suite_rqt.")";
            $r_count = pmb_mysql_query($q_count);
            $n_count = pmb_mysql_result($r_count,0,0);
            $this->nbresults = $n_count;

            $q_list = "select notice_id from notices where ".$restrict." and (0 ".$suite_rqt.")";
            if(!$results_show_all){
                $q_list .= $this->get_query_limit();
            }
            $r_list = pmb_mysql_query($q_list);
            $this->t_query=$r_list;
            if(!$results_show_all){
                $this->nbepage=ceil($this->nbresults/$this->get_nb_per_page());
            }else{
                $this->nbepage=1;
            }
        }else{
            $aq=new analyse_query(stripslashes($elt_query));
            if ($aq->error) {
                $this->show_form();
                error_message($msg["searcher_syntax_error"],sprintf($msg["searcher_syntax_error_desc"],$aq->current_car,$aq->input_html,$aq->error_message));
                return ;
            } else {
                $q_members = $aq->get_query_members("notices","index_wew","index_sew","notice_id");

                $q_count = "select count(*) from notices where ".$restrict." and (".$q_members["where"]." ".$suite_rqt.")";
                $r_count = pmb_mysql_query($q_count);
                $n_count = pmb_mysql_result($r_count,0,0);
                $this->nbresults = $n_count;

                $q_list = "select notice_id, ".$q_members['select']." as pert from notices where ".$restrict." and (".$q_members["where"]." ".$suite_rqt.") ".$q_members['post'];
                if(!$results_show_all){
                    $q_list.= $this->get_query_limit();
                }
                $r_list = pmb_mysql_query($q_list);
                $this->t_query=$r_list;
                if(!$results_show_all){
                    $this->nbepage=ceil($this->nbresults/$this->get_nb_per_page());
                }else{
                    $this->nbepage=1;
                }
            }
        }
        return ELT_LIST;
    }

    public function store_search() {
        global $elt_query;
        global $notice_statut_query, $doctype_query, $caddies_query;
        global $charset;

        $champs="<input type='hidden' name='elt_query' value='".htmlentities(stripslashes($elt_query),ENT_QUOTES,$charset)."'/>";
        $champs.="<input type='hidden' name='notice_statut_query' value='".htmlentities(stripslashes($notice_statut_query),ENT_QUOTES,$charset)."'/>";
        $champs.="<input type='hidden' name='doctype_query' value='".htmlentities(stripslashes($doctype_query),ENT_QUOTES,$charset)."'/>";
        if (!empty($caddies_query) && is_array($caddies_query)) {
            if ($this->filter_caddies_format == 'authority') {
                foreach ($caddies_query as $caddie_indice=>$caddie_query) {
                    $champs.="<input type='hidden' name='caddies_query[".$caddie_indice."][id]' value='".htmlentities(stripslashes($caddie_query['id']),ENT_QUOTES,$charset)."'/>";
                    $champs.="<input type='hidden' name='caddies_query[".$caddie_indice."][label]' value='".htmlentities(stripslashes($caddie_query['label']),ENT_QUOTES,$charset)."'/>";
                }
            } else {
                foreach ($caddies_query as $caddie_indice=>$caddie_query) {
                    $champs.="<input type='hidden' name='caddies_query[".$caddie_indice."]' value='".htmlentities(stripslashes($caddie_query),ENT_QUOTES,$charset)."'/>";
                }
            }
        }
        $this->store_form=str_replace("!!first_search_variables!!",$champs,$this->store_form);
        print $this->store_form;
    }

    public function get_title_elt_list() {
        global $msg;

        return $msg['selector_lib_noti'];
    }

    public function get_instance_sel_display($row) {
        return new selector_display_record($row->notice_id,$this->base_url,'sel_searcher_select_');
    }

    /**
     * extension de la recherche
     * {@inheritDoc}
     * @see sel_searcher::get_extended_search_form()
     */
    public function get_extended_search_form() {
        global $msg;
        global $notice_statut_query;
        global $doctype_query;
        global $caddies_query, $PMBuserid;

        //statut
        $query ="select distinct id_notice_statut, gestion_libelle from notice_statut order by 2 " ;
        if (!isset($notice_statut_query)) {
            $notice_statut_query = -1;
        }
        $notice_statut_form = gen_liste($query, 'id_notice_statut', 'gestion_libelle', 'notice_statut_query', '', $notice_statut_query, '', '', '-1', $msg['tous_statuts_notice'] , 0);
        $extended_search_form = $this->get_extended_search_filter_form('notice_statut_query', $msg['statut'], $notice_statut_form);
        //type document
        if (!isset($doctype_query)) {
            $doctype_query = -1;
        }
        $doctype_form = new marc_select('doctype', 'doctype_query', $doctype_query, '',  '-1', $msg['tous_types_docs']);
        $extended_search_form .= $this->get_extended_search_filter_form('doctype_query', $msg['type_doc_sort'], $doctype_form->display);

        //Paniers
        if ($this->filter_caddies_format == 'authority') {
            $elements = array();
            if(!empty($caddies_query)) {
                foreach ($caddies_query as $caddie_query) {
                    if ($caddie_query['id']) {
                        $elements[] = array(
                            'id' => $caddie_query['id'],
                            'name' => $caddie_query['label']
                        );
                    }
                }
            }
            templates::init_completion_attributes(array(
                array('name' => 'param1', 'value' => 'caddies_ui'),
                array('name' => 'param2', 'value' => 'caddies_NOTI')
            ));
            templates::init_selection_attributes(array(
                array('name' => 'param1', 'value' => 'caddies_query_id'),
                array('name' => 'param2', 'value' => 'caddies_query'),
                array('name' => 'objects_type', 'value' => 'caddies_ui'),
                array('name' => 'filter_name', 'value' => 'caddies_NOTI')
            ));
            $notice_caddies_form = templates::get_display_elements_completion_field($elements, 'caddies', "caddies_query", "caddies_query_id", 'list_ui');
        } else {
            $query = "SELECT idcaddie AS id, name AS label, caddie_classement FROM caddie WHERE type='NOTI' and (autorisations like '$PMBuserid %' or autorisations like '% $PMBuserid' or autorisations like '% $PMBuserid %' or autorisations like '$PMBuserid' or autorisations_all=1) ORDER BY label";
            $notice_caddies_form = gen_liste($query, 'id', 'label', 'caddies_query[]', '', $caddies_query, '', $msg['398'], '', '' , 1, '', 'caddie_classement');
        }
        $extended_search_form .= $this->get_extended_search_filter_form('caddies_query', $msg['search_by_panier'], $notice_caddies_form);
        $extended_search_form .= parent::get_extended_search_form();
        return $extended_search_form;
    }

    public function get_title_column_number() {
        global $msg;

        return $msg['acquisition_nb_expl'];
    }
}