<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_item_datasource_item.class.php,v 1.4 2022/01/18 21:02:38 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path;
require_once($class_path."/docwatch/docwatch_item.class.php");

class cms_module_item_datasource_item extends cms_module_common_datasource{
	
	public function __construct($id=0){
		parent::__construct($id);
	}
	
	/*
	 * On dfini les slecteurs utilisable pour cette source de donne
	*/
	public function get_available_selectors(){
		return array(
				"cms_module_item_selector_item_generic"
		);
	}
			
	/*
	 * Rcupration des donnes de la source...
	 */
	public function get_datas(){
		//on commence par rcuprer l'identifiant retourn par le slecteur...
		$selector = $this->get_selected_selector();
		if($selector){
			$item_id = $selector->get_value();
			if ($item_id) {
				$docwatch_item = new docwatch_item($item_id);
				return $docwatch_item->get_normalized_item();
			}
		}
		return false;
	}
	
	public function get_format_data_structure(){
		return $this->prefix_var_tree(docwatch_item::get_format_data_structure(),"item");
	}
}