<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_common_datasource_animations_by_cp_val.class.php,v 1.2.2.1.6.2 2025/08/01 08:14:08 tgoureau Exp $
if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
	die("no access");
}

class cms_module_common_datasource_animations_by_cp_val extends cms_module_common_datasource_animations_list
{

	public function __construct($id = 0)
	{
		parent::__construct($id);
		$this->limitable = true;
		$this->paging = true;
	}

	/*
	 * On dfini les slecteurs utilisable pour cette source de donne
	 */
	public function get_available_selectors()
	{
		return array(
			"cms_module_common_selector_animation_cp_val"
		);
	}

	/*
	 * Sauvegarde du formulaire, revient  remplir la proprit parameters et appeler la mthode parente...
	 */
	public function save_form()
	{
		global $selector_choice;

		$this->parameters = array();
		$this->parameters['selector'] = $selector_choice;
		return parent::save_form();
	}

	protected function getDefaultJoin()
	{
		return [
			'JOIN anim_animation_custom_values ON anim_animation_custom_values.anim_animation_custom_origine=anim_animations.id_animation'
		];
	}

	protected function getDefaultClause()
	{
		$selector = $this->get_selected_selector();

		$custom_champ = 0;
		if (! empty($selector) && $selector->get_value()) {
			$data = $selector->get_value();
			$custom_champ = intval($data['cp']);
		}

		return [
			'anim_animation_custom_champ = ' . intval($custom_champ)
		];
	}

	/*
	 * Rcupration des donnes de la source...
	 */
	public function get_datas()
	{
		$selector = $this->get_selected_selector();
		if (empty($selector) && !$selector->get_value()) {
			return false;
		}

		$query = $this->buildQuery();
		if (empty($query)) {
			return false;
		}

		$animations = [];
		$result = pmb_mysql_query($query);
		if (pmb_mysql_num_rows($result)) {

			$parameters = $selector->get_value();
			$parameters['cp'] = intval($parameters['cp']);

			$pperso = new parametres_perso("anim_animation");
			while ($row = pmb_mysql_fetch_assoc($result)) {

				$found = false;
				$pperso->get_values($row['id_animation']);
				foreach ($parameters['cp_val'] as $value) {
					if (in_array($value, $pperso->values[$parameters['cp']])) {
						$found = true;
						break;
					}
				}

				if ($found) {
					$animations[] = $row['id_animation'];
				}
			}
			pmb_mysql_free_result($result);
			$animations = $this->filter_datas('animations', $animations);
		}

		if (!is_countable($animations) || !count($animations)) {
			return false;
		}

		$data = $this->sort_animations($animations);
		$data['title'] = '';

		if (is_array($data['animations']) && !empty($data['animations'])) {
			// Pagination
			if ($this->paging && isset($this->parameters['paging_activate']) && $this->parameters['paging_activate'] == "on") {
				$data['paging'] = $this->inject_paginator($data['animations']);
				$data['animations'] = $this->cut_paging_list($data['animations'], $data['paging']);
			} elseif ($this->parameters["nb_max_elements"] > 0) {
				$data['animations'] = array_slice($data['animations'], 0, $this->parameters["nb_max_elements"]);
			}
		}

		return $data;
	}
}
