<?php
// +-------------------------------------------------+
//  2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ajax_main.inc.php,v 1.10.8.1.2.1.2.1 2025/09/23 14:38:35 gneveu Exp $

if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) {
    die("no access");
}

switch($categ) {
    case "document" :
        //Mise en cache des images
        //on ajoute des enttes qui autorisent le navigateur  faire du cache...
        $headers = getallheaders();
        //une journe
        $offset = 60 * 60 * 24 ;
        if (isset($headers['If-Modified-Since']) && (strtotime($headers['If-Modified-Since']) <= time())) {
            header('Last-Modified: '.$headers['If-Modified-Since'], true, 304);
            return;
        } else {
            header('Expired: '.gmdate("D, d M Y H:i:s", time() + $offset).' GMT', true);
            header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT', true, 200);
        }
        $doc = new cms_document($id);
        switch($action) {
            case "thumbnail":
                $doc->render_thumbnail();
                break;

            case "render":
                global $mode;

                if ($doc->get_num_storage()) {
                    generate_log('ajax_cms_document_render', [], true);
                    session_write_close();
                    $doc->render_doc($mode);
                }
                break;

            default:
                http_response_code(404);
                break;
        }
        break;
    case "module" :
        if (strpos($elem, "cms_module_") === false) {
            http_response_code(404);
            break;
        }
        switch($action) {
            case "ajax":
                $element = new $elem($id);
                $response = $element->execute_ajax();
                ajax_http_send_response($response['content'], $response['content-type']);
                break;

            case "css":
            case "js":
                session_write_close();
                $element = new $elem($id);
                $response = $element->execute_ajax();
                ajax_http_send_response($response['content'], $response['content-type']);
                break;

            default:
                http_response_code(404);
                break;
        }
        break;
    case "build" :
        switch($action) {
            case "set_version":
                $query = "SELECT id_version  FROM cms_version WHERE id_version = " . intval($value);
                $result = pmb_mysql_query($query);
                if (pmb_mysql_num_rows($result) > 0) {
                    $row = pmb_mysql_fetch_row($result);
                    $_SESSION["build_id_version"] = intval($row[0]);
                    ajax_http_send_response("ok ". htmlentities($_SESSION["build_id_version"], ENT_QUOTES));
                } else {
                    ajax_http_send_response("ko no id version");
                }
                break;
            default:
                http_response_code(404);
                break;
        }
        break;

    default:
        http_response_code(404);
        break;

}
