<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: custom_fields_query_auth.class.php,v 1.2.4.3.4.4 2025/12/12 13:02:46 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class custom_fields_query_auth extends custom_fields {
	
    protected static $type = 'query_auth';
    
    protected static function has_chk_mandatory() {
        return true;
    }
    
    protected static function get_chk_values($name) {
        global ${$name};
        $val=array();
        $tmp_values=${$name};
        if(is_array($tmp_values)) {
            foreach ($tmp_values as $v) {
                if ($v!="") {
                    $val[]=$v;
                }
            }
        }
        return $val;
    }
    
    public static function val($field, $value) {
        global $pmb_perso_sep,$charset;
        
        $isbd_s=array();
        $isbd_without=array();
        $details=array();
        if(!$value) {
            return "";
        }
        
        foreach($value as $id){
            if($id) {
                $isbd = get_authority_isbd_from_field($field, $id);
                $isbd_s[] = htmlentities($isbd, ENT_QUOTES, $charset);
                $isbd_without[] = $isbd;
                $details[] = get_authority_details_from_field($field, $id);
            }
        }
        return array("ishtml" => true, "value"=>implode($pmb_perso_sep,$isbd_s), "withoutHTML" =>implode($pmb_perso_sep,$isbd_without), "details" => $details);
    }
    
    protected static function get_id_thes_unique($options) {
        return (isset($options["ID_THES"]["0"]["value"]) ? $options["ID_THES"]["0"]["value"] : '');
    }
    
    protected static function get_att_id_filter($options) {
        switch($options["DATA_TYPE"]["0"]["value"]) {
            case 2: //categories
                return static::get_id_thes_unique($options);
            case 9:
                return "http://www.w3.org/2004/02/skos/core#Concept";
        }
        return '';
    }
    
    protected static function get_concept_schemes($options) {
        $concept_schemes = [];
        switch($options["DATA_TYPE"]["0"]["value"]) {
            case 9: // concepts
                if (isset($options['ID_SCHEME_CONCEP']) && is_countable($options['ID_SCHEME_CONCEP'])) {
                    for($i=0 ; $i<count($options['ID_SCHEME_CONCEP']) ; $i++){
                        $concept_schemes[] = $options['ID_SCHEME_CONCEP'][$i]['value'];
                    }
                }
                break;
        }
        return $concept_schemes;
    }
    
    protected static function get_attribute_completion($field) {
        $options=$field['OPTIONS'][0];
        $selection_parameters = get_authority_selection_parameters($options["DATA_TYPE"]["0"]["value"]);
        return $selection_parameters['completion'];
    }
    
    protected static function get_js_functions_repeatable($field) {
        global $base_path;
        
        $caller = get_form_name();
        
        $options=$field['OPTIONS'][0];
        $id_thes_unique = static::get_id_thes_unique($options);
        $att_id_filter = static::get_att_id_filter($options);
        $selection_parameters = get_authority_selection_parameters($options["DATA_TYPE"]["0"]["value"]);
        $what = $selection_parameters['what'];
        $completion = $selection_parameters['completion'];
        $concept_schemes = static::get_concept_schemes($options);
        
        $readonly='';
        
        $ret = "<script>
		function fonction_selecteur_".$field["NAME"]."() {
			name=this.getAttribute('id').substring(4);
			name_id = name;
			openPopUp('".$base_path."/select.php?what=$what&caller=$caller&p1='+name_id+'&p2=f_'+name_id+'&perso_id=".$field["ID"]."&custom_prefixe=".$field["PREFIX"]."&perso_name=".$field['NAME']."&id_thes_unique=".urlencode($id_thes_unique)."', 'selector');
		}
		function fonction_raz_".$field["NAME"]."() {
			name=this.getAttribute('id').substring(4);
			document.getElementById(name).value='';
			document.getElementById('f_'+name).value='';
		}
		function add_".$field["NAME"]."() {
			suffixe = eval('document.$caller.n_".$field["NAME"].".value');
			    
			var node_dnd_id = get_custom_dnd_on_add('div_".$field["NAME"]."', 'customfield_query_auth_".$field["NAME"]."', suffixe);
			    
			var nom_id = '".$field["NAME"]."_'+suffixe;
			var f_perso = document.createElement('input');
			f_perso.setAttribute('name','f_".$field["NAME"]."[]');
			f_perso.setAttribute('id','f_'+nom_id);
			f_perso.setAttribute('data-form-name','f_'+nom_id);
			f_perso.setAttribute('completion','".$completion."');
			f_perso.setAttribute('att_id_filter','".$att_id_filter."');
			f_perso.setAttribute('persofield','".$field["NAME"]."');
			f_perso.setAttribute('autfield',nom_id);";
        
        if (count($concept_schemes) && $concept_schemes[0] != -1 && ($what == "ontology")) {
            $ret.= "
			f_perso.setAttribute('param1','".implode(',',$concept_schemes)."');";
        }
        $ret.= "
			f_perso.setAttribute('type','text');
			f_perso.className='saisie-50emr';
			$readonly
			f_perso.setAttribute('value','');
			
			var del_f_perso = document.createElement('input');
			del_f_perso.setAttribute('id','del_".$field["NAME"]."_'+suffixe);
			del_f_perso.onclick=fonction_raz_".$field["NAME"].";
			del_f_perso.setAttribute('type','button');
			del_f_perso.className='bouton';
			del_f_perso.setAttribute('readonly','');
			del_f_perso.setAttribute('value','X');
			    
			var f_perso_id = document.createElement('input');
			f_perso_id.name='".$field["NAME"]."[]';
			f_perso_id.setAttribute('type','hidden');
			f_perso_id.setAttribute('id',nom_id);
			f_perso_id.setAttribute('value','');
			    
			var perso = document.getElementById(node_dnd_id);
			perso.appendChild(f_perso);
			perso.appendChild(document.createTextNode(' '));
			perso.appendChild(document.createTextNode(' '));
			perso.appendChild(del_f_perso);
			perso.appendChild(f_perso_id);
			
			document.$caller.n_".$field["NAME"].".value=suffixe*1+1*1 ;
			ajax_pack_element(document.getElementById('f_'+nom_id));
		}
		</script>
		";
        return $ret;
    }
    
    protected static function get_event_button_add($field) {
        return 'add_'.$field["NAME"].'();';
    }
    
    public static function get_display_value($field, $indice, $value) {
        global $charset;
        
        $display = "";
        $options = $field['OPTIONS'][0];
        $selection_parameters = get_authority_selection_parameters($options["DATA_TYPE"]["0"]["value"]);
        $completion = $selection_parameters['completion'];
        $att_id_filter = static::get_att_id_filter($options);
        $params = "";
        $isbd="";
        if ($value) {
            $isbd=get_authority_isbd_from_field($field, $value);
        }
        $display .= "<input type='text' att_id_filter='".$att_id_filter."' ".$params." completion='".$completion."' autfield='".$field["NAME"]."_$indice' class='saisie-50emr' id='f_".$field["NAME"]."_$indice' persofield='".$field["NAME"]."' autfield='".$field["NAME"]."_$indice' name='f_".$field["NAME"]."[]' data-form-name='f_".$field["NAME"]."_' value=\"".htmlentities($isbd,ENT_QUOTES,$charset)."\" />\n";
        $display .= "<input type='hidden' id='".$field["NAME"]."_$indice' name='".$field["NAME"]."[]' data-form-name='".$field["NAME"]."_' value=\"".htmlentities($value,ENT_QUOTES,$charset)."\">";
        $display .= static::get_button_raz($field, "this.form.f_".$field["NAME"]."_$indice.value=''; this.form.".$field["NAME"]."_$indice.value='';")."\n";
        return $display;
    }
    
    public static function get_display_values($field) {
        global $base_path;
        
        $options = $field['OPTIONS'][0];
        $display = "";
        $values = static::get_aff_values($field);

        $selection_parameters = get_authority_selection_parameters($options["DATA_TYPE"]["0"]["value"]);
        $what = $selection_parameters['what'];
        $concept_schemes = static::get_concept_schemes($options);
        $id_thes_unique = static::get_id_thes_unique($options);
        $element = "";
        $val_dyn=3;
        $no_display = "";
        switch($options["DATA_TYPE"]["0"]["value"]) {
            case 9:
                $element="&element=concept&param1=".$field["NAME"]."&param2=f_".$field["NAME"];
                if(isset($concept_schemes[0]) && $concept_schemes[0] != -1){
                    //concept_scheme;
                    $element.="&return_concept_id=1&unique_scheme=1&concept_scheme=".implode(',',$concept_schemes);
                }
                break;
            default:
                if($options["DATA_TYPE"]["0"]["value"]>1000){
                    // autperso
                    $element="&param1=".$field["NAME"]."&param2=f_".$field["NAME"];
                    $val_dyn=4;
                }
                break;
        }
        $caller = get_form_name();
        $n=count($values);
        for ($i=0; $i<$n; $i++) {
            if (!isset($values[$i])) {
                $values[$i] = '';
            }
            if ($i==0) {
                if ($options['MULTIPLE'][0]['value']=="yes") {
                    $display .= get_js_function_dnd('query_auth', $field['NAME']);
                    $browse_link = $base_path."/select.php?what=$what&caller=$caller&p1=".$field["NAME"]."_$i&p2=f_".$field["NAME"]."_$i&perso_id=".$field["ID"]."&custom_prefixe=".$field["PREFIX"]."&dyn=$val_dyn&perso_name=".$field['NAME'];
                    $browse_link .= "&max_field=n_".$field["NAME"]."&field_id=".$field["NAME"]."_&field_name_id=f_".$field["NAME"]."_&add_field=add_".$field["NAME"]."&id_thes_unique=".urlencode($id_thes_unique).$element. $no_display;
                    $display .= static::get_button_browse($field, $browse_link);
                    $display .= static::get_button_add($field);
                }else {
                    $browse_link = $base_path."/select.php?what=$what&caller=$caller&p1=".$field["NAME"]."_$i&p2=f_".$field["NAME"]."_$i&perso_id=".$field["ID"]."&custom_prefixe=".$field["PREFIX"]."&dyn=$val_dyn&perso_name=".$field['NAME'];
                    $browse_link .= "&max_field=n_".$field["NAME"]."&field_id=".$field["NAME"]."_0&field_name_id=f_".$field["NAME"]."_0&add_field=add_".$field["NAME"]."&id_thes_unique=".urlencode($id_thes_unique).$element. $no_display;
                    $display .= static::get_button_browse($field, $browse_link);
                }
            }
            $display_temp = static::get_display_value($field, $i, $values[$i]);
            $button_add = '';
            if ($options['MULTIPLE'][0]['value']=="yes") {
                $isbd = '';
                if ($values[$i]) {
                    $isbd=get_authority_isbd_from_field($field, $values[$i]);
                }
                $display .= static::get_block_dnd($field, $i, $display_temp.$button_add, $isbd);
            } else {
                $display .= $display_temp."<br />";
            }
        }
        return $display;
    }
    
    public static function aff($field, &$check_scripts) {
        global $ajax_js_already_included;
        
        $options = $field['OPTIONS'][0];
        $values = static::get_aff_values($field);
        
        $ret = "";
        if(empty($ajax_js_already_included)){
            $ajax_js_already_included = true;
            $ret.="<script src='./includes/javascript/ajax.js'></script>";
        }
        if ($options['MULTIPLE'][0]['value']=="yes") {
            $ret .= get_custom_dnd_on_add();
            $ret .= static::get_js_functions_repeatable($field);
        }
        $n=count($values);
        $ret .= "<input type='hidden' value='$n' name='n_".$field["NAME"]."' />";
        $ret .= "<div id='div_".$field["NAME"]."'>";
        $ret .= static::get_display_values($field);
        $ret.="</div>";
        return $ret;
    }
    
    public static function aff_search($field,&$check_scripts,$varname) {
        global $msg,$charset;
        global $_custom_prefixe_, $caller;
        global $ajax_js_already_included;
        global $base_path;
        
        $options = $field['OPTIONS'][0];
        if(!empty($field['NUMBER'])) {
            $field_name = $field['NAME']."_".$field['NUMBER'];
        } else {
            $field_name = $field['NAME'];
        }
        if($options["METHOD"]["0"]["value"]==1) {
            $hidden_name=$field_name;
        } else {
            $hidden_name=$field_name."_id";
        }
        $id=(isset($field['VALUES'][0]) ? $field['VALUES'][0] : '');
        
        $selection_parameters = get_authority_selection_parameters($options["DATA_TYPE"]["0"]["value"]);
        $what = $selection_parameters['what'];
        $completion = $selection_parameters['completion'];
        
        $params = "";
        $fnamevar_id = '';
        $id_thesaurus = '';
        $id_thes_unique = static::get_id_thes_unique($options);
        $att_id_filter = static::get_att_id_filter($options);
        $concept_schemes = static::get_concept_schemes($options);
        $element="";
        switch($options["DATA_TYPE"]["0"]["value"]) {
            case 2:
                //Pour n'appeler que le thsaurus choisi en champ perso
                if(isset($options["ID_THES"]["0"]["value"])){
                    $fnamevar_id = "linkfield=\"fieldvar_".substr($varname, 6)."_id_thesaurus\"";
                    $id_thesaurus="<input  type='hidden' id='fieldvar_".substr($varname, 6)."_id_thesaurus' name='fieldvar_".substr($varname, 6)."_id_thesaurus' value='".$options["ID_THES"]["0"]["value"]."'>";
                }
                break;//categories
            case 9:
                $element="&element=concept&param1=".$field_name."&param2=f_".$field_name;
                if(!empty($concept_schemes[0]) && $concept_schemes[0] != -1){
                    //concept_scheme;
                    $params = " param1='".implode(',',$concept_schemes)."'";
                    $element.="&return_concept_id=1&unique_scheme=1&concept_scheme=".implode(',',$concept_schemes);
                }
                break;
        }
        $libelle="";
        if($id){
            $libelle = get_authority_isbd_from_field($field, $id);
        }
        
        $ret = "";
        if(empty($ajax_js_already_included)){
            $ajax_js_already_included = true;
            $ret = "<script src='./includes/javascript/ajax.js'></script>";
        }
        
        $val_dyn=3;
        $ret.="<input type='text'  att_id_filter='".$att_id_filter."' ".$params." completion='$completion' autfield='".$field_name."'  class='saisie-50emr' id='f_".$field_name."' persofield='".$field["NAME"]."' autfield='".$field_name."' name='f_".$field_name."' data-form-name='f_".$field_name."' $fnamevar_id value=\"".htmlentities($libelle,ENT_QUOTES,$charset)."\" />\n";
        $ret.="<input type='hidden' id='".$field_name."' name='".$varname."[]'  data-form-name='".$field_name."'  value=\"".htmlentities($id,ENT_QUOTES,$charset)."\">";
        
        $ret.="<input type='button' class='bouton' value='...' title='".htmlentities($msg['title_select_from_list'],ENT_QUOTES,$charset)."' onclick=\"openPopUp('".$base_path."/select.php?what=$what&caller=$caller".$element."&p1=".$field_name."_0&p2=f_".$field_name."_0&perso_id=".$field["ID"]."&custom_prefixe=".$_custom_prefixe_."&dyn=$val_dyn&perso_name=".$field['NAME']
        ."&max_field=n_".$field_name."&field_id=".$field_name."&field_name_id=f_".$field_name."&add_field=add_".$field_name.($id_thes_unique?"&id_thes_unique=".$id_thes_unique:"")."', 'select_perso_".$field["ID"]
        ."', 700, 500, -2, -2,'toolbar=no, dependent=yes, resizable=yes, scrollbars=yes')\" />";
        $ret.="<input name='".$hidden_name."' id='".$hidden_name."'  value='".htmlentities($id,ENT_QUOTES,$charset)."' type='hidden'>$id_thesaurus";
        return $ret;
    }
    
    public static function get_rgaa_label($field, $varname) {
        return "f_".$field["NAME"]."_0";
    }
}