<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_common_datasource_animations_by_concepts.class.php,v 1.1.14.2 2025/08/01 08:14:08 tgoureau Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class cms_module_common_datasource_animations_by_concepts extends cms_module_common_datasource_animations_list
{

	public function __construct($id = 0)
	{
		parent::__construct($id);
		$this->sortable = true;
		$this->limitable = true;
	}

	/*
     * On dfini les slecteurs utilisable pour cette source de donne
     */
	public function get_available_selectors()
	{
		return array(
			"cms_module_common_selector_generic_authorities_concepts"
		);
	}

	protected function getDefaultJoin()
	{
		return [
			'JOIN index_concept ON index_concept.num_object=anim_animations.id_animation AND type_object=' . TYPE_ANIMATION
		];
	}

	protected function getDefaultClause()
	{
		$selector = $this->get_selected_selector();

		$values = [];
		if (! empty($selector) && $selector->get_value()) {
			$raw_ids = $selector->get_authorities_raw_ids();
			if (!empty($raw_ids)) {
				$values = $raw_ids;
			}
		}

		return  ['num_concept IN (' . implode(', ', $values) . ')'];
	}

	/*
     * Rcupration des donnes de la source...
     */
	public function get_datas()
	{
		$selector = $this->get_selected_selector();
		if (empty($selector) && !$selector->get_value()) {
			return false;
		}

		$query = $this->buildQuery();
		if (empty($query)) {
			return false;
		}

		$animations = [];
		$result = pmb_mysql_query($query);
		if (pmb_mysql_num_rows($result)) {
			while ($row = pmb_mysql_fetch_assoc($result)) {
				$animations[] = $row['id_animation'];
			}
			pmb_mysql_free_result($result);
			$animations = $this->filter_datas('animations', $animations);
		}

		if (!is_countable($animations) || !count($animations)) {
			return false;
		}

		$data = $this->sort_animations($animations);
		$data['title'] = '';

		return $data;
	}
}
