<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_common_datasource_animations_by_categories.class.php,v 1.1.8.1.6.1 2025/06/27 10:08:20 qvarin Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class cms_module_common_datasource_animations_by_categories extends cms_module_common_datasource_animations_list {

    public function __construct($id = 0) {
        parent::__construct($id);
        $this->sortable = true;
        $this->limitable = true;
    }

    /*
     * On dfinit les slecteurs utilisables pour cette source de donnes
     */
    public function get_available_selectors() {
        return array(
            'cms_module_common_selector_category_permalink',
            'cms_module_common_selector_category',
            'cms_module_common_selector_env_var'
        );
    }


    protected function getDefaultJoin()
    {
        return [
            'JOIN anim_animation_categories ON anim_animation_categories.num_animation=anim_animations.id_animation'
        ];
    }

    protected function getDefaultClause()
    {
        $selector = $this->get_selected_selector();

        $value = 0;
        if (! empty($selector) && $selector->get_value()) {
            $value = intval($selector->get_value());
        }

        return [
            'anim_animation_categories.num_noeud = ' . $value
        ];
    }

    /*
     * Rcupration des donnes de la source
     */
    public function get_datas() {
        $query = $this->buildQuery();
        if (empty($query)) {
            return false;
        }

        $animations = [];
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            while ($row = pmb_mysql_fetch_assoc($result)) {
                $animations[] = intval($row['id_animation']);
            }
            pmb_mysql_free_result($result);
            $animations = $this->filter_datas('animations', $animations);
        }

        if (!is_countable($animations) || !count($animations)) {
            return false;
        }

        $data = $this->sort_animations($animations);
        $data['title'] = '';

        return $data;
    }
}