<?php
/***********************************************************************************************
 Ce fichier fait partie du projet voxilabPHP, implmentation PHP de
 l'API Voxilab (https://github.com/voxilab)

 Cette  implmentation dveloppe par  2013- PMB Services.

 Ce programme est rgi par la licence CeCILL soumise au droit franais et
 respectant les principes de diffusion des logiciels libres. Vous pouvez
 utiliser, modifier et/ou redistribuer ce programme sous les conditions
 de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
 sur le site "http://www.cecill.info".

 En contrepartie de l'accessibilit au code source et des droits de copie,
 de modification et de redistribution accords par cette licence, il n'est
 offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
 seule une responsabilit restreinte pse sur l'auteur du programme,  le
 titulaire des droits patrimoniaux et les concdants successifs.

 A cet gard  l'attention de l'utilisateur est attire sur les risques
 associs au chargement,   l'utilisation,   la modification et/ou au
 dveloppement et  la reproduction du logiciel par l'utilisateur tant
 donn sa spcificit de logiciel libre, qui peut le rendre complexe 
 manipuler et qui le rserve donc  des dveloppeurs et des professionnels
 avertis possdant  des  connaissances  informatiques approfondies.  Les
 utilisateurs sont donc invits  charger  et  tester  l'adquation  du
 logiciel  leurs besoins dans des conditions permettant d'assurer la
 scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
  l'utiliser et l'exploiter dans les mmes conditions de scurit.

 Le fait que vous puissiez accder  cet en-tte signifie que vous avez
 pris connaissance de la licence CeCILL, et que vous en avez accept les
 termes.
 ***********************************************************************************************/

/*
 * Diarization main class
 *
 * $Id: voxilabDiarization.class.php,v 1.1.30.1 2025/08/14 07:51:02 dbellamy Exp $
 */

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

define("VOXILAB_FILE_DOESNT_EXIST", 1);
define("VOXILAB_DIARIZATION_ERROR", 2);

require_once 'voxilabSpeechfile.class.php';

class voxilabDiarization
{
    /**
     * Protocol used
     *
     * @var voxilabProtocol
     */
    private $protocol;

    /**
     *
     * @param  string protocol Protocol to use
     * @param array options Array of options
     *
     * @return void
     */
    public function __construct($protocol, $options)
    {
        $protocolClass = "voxilab" . ucfirst(strtolower($protocol));
        require_once $protocolClass . ".class.php";
        $this->protocol = new $protocolClass($options);
    }

    /**
     * Send a file to the diarization
     *
     * @param string path Path of the file to send to the diarization
     *
     * @return void
     */
    public function sendFile($path)
    {
        if (file_exists($path)) {
            $result = json_decode($this->protocol->postFile($path));

            if ($result->status != "uploaded") {
                throw new Exception("Diarization error !", VOXILAB_DIARIZATION_ERROR);
            }

            $speechfile = new voxilabSpeechfile($result->id, $this);
            return $speechfile;
        }
        throw new Exception("File " . $path . " doesn't exist !", VOXILAB_FILE_DOESNT_EXIST);
    }

    /**
     * Get file with an id
     *
     * @param int id File identifier
     *
     * @return voxilabSpeechfile
     */
    public function getFile($id)
    {
        return new voxilabSpeechfile($id, $this);
    }

    /**
     * Send a command to the protocol
     *
     * @param string command Name of the command to send
     * @return array
     */
    public function sendCommand($id, $command)
    {
        return json_decode($this->protocol->command($id, $command));
    }
}
