<?php
// +-------------------------------------------------+
// | 2002-2007 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: sessions_tokens.class.php,v 1.1.26.1 2025/10/30 13:23:25 rtigero Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class sessions_tokens {

	/**
	 * Type de token (Information sur l'utilisation)
	 * @var string
	 */
	protected $type;

	/**
	 * Token
	 * @var string
	 */
	protected $token;

	/**
	 * SESSID
	 * @var string
	 */
	protected $SESSID;

	/**
	 * Login de l'utilisateur/lecteur de la session
	 * @var string
	 */
	protected $login;

	/**
	 * Timestamp d'expiration de la session
	 * @var timestamp
	 */
	protected $expiration;

	protected $session_type = "opac";

	public function __construct($type, $session_type = "opac") {
		$this->type = $type;
		$this->session_type = $session_type;
		$this->clean_sessions();
	}

	/**
	 * Gnre un token  partir d'une mthode et d'un tableau de paramtre
	 * @param callable $callable Mthode de gnration
	 * @param array $arguments Arguments
	 */
	public function generate_token($callable, $arguments = array()) {
		$this->token = call_user_func_array($callable, $arguments);
		$this->save();
		return $this->token;
	}

	/**
	 * Gnre un token  partir du md5 des arguments transmis concatns
	 * @param array $arguments
	 */
	public function generate_token_from_arguments($arguments) {
		$this->token = md5(implode('', $arguments));
		$this->save();
		return $this->token;
	}

	protected function get_token_from_SESSID() {
		$this->token = '';
		if ($this->SESSID) {
			$query = 'select sessions_tokens_token from sessions_tokens where sessions_tokens_SESSID = "'.$this->SESSID.'" and sessions_tokens_type = "'.$this->type.'"';
			$result = pmb_mysql_query($query);
			if (pmb_mysql_num_rows($result)) {
				$this->token = pmb_mysql_result($result, 0, 0);
			}
		}
	}

	protected function get_SESSID_from_token() {
		$this->SESSID = '';
		if ($this->token) {
			$query = 'select sessions_tokens_SESSID from sessions_tokens where sessions_tokens_token = "'.$this->token.'" and sessions_tokens_type = "'.$this->type.'"';
			$result = pmb_mysql_query($query);
			if (pmb_mysql_num_rows($result)) {
				$this->SESSID = pmb_mysql_result($result, 0, 0);
			}
		}
	}

	/**
	 * Enregistre le token associ  la session
	 */
	public function save() {
		if ($this->SESSID && $this->token) {
			$query = 'insert into sessions_tokens (sessions_tokens_SESSID, sessions_tokens_token, sessions_tokens_type) values ("'.$this->SESSID.'", "'.$this->token.'", "'.$this->type.'")';
			pmb_mysql_query($query);
		}
	}

	public function is_valid() {
		if ($this->get_login()) {
			return true;
		}
		return false;
	}

	protected function get_session_data() {
		global $opac_duration_session_auth;
		$this->login = '';
		$this->expiration = 0;
		$this->get_SESSID();
		if ($this->SESSID) {
			switch ($this->session_type) {
				case "opac":
					$query = 'select login, LastOn from sessions where SESSID = "'.$this->SESSID.'"';
					$result = pmb_mysql_query($query);
					if (pmb_mysql_num_rows($result)) {
						$row = pmb_mysql_fetch_object($result);
						$this->login = $row->login;
						$this->expiration = $row->LastOn + $opac_duration_session_auth;
					}
					break;
				case "webservices":
					$query = "SELECT es_cache_content FROM es_cache_blob WHERE es_cache_objecttype = '".CACHE_TYPE_OPACEMPRSESSION."' AND SUBSTR(es_cache_objectref, 1, 12) = '".$this->SESSID."'";
					$result = pmb_mysql_query($query);
					if (pmb_mysql_num_rows($result)) {
						$row = pmb_mysql_fetch_assoc($result);
						$session_info = unserialize($row['es_cache_content']);
						$id_empr = $session_info['empr_id'];
						//On recupere le login
						$query = 'select empr_login from empr where id_empr = "'.intval($id_empr).'"';
						$result = pmb_mysql_query($query);
						if (pmb_mysql_num_rows($result)) {
							$row = pmb_mysql_fetch_assoc($result);
							$this->login = $row['empr_login'];
						}
						$this->expiration = $session_info['lastused_date'] + 1200;
					}
					break;
			}
		}
	}

	/**
	 * @return string Login de l'utilisateur/ Lecteur associ  la session
	 */
	public function get_login() {
		if (!isset($this->login)) {
			$this->get_session_data();
		}
		return $this->login;
	}

	/**
	 * @return timestamp Timestamp de l'expiration de la session
	 */
	public function get_expiration() {
		if (!isset($this->expiration)) {
			$this->get_session_data();
		}
		return $this->expiration;
	}

    public function get_token() {
    	if (!isset($this->token)) {
	    	$this->get_token_from_SESSID();
    	}
    	return $this->token;
    }

    public function get_SESSID() {
    	if (!isset($this->SESSID)) {
    		$this->get_SESSID_from_token();
    	}
        return $this->SESSID;
    }

    public function get_type() {
        return $this->type;
    }

    public function set_token($token) {
        $this->token = $token;
        return $this;
    }

    public function set_SESSID($SESSID) {
        $this->SESSID = $SESSID;
        return $this;
    }

    /**
     * Nettoie les session OPAC expires
     */
    protected function clean_sessions() {
		global $opac_duration_session_auth;

		// heure courante moins une heure
		$time_out = time() - $opac_duration_session_auth;

		// suppression des sessions inactives OPAC
		$query = 'delete from sessions where LastOn < '.$time_out.' and SESSNAME = "PmbOpac"';
		pmb_mysql_query($query);

		// suppression des sessions inactives webservices
		$es_cache = new external_services_cache('es_cache_blob', 1200);
		$es_cache->delete_expired();

		// Suppression des tokens lis  des sessions supprimes
		$sql = "SELECT SESSID FROM sessions UNION SELECT SUBSTR(es_cache_objectref, 1, 12) FROM es_cache_blob WHERE es_cache_objecttype = '".CACHE_TYPE_OPACEMPRSESSION."'";
		$query = 'delete from sessions_tokens where sessions_tokens_SESSID not in ('.$sql.')';
		pmb_mysql_query($query);
    }
}