<?php
use Pmb\Common\Library\Navbar\Navbar;

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: sel_searcher.class.php,v 1.18.8.2.4.5 2025/11/28 15:59:14 dbellamy Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

//Classe de recherche pour selecteurs
global $base_path, $class_path, $msg;
require_once("$class_path/analyse_query.class.php");
require_once("$class_path/sel_display.class.php");
require_once("$base_path/selectors/templates/sel_searcher_templates.tpl.php");

//Classe gnrique de recherche
if(!defined('AUT_LIST')) define("AUT_LIST",1);
if(!defined('ELT_LIST'))define("ELT_LIST",2);
if(!defined('AUT_SEARCH'))define("AUT_SEARCH",3);

$tab_query=array();
$tab_query['notice']=$msg['selector_lib_noti'];
$tab_query['bulletin']=$msg['selector_lib_bull'];
$tab_query['article']=$msg['selector_lib_art'];
$tab_query['abt']=$msg['selector_lib_abt'];
$tab_query['frais']=$msg['selector_lib_frais'];
$tab_query['panier']=$msg['selector_lib_caddie'];
$tab_query['sug']=$msg['selector_lib_sug'];

$tab_autorun=array();
$tab_autorun['notice']=false;
$tab_autorun['bulletin']=false;
$tab_autorun['article']=false;
$tab_autorun['abt']=true;
$tab_autorun['frais']=false;
$tab_autorun['panier']=false;
$tab_autorun['sug']=false;

class sel_searcher {

    public $etat;								//Etat de la recherche
    public $page;								//Page courante de la recherche
    public $nbresults;							//Nombre de rsultats de la dernire recherche
    public $nbepage;
    public $aut_id;							//Numro d'autorit pour la recherche
    public $aut_type;							//Type d'autorit pour la recherche
    public $store_form;						//Formulaire contenant les infos de navigation plus des champs pour la recherche
    public $first_search_result;
    public $direct = 0;

    //Elements obligatoires
    public $base_url = '';						//url de base pour les menus,
    public $tab_choice=array();				//Liste des choix a effectuer dans le menu
    public $cur_typ_query;

    public $elt_f_list = '';					//Formulaire d'affichage des elements
    public $elt_b_list = '';					//Affichage Debut de liste elements
    public $elt_e_list = '';					//Affichage Fin de liste elements
    public $elt_r_list = '';					//Affichage ligne element
    public $elt_r_list_values = array();		//tableau des elements a afficher dans la liste
    public $action = '';						//Action a transmettre pour retour des parametres
    public $action_values = array();			//tableau des elements  modifier dans l'action
    public $back_script = '';					//Script a executer sur selection d'un element
    public $back_script_show_all = '';			//Script a executer sur bouton "Afficher tous les rsultats"
    public $back_script_order = '';			//Script a executer pour trier certains elements

    public $aut_b_list = '';					//Affichage Debut de liste autorites
    public $aut_e_list = '';					//Affichage Fin de liste autorites
    public $aut_r_list = '';					//Affichage ligne autorite
    public $aut_r_list_values = array();		//tableau des autorites a afficher dans la liste

    public $has_filters = false;

    public $t_query;

    //Constructeur
    public function __construct($base_url) {
        global $etat,$aut_type,$aut_id,$page;

        $this->base_url = $base_url;
        $this->etat = $etat;
        $this->aut_type = $aut_type;
        $this->aut_id = $aut_id;
        $this->page = intval($page);

        //$this->run();
    }

    public function run() {
        $this->set_menu();
        if (!$this->etat) {
            $this->show_form();
        } else {
            switch ($this->etat) {
                case "first_search":
                    $r=$this->make_first_search();
                    $this->first_search_result=$r;
                    switch ($r) {
                        case AUT_SEARCH:
                            $this->etat="aut_search";
                            $this->direct=1;
                            $this->make_aut_search();
                            $this->make_store_form();
                            $this->aut_store_search();
                            $this->aut_elt_list();
                            $this->pager();
                            break;
                        case AUT_LIST:
                            $this->make_store_form();
                            $this->store_search();
                            $this->aut_list();
                            $this->pager();
                            break;
                        case ELT_LIST:
                            $this->make_store_form();
                            $this->store_search();
                            $this->elt_list();
                            $this->pager();
                            break;
                    }
                    break;
                case "aut_search":
                    $this->make_aut_search();
                    $this->make_store_form();
                    $this->aut_store_search();
                    $this->aut_elt_list();
                    $this->pager();
                    break;
            }
        }
    }


    public function set_menu() {
        global $charset;
        global $form_query, $nav_bar, $other_query;
        global $tab_query,$tab_autorun;

        $menu_query = $nav_bar;
        foreach($this->tab_choice as $typ_query) {
            if (array_key_exists($typ_query, $tab_query)) {
                $menu_query = str_replace('<!-- other_query -->', $other_query.'<!-- other_query -->', $menu_query);
                $menu_query = str_replace('!!typ_query!!', $typ_query.($tab_autorun[$typ_query]==true?"&autorun=1":""), $menu_query);
                $menu_query = str_replace('!!lib!!', htmlentities($tab_query[$typ_query], ENT_QUOTES, $charset),  $menu_query);
                if ($typ_query==$this->cur_typ_query) {
                    $menu_query = str_replace('!!class!!', "class='sel_navbar_current'",  $menu_query);
                } else {
                    $menu_query = str_replace('!!class!!', '',  $menu_query);
                }
            }
        }
        $form_query = str_replace('!!menu_query!!', $menu_query, $form_query);
    }

    public function get_extended_search_filter_form($id, $label, $content) {
        global $charset;

        return "
        <div class='row'>
            <div class='colonne3'>
                <label for='".$id."'>".htmlentities($label, ENT_QUOTES, $charset)."
            </div>
            <div class='colonne_suite'>
                ".$content."
            </div>
        </div>";
    }

    public function get_extended_search_form() {
        return "<input type='hidden' name='results_show_all' id='results_show_all' value='0'>";
    }

    public function show_form() {
        global $msg, $charset;
        global $form_query, $elt_query;

        $extended_search_form = $this->get_extended_search_form();
        if ($this->has_filters) {
            $extended_search_form = "
            <fieldset>
                <legend>".$msg['filters']."</legend>
                ".$extended_search_form."
            </fieldset>";
        }
        $form_query = str_replace("!!elt_query!!", htmlentities(stripslashes($elt_query ?? ''),ENT_QUOTES, $charset), $form_query);
        $form_query = str_replace("<!-- extended_query -->", $extended_search_form, $form_query );
        $form_query = str_replace("!!action_url!!", $this->base_url."&typ_query=".$this->cur_typ_query, $form_query);
        print $form_query;
    }

    public function get_nb_per_page() {
        global $nb_per_page, $nb_per_page_select;

        if (!$nb_per_page) {
            $nb_per_page=$nb_per_page_select;
        }
        return $nb_per_page;
    }

    public function get_start_page() {
        if(empty($this->page)) {
            $this->page = 1;
        }
        return ($this->page-1)*$this->get_nb_per_page();
    }

    public function get_query_limit() {
        return " limit ".$this->get_start_page().", ".$this->get_nb_per_page()." ";
    }

    public function pager() {
        global $msg;

        if (!$this->nbresults) {
            return;
        }
        if (!$this->page) {
            $current_page = 1;
        } else {
            $current_page = $this->page;
        }
        $navbar = new Navbar($current_page, $this->nbresults, $this->get_nb_per_page());
        $navbar->setHiddenFormName('store_search');
        print "<div id='results_pager' class='center'>".$navbar->render()."</div>";
    }

    protected function get_button_show_all() {
        global $msg, $charset;
        global $results_show_all;

        if(!$results_show_all && ($this->nbepage!=1)){
            return "&nbsp;&nbsp;&nbsp;<input type='button' class='bouton_small' onclick='results_show_all();' name='searcher_results_show_all' value='".htmlentities($msg['searcher_results_show_all'], ENT_QUOTES, $charset)."'>";
        }
    }

    protected function get_button_check_uncheck() {
        global $msg, $charset;

        return "
        <div class='row'>
			<input type='button' class='bouton_small' onclick='check_uncheck(1);' id='searcher_results_check_all' name='searcher_results_check_all' value='".htmlentities($msg['searcher_results_check_all'],ENT_QUOTES,$charset)."'>
			&nbsp;&nbsp;
			<input type='button' class='bouton_small' onclick='add_selection();' id='searcher_results_add_selection' name='searcher_results_add_selection' value='".htmlentities($msg['searcher_results_add_selection'],ENT_QUOTES,$charset)."'>
		</div>";
    }

    public function make_store_form() {
        $this->store_form="<form name='store_search' action='".$this->base_url."&typ_query=".$this->cur_typ_query."' method='post' style='display:none'>
		<input type='hidden' name='aut_type' value='".$this->aut_type."'/>
		<input type='hidden' name='aut_id' value='".$this->aut_id."'/>
		<input type='hidden' name='etat' value='".$this->etat."'/>
		<input type='hidden' name='page' value='".$this->page."'/>
		!!first_search_variables!!
		</form>";
    }

    public function show_elt() {
    }


    public function make_first_search() {
        //A surcharger par la fonction qui fait la premire recherche aprs la soumission du formulaire de recherche
        //La fonction renvoie AUT_LIST (le rsultat de la recherche est une liste d'autorit)
        //ou ELT_LIST (le rsultat de la recherche est une liste d'lements)
        //La fonction doit mettre  jour le nombre de rsultats dans $this->nbresults
    }


    public function make_aut_search() {
        //A surcharger par la fonction qui fait la recherche des lments  partir d'un numro d'autorit (stoqu dans $this->aut_id)
        //La fonction doit mettre  jour le nombre de rsultats dans $this->nbresults
    }


    public function store_search() {
        //A surcharger par la fonction qui crit les variables du formulaire "store_search" pour stoquer les champs de recherche
        //En liste de rsultat de la premire recherche. Il faut remplacer la chaine "!!first_search_variables!!" dans $this->store_form
        global $elt_query;
        global $charset;
        $champs="<input type='hidden' name='elt_query' value='".htmlentities(stripslashes($elt_query),ENT_QUOTES,$charset)."'/>";
        $this->store_form=str_replace("!!first_search_variables!!",$champs,$this->store_form);
        print $this->store_form;
    }

    public function aut_store_search() {
        //A surcharger par la fonction qui crit les variables du formulaire "store_search" pour stoquer les champs de recherche
        //En liste de rsultat de la premire recherche. Il faut remplacer la chaine "!!first_search_variables!!" dans $this->store_form
        global $elt_query;
        global $charset;
        $champs="<input type='hidden' name='elt_query' value='".htmlentities(stripslashes($elt_query),ENT_QUOTES,$charset)."'/>";
        $this->store_form=str_replace("!!first_search_variables!!",$champs,$this->store_form);
        print $this->store_form;
    }

    public function aut_list() {
        //A surcharger par la fonction qui affiche la liste des autorits issues de la premire recherche
    }

    public function get_title_elt_list() {
        return '';
    }

    public function get_title_column_number() {
        global $msg;

        return "&nbsp;";
    }

    public function get_display_begin_elt_list() {
        global $msg, $charset;
        global $elt_query, $begin_result_liste;

        $research = '<b>'.htmlentities($this->get_title_elt_list(),ENT_QUOTES,$charset).'</b>&nbsp;'.htmlentities(stripslashes($elt_query),ENT_QUOTES,$charset);
        $research .= " => ".sprintf($msg["searcher_results"],$this->nbresults);
        $research .= $this->get_button_show_all();

        $title_column_number = $this->get_title_column_number();
        if ($title_column_number != "&nbsp;") {
            $title_column_number = htmlentities($title_column_number, ENT_QUOTES, $charset);
        }

        //Pour la retro-compatibilite
        if (!empty($this->elt_b_list)) {
            $this->elt_b_list = str_replace('!!research!!', $research, $this->elt_b_list);
            return $this->elt_b_list;
        }
        return "<div class='row'>
        	<div class='colonne80'>".$begin_result_liste.$research."</div>
        	<div class='colonne10'>&nbsp;</div>
        	<div class='colonne10'>".$title_column_number."</div>
        </div>";
    }

    public function get_display_sort_elt_list() {
        return '';
    }

    public function get_instance_sel_display($row) {
        return null;
    }

    public function elt_list() {
        global $msg;

        $this->show_form();
        if ($this->nbresults) {
            print $this->get_display_begin_elt_list();
            //Boutons check/uncheck/add selection
            print $this->get_button_check_uncheck();
            print "<form name='searcher_results_check_form'>";
            //entete pour trier
            print $this->get_display_sort_elt_list();
            // on lance la requte
            $list = '';
            while(($nz=pmb_mysql_fetch_object($this->t_query))) {
                $instance = $this->get_instance_sel_display($nz);
                $instance->action=$this->action;
                $instance->action_values=$this->action_values;
                $instance->doForm();
                $list.= $this->elt_r_list;
                if (count($this->elt_r_list_values) ) {
                    foreach($this->elt_r_list_values as $v) {
                        $list = str_replace("!!$v!!", $instance->$v, $list);
                    }
                }
            }
            print $list;
            // fin de liste
            print "</form>";
            print $this->elt_e_list;
            print $this->back_script;
            print $this->back_script_show_all;
        } else {
            error_message_history($msg[357], $msg[1915], 1);
        }
    }


    public function aut_elt_list() {
        //A surcharger par la fonction qui affiche la liste des lments sous l'autorit $this->aut_id
    }


    public function rec_env() {
        //A surcharger par la fonction qui enregistre
    }

    public function get_js_function_set_parent() {
        global $msg, $caller, $cr;

        return "
        function set_parent(id_prod, typ_lig, code, nom_acte, prix, callback) {
			var ex=window.parent.act_lineAlreadyExists(0, id_prod, typ_lig);
			var q,cr;
			var v=1;
			if (ex!=false) {
				q=window.parent.document.forms['$caller'].elements['qte['+ex+']'];
				v=q.value;
				r=prompt('".addslashes($msg['acquisition_act_mod_qte'])."', v);
				if (r) {
					q.value=r;
					window.parent.act_calc();
					return false;
				} return false;
			}
			if (window.parent.mod==1) {
				cr='$cr';
			} else {
				cr = window.parent.act_getEmptyLine();
			}
			window.parent.mod=0;
			window.parent.document.forms['$caller'].elements['typ_lig['+cr+']'].value = typ_lig;
			window.parent.document.forms['$caller'].elements['id_prod['+cr+']'].value = id_prod;
            if (code) {
                window.parent.document.forms['$caller'].elements['code['+cr+']'].value = reverse_html_entities(code);
            }
            var lib = reverse_html_entities(nom_acte);
            lib = lib.replaceAll('<br />', '\\n');
			window.parent.document.forms['$caller'].elements['lib['+cr+']'].value = lib;
			window.parent.document.forms['$caller'].elements['prix['+cr+']'].value = reverse_html_entities(prix);
			window.parent.act_calc();
			q=window.parent.document.forms['$caller'].elements['qte['+cr+']'];
			q.value=v;
			q.focus();
			if(callback) {
				window.parent[callback](cr);
			}
		}";
    }

    public function get_js_function_check_uncheck() {
        global $msg;

        return "
        function check_uncheck(do_check){
            if(do_check==1){
                document.getElementById('searcher_results_check_all').value='".$msg['searcher_results_uncheck_all']."';
                document.getElementById('searcher_results_check_all').onclick=function(){check_uncheck(0);};
            }else{
                document.getElementById('searcher_results_check_all').value='".$msg['searcher_results_check_all']."';
                document.getElementById('searcher_results_check_all').onclick=function(){check_uncheck(1);};
            }
            var elts = document.forms['searcher_results_check_form'].elements['sel_searcher_select_[]'] ;
            var elts_cnt = (typeof(elts.length) != 'undefined') ? elts.length : 0;
            if (elts_cnt) {
                for (var i = 0; i < elts_cnt; i++) {
                    elts[i].checked = do_check;
                }
            } else {
                elts.checked = do_check;
            }
            return true;
        }";
    }

    public function get_js_function_get_title_selection() {
        return "
        function get_title_selection(elt) {
            var title='';
            return title;
        }";
    }

    public function get_js_function_add_selection($callback_set_parent='') {
        global $callback;

        if (empty($callback_set_parent)) {
            $callback_set_parent = "
            set_parent(elt.getAttribute('attr_id'),
            elt.getAttribute('attr_typ_lig'),
            elt.getAttribute('attr_code'),
            elt.getAttribute('attr_nom_acte'),
    		elt.getAttribute('attr_prix'),
    		'".$callback."');";
        }
        return "
        function add_selection(){
            var arrayChecked = [];
            var elts = document.forms['searcher_results_check_form'].elements['sel_searcher_select_[]'] ;
            var elts_cnt = (typeof(elts.length) != 'undefined') ? elts.length : 0;
            if (elts_cnt) {
                for (var i = 0; i < elts_cnt; i++) {
                    if(elts[i].checked){
                        arrayChecked.push(elts[i].value);
                    }
                }
            } else {
                if(elts.checked){
                    arrayChecked.push(elts.value);
                }
            }
            if(arrayChecked.length>0){
                for (var i = 0; i < arrayChecked.length; i++) {
                    var elt = document.getElementById('sel_searcher_select_[' + arrayChecked[i] + ']') ;
                    ".$callback_set_parent."
                }
            }
        }";
    }

    public function init_back_script_show_all() {
        $this->back_script_show_all = "
		<script type='text/javascript'>
			<!--
			function results_show_all(){
				window.resizeTo(1024,parent.innerHeight);
				document.forms['form_query'].results_show_all.value=1;
				document.forms['form_query'].submit();
			}
			-->
		</script>";
    }
}
