<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: rdf_entities_converter_expl.class.php,v 1.3.12.1 2025/06/27 14:20:44 rtigero Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

global $class_path;

require_once $class_path . '/explnum.class.php';

class rdf_entities_converter_expl extends rdf_entities_converter
{

    public static $table_name = 'exemplaires';

    public static $table_key = 'expl_id';

    protected $ppersos_prefix = 'expl';

    protected $type_constant = TYPE_EXPL;

    protected $aut_table_constant = AUDIT_EXPL;

    protected function init_map_fields()
    {
        $this->map_fields = array_merge(parent::init_map_fields(), array(
            'expl_id' => 'http://www.pmbservices.fr/ontology#identifier',
            'expl_cb' => 'http://www.pmbservices.fr/ontology#cb',
            'expl_typdoc' => 'http://www.pmbservices.fr/ontology#typdoc',
            'expl_cote' => 'http://www.pmbservices.fr/ontology#cote',
            'expl_section' => 'http://www.pmbservices.fr/ontology#docs_section',
            'expl_statut' => 'http://www.pmbservices.fr/ontology#has_expl_status',
            'expl_location' => 'http://www.pmbservices.fr/ontology#expl_location',
            'expl_owner' => 'http://www.pmbservices.fr/ontology#owner'
        ));
    }

    protected function init_foreign_fields()
    {
        $this->foreign_fields = array_merge(parent::init_foreign_fields(), array(
            'expl_notice' => array(
                'type' => 'record',
                'property' => 'http://www.pmbservices.fr/ontology#has_record'
            )
        ));
        return $this->foreign_fields;
    }

}
