<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: netbase_animations.class.php,v 1.1.4.2 2025/06/26 08:10:35 qvarin Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

class netbase_animations
{
    protected static $cleaned_animations = [];

    protected static $cleaned_authorities = [];

    protected static $indexation_animations;

    protected static $indexation_by_fields = false;

    protected static $step_position = 0;

    public static function proceed()
    {
        global $spec;

        if ($spec & INDEX_ANIMATIONS) {
            static::proceed_reindex();
        }
    }

    public static function proceed_reindex()
    {
        global $msg, $v_state, $spec, $pmb_clean_mode;
        global $start, $count, $step_position;

        // initialisation de la borne de dpart
        if (!isset($start) && empty($step_position)) {
            $start = 0;
            netbase_animations::raz_index();
        }

        // Indexation par champ active ? (sera active par dfaut par la suite))
        if (!empty($pmb_clean_mode)) {
            netbase_animations::set_indexation_by_fields(true);
            mysql_set_wait_timeout(300);
        }

        if (!empty($step_position)) {
            netbase_animations::set_step_position($step_position);
        }

        $v_state = urldecode($v_state);
        if (!isset($count) || !$count) {
            $count = static::get_count_index();
        }

        print netbase::get_display_progress_title($msg["nettoyage_reindex_animations"]);
        $next = static::index_from_interface($start, $count);
        $next_position = static::get_step_position();
        if ($next || $next_position) {
            print netbase::get_current_state_form($v_state, $spec, '', $next, $count, '', $next_position);
        } else {
            $spec = $spec - INDEX_ANIMATIONS;

            $v_state .= netbase::get_display_progress_v_state($msg["nettoyage_reindex_animations"], $count." ".$msg["nettoyage_res_reindex_animations"]);
            print netbase::get_process_state_form($v_state, $spec);

            netbase_animations::enable_index();
        }
    }

    public static function proceed_reindex_sphinx()
    {
    }

    public static function index_from_query($query)
    {
        $result = pmb_mysql_query($query);
        $nb_indexed = pmb_mysql_num_rows($result);
        if ($nb_indexed) {

            /**
             * @var indexation $indexation_animations
             */
            $indexation_animations = indexations_collection::get_indexation(AUT_TABLE_ANIMATION);
            $indexation_animations->set_deleted_index(true);

            while (($row = pmb_mysql_fetch_object($result))) {
                $indexation_animations->maj($row->id);
            }

            pmb_mysql_free_result($result);
        }

        return $nb_indexed;
    }

    public static function raz_index()
    {
        $indexation_animations = static::get_indexation_animations();
        $indexation_animations->raz_fields_table();
        $indexation_animations->raz_words_table();
        $indexation_animations->disable_fields_table_keys();
        $indexation_animations->disable_words_table_keys();

        netbase_entities::clean_files($indexation_animations->get_directory_files());
    }

    public static function get_index_query_count()
    {
        return "SELECT count(1) FROM anim_animations";
    }

    public static function get_count_index()
    {
        $elts = pmb_mysql_query(static::get_index_query_count());
        return pmb_mysql_result($elts, 0, 0);
    }

    public static function get_lot($count)
    {
        if (static::$indexation_by_fields) {
            $lot = REINDEX_BY_FIELDS_PAQUET_SIZE; // defini dans ./params.inc.php
            $step_fields = static::get_step_fields_from_position(static::$step_position);
            if (!empty($step_fields) && $step_fields['step_name'] == 'callables') {
                $lot = REINDEX_BY_CALLABLES_FIELDS_PAQUET_SIZE; // defini dans ./params.inc.php
            }
            if ($count && ($lot + 5000) > $count) {
                //On s'accorde une souplesse pour ne pas refaire une passe dans le vide pour une taille proche du compteur
                $lot = $count;
            }
            return $lot;
        } else {
            return REINDEX_PAQUET_SIZE; // defini dans ./params.inc.php
        }
    }

    public static function get_index_query($start, $lot)
    {
        $start = intval($start);
        $lot = intval($lot);
        return "SELECT id_animation as id from anim_animations order by id_animation LIMIT $start, $lot";
    }

    public static function get_objects_ids_index($start, $lot)
    {
        $objects_ids = [];
        $query = static::get_index_query($start, $lot);
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            while ($row = pmb_mysql_fetch_array($result)) {
                $objects_ids[] = $row['id'];
            }
        }
        return $objects_ids;
    }

    public static function index_from_interval($start, $count)
    {
        $lot = static::get_lot($count);
        if (static::$indexation_by_fields) {
            $indexation_animations = static::get_indexation_animations();
            $steps_fields_number = $indexation_animations->get_steps_fields_number();
            $next = 0;
            if (static::$step_position) {
                $objects_ids = static::get_objects_ids_index($start, $lot);
                $nb_objects_ids = count($objects_ids);
                if ($nb_objects_ids) {
                    indexation_animations::set_objects_mode('ids');
                    $indexation_animations->set_objects_ids($objects_ids);
                    if (static::$step_position <= $steps_fields_number) {
                        static::index_step_fields_from_position(static::$step_position);
                    }
                    if (($start + $lot) >= $count) {
                        if (static::$step_position == $steps_fields_number) {
                            static::$step_position = 0;
                        } else {
                            static::$step_position++;
                        }
                    } else {
                        $next = $start + $lot;
                    }
                } else {
                    static::$step_position++;
                }
            } else {
                static::$step_position++;
            }
            if (static::$step_position && static::$step_position <= $steps_fields_number) {
                return $next;
            }
        } else {
            $query = static::get_index_query($start, $lot);
            $nb_indexed = static::index_from_query($query);
            if ($nb_indexed) {
                return ($start + $lot);
            }
        }
        return 0;
    }

    public static function index_from_interface($start, $count)
    {
        if (empty($count)) {
            // mise  jour de l'affichage de la jauge
            print netbase::get_display_final_progress();
            return 0;
        }
        $next = static::index_from_interval($start, $count);
        if (static::$indexation_by_fields) {
            print static::get_display_progress_title();
            $indexation_animations = static::get_indexation_animations();
            $steps_fields_number = $indexation_animations->get_steps_fields_number();
            if (static::$step_position && static::$step_position <= $steps_fields_number) {
                $progress_start = static::$step_position;
                $progress_in_step = 0;
                if ($next && static::$step_position) {
                    $progress_in_step = ($next / $count) * ((static::$step_position) / $steps_fields_number);
                    if ($progress_start + $progress_in_step <= $steps_fields_number) {
                        $progress_start += $progress_in_step;
                    }
                }
                print netbase::get_display_progress($progress_start, $steps_fields_number);
                return $next;
            }
        } else {
            if ($next) {
                print netbase::get_display_progress($start, $count);
                return $next;
            }
        }
        print netbase::get_display_final_progress();
        return 0;
    }

    public static function index_sphinx_from_interval($start, $count)
    {
        $lot = static::get_lot($count);
        $si = indexation_record::get_sphinx_indexer();
        if (is_object($si)) {
            $objects_ids = static::get_objects_ids_index($start, $lot);
            $nb_objects_ids = count($objects_ids);
            if ($nb_objects_ids) {
                $si->fillIndexes($objects_ids);
                return ($start + $lot);
            }
        }
        return 0;
    }

    public static function index_sphinx_from_interface($start, $count)
    {
        if (empty($count)) {
            // mise  jour de l'affichage de la jauge
            print netbase::get_display_final_progress();
            return 0;
        }
        $next = static::index_sphinx_from_interval($start, $count);
        if ($next) {
            print netbase::get_display_progress($start, $count);
            return $next;
        }
        // mise  jour de l'affichage de la jauge
        print netbase::get_display_final_progress();
        return 0;
    }

    public static function index($object_type = 0)
    {
        $indexation_animations = static::get_indexation_animations();
        $indexation_animations->launch_indexation();
    }

    public static function index_steps_fields()
    {
        $steps_fields = static::get_steps_fields();
        foreach ($steps_fields as $step_key => $step_fields) {
            foreach ($step_fields as $fields) {
                if (!empty($fields[0])) {
                    $by_fields = [];
                    foreach ($fields as $field) {
                        $by_fields[] = $field['champ'];
                    }
                    if (!empty($by_fields)) {
                        $indexed = static::index_by_fields($step_key, $by_fields);
                    }
                } else {
                    $indexed = static::index_by_fields($step_key, [$fields['champ']]);
                }
            }
        }
        return $indexed;
    }

    public static function get_step_fields_from_position($position = 0)
    {
        $steps_fields_position = 1;
        $steps_fields = static::get_steps_fields();
        foreach ($steps_fields as $step_name => $step_fields) {
            foreach ($step_fields as $fields) {
                if ($steps_fields_position == $position) {
                    if (!empty($fields[0])) {
                        $by_fields = [];
                        $labels = [];
                        foreach ($fields as $field) {
                            $by_fields[] = $field['champ'];
                            $labels[] = $field['label'];
                        }
                        if (!empty($by_fields)) {
                            return [
                                'step_name' => $step_name,
                                'fields' => $by_fields,
                                'labels' => $labels,
                            ];
                        }
                    } else {
                        return [
                            'step_name' => $step_name,
                            'fields' => [$fields['champ']],
                            'labels' => [$fields['label']],
                        ];
                    }
                }
                $steps_fields_position++;
            }
        }
    }

    public static function index_step_fields_from_position($position = 0)
    {
        if ($position == 0) {
            return 1;
        }
        $step_fields = static::get_step_fields_from_position($position);
        if (!empty($step_fields)) {
            return static::index_by_fields($step_fields['step_name'], $step_fields['fields']);
        }
        return 0;
    }

    public static function index_by_step($step = '')
    {
        $indexation_animations = static::get_indexation_animations();
        return $indexation_animations->maj_by_step($step);
    }

    public static function index_by_fields($step = '', $fields = [])
    {
        if (!empty($step) && !empty($fields)) {
            $indexation_animations = static::get_indexation_animations();
            return $indexation_animations->maj_by_fields($step, $fields);
        }
        return 0;
    }

    public static function import_bdd()
    {
        $indexation_animations = static::get_indexation_animations();
        $indexation_animations->maj_bdd_from_files();
    }

    public static function enable_index()
    {
        $indexation_animations = static::get_indexation_animations();
        $indexation_animations->enable_fields_table_keys();
        $indexation_animations->enable_words_table_keys();
    }

    public static function get_steps_fields()
    {
        $indexation_animations = static::get_indexation_animations();
        return $indexation_animations->get_steps_fields();
    }

    public static function get_number_steps_fields()
    {
        $number = 0;
        $steps_fields = static::get_steps_fields();
        foreach ($steps_fields as $step_fields) {
            $number += count($step_fields);
        }
        return $number;
    }

    public static function get_nb_steps()
    {
        return count(indexation::$steps);
    }

    protected static function clean_field_data($field = '')
    {
        global $charset;

        if (empty($field)) {
            return false;
        }

        $query = "SELECT id_animation, ".$field." FROM anim_animations";
        $result = pmb_mysql_query($query);
        if ($result && pmb_mysql_num_rows($result)) {
            while ($row = pmb_mysql_fetch_object($result)) {
                $decoded_field = html_entity_decode($row->{$field}, ENT_QUOTES, $charset);
                if ($row->{$field} != $decoded_field) {
                    $query = "UPDATE anim_animations SET ".$field." = '".addslashes($decoded_field)."' WHERE id_animation =".$row->id_animation;
                    pmb_mysql_query($query);

                    if (!in_array($row->id_animation, static::$cleaned_animations)) {
                        static::$cleaned_animations[] = $row->id_animation;
                    }
                }
            }
        }
    }

    public static function clean_data()
    {
        return true;
    }

    public static function get_cleaned_animations()
    {
        return static::$cleaned_animations;
    }

    public static function get_cleaned_authorities()
    {
        return static::$cleaned_authorities;
    }

    public static function set_indexation_by_fields($indexation_by_fields)
    {
        static::$indexation_by_fields = $indexation_by_fields;
    }

    public static function get_step_position()
    {
        return static::$step_position;
    }

    public static function set_step_position($step_position)
    {
        static::$step_position = intval($step_position);
    }

    /**
     * indexation
     *
     * @return indexation_animations
     */
    public static function get_indexation_animations()
    {
        global $include_path;

        if (!isset(static::$indexation_animations) || static::$indexation_animations == null) {
            static::$indexation_animations = new indexation_animations($include_path."/indexation/animations/champs_base.xml", 'anim_animations');
        }
        return static::$indexation_animations;
    }

    public static function unset_indexation_animations()
    {
        static::$indexation_animations = null;
    }

    public static function get_display_progress_title()
    {
        $step_fields = static::get_step_fields_from_position(static::$step_position);
        if (!empty($step_fields['labels'])) {
            return netbase::get_display_progress_subtitle(implode(' - ', $step_fields['labels']));
        }
        return '';
    }
}
