<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: list_role_rights_actions_ui.class.php,v 1.1.2.5 2025/09/05 09:03:55 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class list_role_rights_actions_ui extends list_role_rights_ui {
	
    protected static $list_forms_instance;
    
    protected $list_forms_ui;
    
    protected static $list_forms_data;
    
    /**
     * Initialisation des droits
     */
    protected function _init_role_rights() {
        $this->_init_role_forms_rights();
        $this->_init_role_specifics_rights();
    }
    
    public function get_tab($section, $categ, $label_code, $sub='', $url_extra='', $number=0) {
        global $msg;
        
        $tab = new tab();
        $tab->set_module(static::$module_name)
        ->set_section($section)
        ->set_label_code($label_code)
        ->set_categ($categ)
        ->set_label(isset($msg[$label_code]) ? $msg[$label_code] : $label_code)
        ->set_sub($sub)
        ->set_url_extra($url_extra);
        return $tab;
    }
    
    protected function _adjustement_tabs_catalog_ui($object) {
        switch ($object->get_categ()) {
            case 'create':
                $object->set_categ('create_form');
                break;
            case 'etagere':
                if (empty($object->get_sub())) {
                    $object->set_sub('edit_etagere');
                }
                break;
        }
        return $object;
    }
    
    protected function _adjustement_tabs_autorites_ui($object) {
        switch ($object->get_categ()) {
            case 'auteurs':
                switch ($object->get_sub()) {
                    case 'author':
                        $object->set_sub('author_form');
                        break;
                }
                break;
            case 'categories':
                switch ($object->get_sub()) {
                    case 'category':
//                      $tab['sub'] = 'categ_form';
                        break;
                }
                break;
            case 'collections':
                switch ($object->get_sub()) {
                    case 'collection':
                        $object->set_sub('collection_form');
                        break;
                }
                break;
            case 'editeurs':
                switch ($object->get_sub()) {
                    case 'publisher':
                        $object->set_sub('editeur_form');
                        break;
                }
                break;
            case 'indexint':
                switch ($object->get_sub()) {
                    case 'indexint':
                        $object->set_sub('indexint_form');
                        break;
                }
                break;
            case 'series':
                switch ($object->get_sub()) {
                    case 'serie':
                        $object->set_sub('serie_form');
                        break;
                }
                break;
            case 'souscollections':
                switch ($object->get_sub()) {
                    case 'subcollection':
                        $object->set_sub('collection_form');
                        break;
                }
                break;
            case 'titres_uniformes':
                switch ($object->get_sub()) {
                    case 'titre_uniforme':
                        $object->set_sub('titre_uniforme_form');
                        break;
                }
                break;
        }
        return $object;
    }
    
    protected function _adjustement_tabs_ui() {
        $objects = $this->list_tabs_ui->get_objects();
        foreach ($objects as $object) {
            switch (static::$module_name) {
                case 'catalog':
                    $object = $this->_adjustement_tabs_catalog_ui($object);
                    break;
                case 'autorites':
                    $object = $this->_adjustement_tabs_autorites_ui($object);
                    break;
            }
        }
        switch (static::$module_name) {
            case 'catalog':
                $objects[] = $this->get_tab('4057', 'serials', 'type_serial', 'serial_form');
                $objects[] = $this->get_tab('4057', 'serials', 'type_bull', 'bulletinage');
                $objects[] = $this->get_tab('4057', 'serials', 'type_art', 'analysis');
                break;
            case 'autorites':
                    $objects[] = $this->get_tab('132', 'categories', 'thesaurus', 'thes_form');
                    $objects[] = $this->get_tab('132', 'authperso', 'authperso', 'authperso_form');
                break;
        }
        $objects[] = $this->get_tab('general', '', 'general');
        $this->list_tabs_ui->set_objects($objects);
    }
    
    protected function _adjustement_subtabs_catalog_ui($object) {
        return $object;
    }
    
    protected function _adjustement_subtabs_autorites_ui($object) {
        return $object;
    }
    
    protected function _adjustement_subtabs_ui() {
        $objects = $this->list_subtabs_ui->get_objects();
        foreach ($objects as $object) {
            switch (static::$module_name) {
                case 'catalog':
                    $object = $this->_adjustement_subtabs_catalog_ui($object);
                    break;
                case 'autorites':
                    $object = $this->_adjustement_subtabs_autorites_ui($object);
                    break;
            }
        }
        $this->list_subtabs_ui->set_objects($objects);
    }
    
    /**
     * Initialisation des droits sur les actions de formulaires
     */
    protected function _init_role_forms_rights() {
        $tabs = $this->_get_list_tabs_data();
        if (!empty($tabs)) {
            $subtabs = $this->_get_list_subtabs_data();
            $this->_get_list_forms_data();
            foreach ($tabs as $section_label=>$sections_tabs) {
                $section_exits_actions = false;
                foreach ($sections_tabs as $tab) {
                    $tab_exits_actions = false;
                    $tab['section_label'] = $section_label;
                    $tab['subtabs'] = [];
                    $label_code = $tab['label_code'];
                    if (!empty($subtabs[$label_code])) {
                        foreach ($subtabs[$label_code] as $subtab) {
                            $subtab_actions = $this->get_actions_forms_rights($subtab['categ'], $subtab['sub'], $subtab['url_extra']);
                            if (!empty($subtab_actions)) {
                                $subtab['actions'] = $subtab_actions;
                                $tab['subtabs'][] = $subtab;
                                $tab_exits_actions = true;
                            }
                        }
                    } else {
                        $tab_actions = $this->get_actions_forms_rights($tab['categ'], $tab['sub'], $tab['url_extra']);
                        if (!empty($tab_actions)) {
                            $tab['actions'] = $tab_actions;
                            $tab_exits_actions = true;
                        }
                    }
                    if ($tab_exits_actions) {
                        $this->add_object($tab);
                        $section_exits_actions = true;
                    }
                }
                if ($section_exits_actions == false) {
                    unset($tabs[$section_label]);
                }
            }
//          printr(static::$list_forms_data[static::$module_name]);
        }
    }
    
    public function get_right_action($name) {
        $action = new \stdClass();
        $action->button = "activation";
        $action->categ = "";
        $action->sub = "";
        $action->url_extra = "";
        $action->name = $name;
        $action->module = static::$module_name;
        return $action;
    }
    
    protected function get_label_code_from_specific_right($name) {
        switch ($name) {
            case 'sauv':
                return '28';
            case 'pref':
                return '933';
            case 'restrictcirc':
                return 'restrictcirc_auth';
//             case 'restrictcatal':
//                 return '28';
            case 'thesaurus':
                return 'thesaurus_auth';
            case 'transferts':
                return 'transferts_droit';
            case 'edit_forcing':
                return 'edit_droit_forcing';
            case 'catal_modif_cb_expl':
                return 'catal_modif_cb_expl_droit';
            case 'acquisition_account_invoice':
                return 'acquisition_account_invoice_flg';
            case 'cms_build':
                return 'cms_build_tab';
            case 'concepts':
                return 'ontology_skos_menu';
        }
    }
    
    public function add_specific_right($name) {
        global $msg;
        
        $label_code = $this->get_label_code_from_specific_right($name);
        $specific_right = [];
        $specific_right['label'] = $msg[$label_code];
        $specific_right['section_label'] = $msg['general'];
        $specific_right['subtabs'] = [];
        $specific_right['actions'] = [0 => $this->get_right_action($name)];
        $specific_right['label_code'] = $label_code;
        $specific_right['object'] = $this->get_tab('general', '', $label_code);
        $this->add_object($specific_right);
    }
    
    protected function get_modules_from_specific_right($name) {
        switch ($name) {
            case 'sauv':
//                 return ['admin'];
                return []; // pour qu'il apparaisse dans tous les modules
            case 'pref':
//                 return ['admin'];
                return []; // pour qu'il apparaisse dans tous les modules
            case 'restrictcirc':
                return ['circ'];
            case 'restrictcatal':
                return ['plus_utilise']; //plus utilis, c'est une cl bidon
            case 'thesaurus':
                return ['autorite'];
            case 'transferts':
                return ['catalog', 'circ'];
            case 'edit_forcing':
                return ['edit'];
            case 'catal_modif_cb_expl':
                return ['circ'];
            case 'acquisition_account_invoice':
                return ['acquisition'];
            case 'cms_build':
                return ['cms'];
            case 'concepts':
                return ['autorite'];
        }
        return [];
    }
    protected function has_allowed_specific_right($name) {
        $modules = $this->get_modules_from_specific_right($name);
        if (empty($modules) || in_array(static::$module_name, $modules)) {
            return true;
        }
        return false;
    }
    
    /**
     * Initialisation des droits sur les actions spcifiques
     */
    protected function _init_role_specifics_rights() {
        $constants_roles_rights = user::get_constants_roles_rights();
        foreach ($constants_roles_rights['actions'] as $name=>$constant) {
            if ($this->has_allowed_specific_right($name)) {
                $this->add_specific_right($name);
            }
            
        }
    }
    
    /**
     * On regarde les formulaires et ses actions
     * @param string $categ
     * @param string $sub
     * @param string $url_extra
     * @return array
     */
    public function get_actions_forms_rights($categ, $sub, $url_extra) {
        $actions = [];
        if (empty($categ)) {
            $categ = '_empty_';
        }
        if (empty($sub)) {
            $sub = '_empty_';
        }
        if (empty($url_extra)) {
            $url_extra = '_empty_';
        }
        if (!empty(static::$list_forms_data[static::$module_name][$categ][$sub][$url_extra])) {
            $forms_data = static::$list_forms_data[static::$module_name][$categ][$sub][$url_extra];
            foreach ($forms_data as $form) {
                $actions_buttons = $form['object']->get_actions_buttons();
                foreach ($actions_buttons as $action_button) {
                    $form['button'] = $action_button;
                    $actions[] = $form;
                }
            }
            unset(static::$list_forms_data[static::$module_name][$categ][$sub][$url_extra]);
        }
        return $actions;
    }
    
    protected function _get_list_tabs_ui() {
        if (!isset($this->list_tabs_ui)) {
            parent::_get_list_tabs_ui();
            $this->_adjustement_tabs_ui();
        }
        return $this->list_tabs_ui;
    }
    
    protected function _get_list_subtabs_ui() {
        if (!isset($this->list_subtabs_ui)) {
            parent::_get_list_subtabs_ui();
            $this->_adjustement_subtabs_ui();
        }
        return $this->list_subtabs_ui;
    }
    
    protected static function _get_list_forms_instance() {
        if (!isset(static::$list_forms_instance[static::$module_name])) {
            //depth == 2 pour essayer de rcuprer dans un premier temps les formulaires de second niveau max (menu / sous-menu)
            $list_forms_ui = new list_forms_ui(['modules' => [static::$module_name], 'depth' => 2]);
            $list_forms_ui->set_applied_group(['categ', 'sub', 'url_extra']);
            static::$list_forms_instance[static::$module_name] = $list_forms_ui;
        }
        return static::$list_forms_instance[static::$module_name];
    }
    
	protected function _get_list_forms_ui() {
	    if (!isset($this->list_forms_ui)) {
	        $this->list_forms_ui = static::_get_list_forms_instance();
	    }
	    return $this->list_forms_ui;
	}
	
	protected function _get_list_forms_data() {
	    $module_name = static::$module_name;
	    if (!isset(static::$list_forms_data[$module_name])) {
	        static::$list_forms_data[$module_name] = [];
	        $list_forms_ui = $this->_get_list_forms_ui();
	        static::$list_forms_data[$module_name] = $list_forms_ui->get_objects_data();
	    }
	    return static::$list_forms_data[$module_name];
	}
	
	protected function get_message_not_grouped() {
	    global $msg;
	    return $msg['general'];
	}
	
}