<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: list_custom_fields_groups_ui.class.php,v 1.1.2.2 2025/11/21 09:04:50 dgoron Exp $
if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class list_custom_fields_groups_ui extends list_ui
{

    protected static $prefix;

    public static function set_prefix($prefix)
    {
        static::$prefix = $prefix;
    }

    protected function _get_query_base()
    {
        return "SELECT id_group AS id from custom_fields_groups";
    }
    
    /**
     * Champ(s) du tri SQL
     */
    protected function _get_query_field_order($sort_by)
    {
        switch($sort_by) {
            case 'id':
                return $sort_by.'_group';
            case 'name':
            case 'title':
                return 'group_'.$sort_by;
            default :
                return parent::_get_query_field_order($sort_by);
        }
    }

    protected function get_object_instance($row) 
    {
        return new custom_fields_group($row->id);
    }
    
    /**
     * Initialisation des colonnes disponibles
     */
    protected function init_available_columns()
    {
        $this->available_columns = array(
            'main_fields' => array(
                'name' => 'custom_fields_group_name',
                'title' => 'custom_fields_group_title'
            )
        );
    }

    protected function init_default_columns()
    {
        $this->add_column('name');
        $this->add_column('title');
    }

    protected function init_default_settings()
    {
        parent::init_default_settings();
        $this->set_setting_display('search_form', 'visible', false);
        $this->set_setting_display('query', 'human', false);
        $this->set_setting_column('default', 'align', 'left');
    }

    /**
     * Initialisation du tri par dfaut appliqu
     */
    protected function init_default_applied_sort()
    {
        $this->add_applied_sort('title');
    }

    protected function init_default_pager() 
    {
        parent::init_default_pager();
        $this->pager['all_on_page'] = true;
    }
    
    protected function _add_query_filters()
    {
        $this->query_filters [] = "group_type = '" . addslashes(static::$prefix) . "'";
    }
    
    protected function get_default_attributes_format_cell($object, $property)
    {
        return array(
            'onclick' => "window.location=\"" . static::get_controller_url_base() . "&action=edit_group&id=" . $object->get_id() . "\""
        );
    }
}