<?php
// +-------------------------------------------------+
// 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: addon.inc.php,v 1.8.2.32.2.4.2.11.2.27 2025/12/09 10:58:41 dgoron Exp $

use Pmb\CMS\Orm\VersionOrm;
use Pmb\CMS\Models\PortalModel;
use Pmb\CMS\Models\PageModel;
use Pmb\CMS\Models\LayoutModel;
use Pmb\CMS\Models\ConditionModel;
use Pmb\CMS\Models\LayoutElementModel;
use Pmb\CMS\Models\LayoutContainerModel;

if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) {
    die("no access");
}

global $pmb_bdd_subversion, $pmb_bdd_version, $pmb_version_brut, $pmb_version_patch;
global $pmb_subversion_database_as_it_shouldbe;
global $pmb_bdd_subversion_error;

function traite_addon_rqt($requete = "", $message = "")
{
    global $charset, $pmb_bdd_subversion;
    global $db_update_log_version, $db_update_step, $db_update_error;
    
    $retour = "Successful";
    if ($charset == "utf-8") {
        $requete = encoding_normalize::utf8_encode($requete);
        $message = encoding_normalize::utf8_encode($message);
    }
    pmb_mysql_query($requete);
    $erreur_no = pmb_mysql_errno();
    $erreur_msg = pmb_mysql_error();
    
    if ($erreur_no) {
        switch ($erreur_no) {
            case "1060":
                $retour = "Field already exists, no problem.";
                break;
            case "1061":
                $retour = "Key already exists, no problem.";
                break;
            case "1091":
                $retour = "Object already deleted, no problem.";
                break;
            default:
                if (! $db_update_error) {
                    $db_update_error = $db_update_step;
                    $query_error = "UPDATE parametres SET valeur_param='" . $db_update_error . "' WHERE type_param='pmb' AND sstype_param='bdd_subversion_error' AND valeur_param=0";
                    pmb_mysql_query($query_error);
                }
                $retour = "<font color=\"#FF0000\">Error may be fatal : <i>" . $erreur_msg . "<i></font>";
                break;
        }
    }
    $result = pmb_mysql_query("SHOW TABLES LIKE 'db_update_logs'");
    if (pmb_mysql_num_rows($result)) {
        $query_log = " INSERT INTO db_update_logs (db_update_log_type, db_update_log_version, db_update_log_query, db_update_log_message, db_update_log_error, db_update_log_result)
        VALUES ('addon', '" . $db_update_log_version . $db_update_step . "', '" . addslashes($requete) . "', '" . addslashes($message) . "', $erreur_no, '" . addslashes(strip_tags($retour)) . "')";
        pmb_mysql_query($query_log);
    }
    return "<tr><td><font size='1'><span data-alter='action'>" . $message ."</span></font></td><td><font size='1'><span data-alter='result'>" . $retour . "</span></font></td></tr>";
}
echo "<table>";

/**
 * ****************** AJOUTER ICI LES MODIFICATIONS ******************************
 */

// Formate et verifie que $pmb_bdd_subversion est <=  $pmb_subversion_database_as_it_shouldbe
$pmb_bdd_subversion = intval($pmb_bdd_subversion);
$pmb_subversion_database_as_it_shouldbe = intval($pmb_subversion_database_as_it_shouldbe);
if($pmb_bdd_subversion > $pmb_subversion_database_as_it_shouldbe ) {
    $pmb_bdd_subversion =  $pmb_subversion_database_as_it_shouldbe;
}
$pmb_bdd_subversion_error = intval($pmb_bdd_subversion_error);

$db_update_log_version = "PMB : " . $pmb_version_brut . "." . $pmb_version_patch . "; BDD : " . $pmb_bdd_version . "_";
$db_update_step = $pmb_bdd_subversion;

//Raz erreur $pmb_bdd_subversion_error
if($pmb_bdd_subversion <= $pmb_bdd_subversion_error) {
    $query_raz = "UPDATE parametres SET valeur_param=0 WHERE type_param='pmb' AND sstype_param='bdd_subversion_error'";
    pmb_mysql_query($query_raz);
}

while ($db_update_step < $pmb_subversion_database_as_it_shouldbe) {
    switch ($db_update_step) {
        
        case 0:
            // DG - Texte apparaissant avant la liste des ouvrages dans le courrier ou mail d'invalidation
            if (pmb_mysql_num_rows(pmb_mysql_query("SELECT 1 FROM parametres WHERE type_param='pdflettreresa' AND sstype_param='before_list_unconfirmed'")) == 0) {
                $rqt = "INSERT INTO parametres (type_param, sstype_param, valeur_param, comment_param, section_param, gestion)
            VALUES ('pdflettreresa', 'before_list_unconfirmed', 'Suite  votre demande de rservation, nous vous informons que nous avons annul la confirmation du ou des ouvrages ci-dessous car ils ne sont pas disponibles  ces dates.', 'Texte apparaissant avant la liste des ouvrages dans le courrier ou mail d\'invalidation', '', 0)";
                echo traite_addon_rqt($rqt, 'INSERT pdflettreresa_before_list_unconfirmed INTO parametres');
            }
            
            // DG - Texte apparaissant avant la liste des ouvrages dans le courrier ou mail de suppression
            if (pmb_mysql_num_rows(pmb_mysql_query("SELECT 1 FROM parametres WHERE type_param='pdflettreresa' AND sstype_param='before_list_deleted'")) == 0) {
                $rqt = "INSERT INTO parametres (type_param, sstype_param, valeur_param, comment_param, section_param, gestion)
            VALUES ('pdflettreresa', 'before_list_deleted', 'Suite  votre demande de rservation, nous sommes dans le regret de vous informer que le ou les ouvrages ci-dessous ne sont pas disponibles.', 'Texte apparaissant avant la liste des ouvrages dans le courrier ou mail de suppression', '', 0)";
                echo traite_addon_rqt($rqt, 'INSERT pdflettreresa_before_list_deleted INTO parametres');
            }
            
            // DG - Texte apparaissant aprs la liste des ouvrages
            if (pmb_mysql_num_rows(pmb_mysql_query("SELECT 1 FROM parametres WHERE type_param='pdflettreresa' AND sstype_param='after_list_unconfirmed'")) == 0) {
                $rqt = "INSERT INTO parametres (type_param, sstype_param, valeur_param, comment_param, section_param, gestion)
            VALUES ('pdflettreresa', 'after_list_unconfirmed', '', 'Texte apparaissant aprs la liste des ouvrages dans le courrier ou mail d\'invalidation', '', 0)";
                echo traite_addon_rqt($rqt, 'INSERT pdflettreresa_after_list_unconfirmed INTO parametres');
            }
            
            // DG - Texte apparaissant aprs la liste des ouvrages
            if (pmb_mysql_num_rows(pmb_mysql_query("SELECT 1 FROM parametres WHERE type_param='pdflettreresa' AND sstype_param='after_list_deleted'")) == 0) {
                $rqt = "INSERT INTO parametres (type_param, sstype_param, valeur_param, comment_param, section_param, gestion)
            VALUES ('pdflettreresa', 'after_list_deleted', '', 'Texte apparaissant aprs la liste des ouvrages dans le courrier ou mail de suppression', '', 0)";
                echo traite_addon_rqt($rqt, 'INSERT pdflettreresa_after_list_deleted INTO parametres');
            }
            break;
        case 1:
            // DG - Gestion des groupes de champs personnaliss
            $rqt = "create table if not exists custom_fields_groups (
				id_group int(10) unsigned NOT NULL AUTO_INCREMENT,
				group_type varchar(255) not null default '',
				group_name varchar(255) not null default '',
				group_title varchar(255) not null default '',
                group_fields mediumtext,
	    		primary key (id_group)) ";
            echo traite_addon_rqt($rqt,"create table if not exists custom_fields_groups");
            break;
        case 2:
            // TS - ajout d'une option rgaa pour le parametre rmc_responsive
            $rqt = "UPDATE parametres SET comment_param = 'Affichage de la recherche multi-critres responsive .\n 0 : Non\n 1 : Oui\n 2 : Oui (compatible RGAA)' WHERE type_param = 'opac' AND sstype_param = 'rmc_responsive'  ";
            echo traite_addon_rqt($rqt, "UPDATE opac_rmc_responsive INTO parametres");
            break;
        case 3:
            // GN - Ajout d'une taille maximum pour le stockage des fichiers pour les listes de lecture avec la recherche smantique
            if (pmb_mysql_num_rows(pmb_mysql_query("SELECT 1 FROM parametres WHERE type_param='ai' AND sstype_param='empr_total_upload_max_size'")) == 0) {
                $rqt = "INSERT INTO parametres (type_param, sstype_param, valeur_param, comment_param, section_param, gestion)
                    VALUES ('ai', 'empr_total_upload_max_size', '10', 'Poids total des fichiers que le lecteur peut uploader en Mo', '', 0)";
                echo traite_addon_rqt($rqt, 'INSERT empr_total_upload_max_size INTO parametres artificial_intelligence');
            }
            
            // GN - Ajout dans la sous-session "Listes de lecture partages" dans "Intelligence artificielle"
            $rqt = "UPDATE parametres SET section_param = 'shared_lists' WHERE type_param = 'ai' AND sstype_param = 'empr_total_upload_max_size' AND section_param != 'shared_lists';";
            echo traite_addon_rqt($rqt, "UPDATE empr_total_upload_max_size SET section_param='shared_lists'");
            break;
        case 4:
            // JP - Dplacement du paramtre opac_meta_keywords dans les paramtres inutiliss
            if (pmb_mysql_num_rows(pmb_mysql_query("SELECT 1 FROM parametres WHERE type_param = 'opac' AND sstype_param = 'meta_keywords'")) != 0) {
                $rqt = "UPDATE parametres SET section_param = 'z_unused' WHERE type_param = 'opac' AND sstype_param = 'meta_keywords'";
                echo traite_addon_rqt($rqt, "UPDATE parametres SET section_param = 'z_unused' WHERE type_param = 'opac' AND sstype_param = 'meta_keywords'");
            }
            break;
        case 5:
            //DG - Ajout d'une colonne "num_increment_day_of_month" pour le jour de dpart du cycle (numro)
            if (pmb_mysql_num_rows(pmb_mysql_query("SHOW COLUMNS FROM custom_fields_groups LIKE 'group_title_button_add'")) == 0) {
                $rqt = "ALTER TABLE custom_fields_groups ADD group_title_button_add varchar(255) not null default '' AFTER group_title";
                echo traite_addon_rqt($rqt, "ALTER TABLE custom_fields_groups ADD group_title_button_add");
            }
            break;
    }
    $db_update_step ++;
}

/**
 * ****************** JUSQU'ICI *************************************************
 */
/* PENSER  faire +1 au paramtre $pmb_subversion_database_as_it_shouldbe dans includes/config.inc.php */
/* COMMITER les deux fichiers addon.inc.php ET config.inc.php en mme temps */
echo traite_addon_rqt("update parametres set valeur_param='" . $db_update_step . "' where type_param='pmb' and sstype_param='bdd_subversion'", "Update to $db_update_step database subversion.");
echo "<table>";
