<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: MusicMeApiClient.php,v 1.2.4.2 2025/10/30 08:23:56 gneveu Exp $

class MusicMeApiClient
{
    /**
     * URL de base de l'API
     */
    private $url;

    /**
     * Cl de sel
     */
    private $salt_key;

    /**
     * Cl de token
     */
    private $token_key;

    /**
     * Instance de la classe Curl
     */
    private $curl;

    /**
     * URL de base de l'API
     */
    public const DEFAULT_API_BASE_URL = "https://app.mt.musicme.com";

    /**
     * Nombre maximum de rsultats
     */
    public const DEFAULT_MAX_RESULTS = 100;

    /**
     * Constructeur
     *
     * @param string $url URL de base
     * @param string $salt_key Cl de sel
     * @param string $token_key Cl de token
     */
    public function __construct($url, $salt_key, $token_key)
    {
        $this->url = $url;
        $this->salt_key = $salt_key;
        $this->token_key = $token_key;
        $this->curl = new \Curl();
    }

    /**
     * Prparer les headers de requte avec authentification
     *
     * @return array Headers HTTP
     */
    protected function getHeaders()
    {
        $headers = [
            'Content-Type: application/json',
            'Accept: application/json',
            'X-Api-Salt: ' . $this->salt_key,
            'X-Api-Token: ' . $this->token_key
        ];

        return $headers;
    }

    /**
     * Effectuer une recherche sur l'API MusicMe
     *
     * @param array $query Paramtres de recherche
     * @return array|false Rsultats ou false en cas d'erreur
     */
    public function search($query)
    {

        // Construire l'URL de recherche
        $search_url = $this->url . "musicme/search";

        // Prparer les headers
        $this->curl->set_option('CURLOPT_HTTPHEADER', $this->getHeaders());

        // Effectuer la requte
        $response = $this->curl->get($search_url, $query);

        if (!$response || $response->headers['Status-Code'] != 200) {
            // Si erreur 401 (Unauthorized), peut-tre que le token a expir
            if ($response && $response->headers['Status-Code'] == 401) {
                return false;
            }
        }

        return json_decode($response->body, true);
    }
}
