<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: TransformerPMB.php,v 1.5.2.2 2025/06/27 14:21:05 rtigero Exp $

namespace Pmb\ImportExport\Models\Transformers\TransformerPMB;

use Pmb\ImportExport\Models\Transformers\Transformer;

global $base_path;

class TransformerPMB extends Transformer
{

    protected static $pmbFunctions = null;

    public function transform($inEntity)
    {
        if(empty($this->settings['converterFunction'])) {
            return $inEntity;
        }

        $indexConverterFunction = static::getIndexConverterFunction($this->settings['converterFunction']);
        if ($indexConverterFunction === false) {
            return $inEntity;
        }
        $convert = new \convert($inEntity, $indexConverterFunction, true, true);
        $convert->transform();
        $outEntity = $convert->get_header() . $convert->transform() . $convert->get_footer();

        return $outEntity;
    }

    public static function pmbFunctions()
    {
        global $base_path;

        if(!is_null(static::$pmbFunctions)) {
            return static::$pmbFunctions;
        }
        static::$pmbFunctions = [];
        //Lecture des diffrents imports possibles
        if (file_exists($base_path . "/admin/convert/imports/catalog_subst.xml")) {
            $fic_catal = $base_path . "/admin/convert/imports/catalog_subst.xml";
        } else {
            $fic_catal = $base_path . "/admin/convert/imports/catalog.xml";
        }
        $parser = _parser_text_no_function_(file_get_contents($fic_catal), "CATALOG");

        foreach ($parser['ITEM'] as $item) {
            if (!isset($item['visible']) || $item['visible'] != 'no') {
                static::$pmbFunctions[] = ['value' => $item['PATH'], 'label' => $item['NAME']];
            }
        }

        return static::$pmbFunctions;
    }

    protected static function getIndexConverterFunction($name)
    {
        $functions = static::pmbFunctions();
        foreach ($functions as $index=>$function) {
            if ($function['value'] == $name) {
                return $index;
            }
        }
        return false;
    }
}
