<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: StepExport.php,v 1.4.2.2 2025/06/27 14:20:59 rtigero Exp $

namespace Pmb\ImportExport\Models\Steps\StepExport;

use Pmb\ImportExport\Models\ImportExportParserDirectory;
use Pmb\ImportExport\Models\Profiles\ProfileExport;
use Pmb\ImportExport\Models\Steps\Step;

class StepExport extends Step
{

    public function execute($sourceData = array())
    {
        if ($this->stepSettings->exportType && class_exists($this->stepSettings->exportType)) {
            // if ($this->source->getOutFormat() == "pmbrdf" && isset($this->stepSettings->profile)) {
            //     $exportProfile = new ProfileExport(intval($this->stepSettings->profile));
            //     $exportProfile->setStore($this->source->getRDFTransformer()->getStore());
            //     $exportProfile->applyProfile();
            // }
            $export = new $this->stepSettings->exportType($this->id, $this->caller, true);
            $export->setSource($this->source);
            $export->setBaseParameters($this->stepSettings->{$this->stepSettings->exportType});
            $export->execute($sourceData);
        }
    }

    /**
     * Retourne un tableau contenant les diffrents types d'export disponibles
     *
     * @return array
     */
    public static function getExportTypes()
    {
        $exportTypes = array();

        $parser = ImportExportParserDirectory::getInstance();
        $manifests = $parser->getManifests(str_replace('\\', '/', __NAMESPACE__));
        foreach ($manifests as $manifest) {
            if ($manifest->namespace == self::class) {
                continue;
            }
            $messages = $manifest->namespace::getMessages();
            $exportTypes[] = array(
                "type" => $manifest->type,
                "namespace" => $manifest->namespace,
                "settings" => $manifest->settings,
                "messages" => $messages
            );
        }
        return $exportTypes;
    }

    public static function getExportProfiles()
    {
        $result = array();
        $profileImport = new ProfileExport();
        $list = $profileImport->getList();
        foreach ($list as $profile) {
            $result[] = array(
                'value' => $profile->id,
                'label' => $profile->profileName
            );
        }
        return $result;
    }
}
