<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: SourcePMB.php,v 1.3.2.2 2025/06/27 14:20:55 rtigero Exp $

namespace Pmb\ImportExport\Models\Sources\SourcePMB;

use authorities_caddie;
use caddie;
use Pmb\ImportExport\Models\Sources\Source;

class SourcePMB extends Source
{
    public function initSync()
    {
        $parameters = $this->contextParameters;
        if ($this->baseParameters["profile"]) {
            $parameters["profile"] = $this->baseParameters["profile"];
        }
        $this->chunk = new $this->baseParameters["entryFormat"](null, $parameters);
        return true;
    }

    public function closeSync() {}

    public static function getOwners()
    {
        global $msg;

        $owners = [
            [
                'value' => 0,
                'label' => $msg['admin_convert_propri']
            ]
        ];
        $query = "SELECT idlender, lender_libelle FROM lenders";
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            while ($row = pmb_mysql_fetch_assoc($result)) {
                $owners[] = [
                    'value' => $row['idlender'],
                    'label' => $row['lender_libelle']
                ];
            }
        }
        return $owners;
    }
    public static function getTypdocs()
    {
        $typdocs = [];

        $query = "SELECT idtyp_doc, concat(tdoc_libelle) as lib FROM docs_type ORDER BY lib";
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            while ($row = pmb_mysql_fetch_assoc($result)) {
                $typdocs[] = [
                    'value' => $row['idtyp_doc'],
                    'label' => $row['lib']
                ];
            }
        }

        return $typdocs;
    }
    public static function getStatutes()
    {
        $statutes = [];

        $query = "SELECT idstatut, concat(statut_libelle) as lib FROM docs_statut ORDER BY lib";
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            while ($row = pmb_mysql_fetch_assoc($result)) {
                $statutes[] = [
                    'value' => $row['idstatut'],
                    'label' => $row['lib']
                ];
            }
        }

        return $statutes;
    }

    public static function getCaddies()
    {
        $carts = [];
        $rawCartList = array_merge(authorities_caddie::get_cart_list(), caddie::get_cart_list());

        foreach ($rawCartList as $cart) {
            if (! isset($carts[$cart["type"]])) {
                $carts[$cart["type"]] = array();
            }
            $carts[$cart["type"]][] = array(
                "value" => $cart["idcaddie"],
                "label" => $cart["name"]
            );
        }

        return $carts;
    }
}
